/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.StatusBit;

public class CLx
extends Instruction {
    private final StatusBit bit;
    public static final long serialVersionUID = 1L;

    public CLx(M6502 cpu, StatusBit bit) {
        super(cpu);
        this.bit = bit;
    }

    @Override
    public int fetch() {
        return 2;
    }

    @Override
    public void execute() {
        switch (this.bit) {
            case bCARRY: {
                this.cpu.CARRY = false;
                break;
            }
            case bDECIMAL_MODE: {
                this.cpu.DECIMAL_MODE = false;
                break;
            }
            case bINTERRUPT_DISABLE: {
                this.cpu.INTERRUPT_DISABLE = false;
                break;
            }
            case bOVERFLOW: {
                this.cpu.OVERFLOW = false;
                break;
            }
            default: {
                throw new IllegalStateException("CLx Invalid StatusBit: " + (Object)((Object)this.bit));
            }
        }
    }
}

