/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.Register;

public class DEx
extends Instruction {
    private final Register reg;
    public static final long serialVersionUID = 1L;

    public DEx(M6502 cpu, Register reg) {
        super(cpu);
        this.reg = reg;
    }

    @Override
    public int fetch() {
        return 2;
    }

    @Override
    public void execute() {
        byte val;
        switch (this.reg) {
            case rX: {
                this.cpu.X = val = (byte)(this.cpu.X - 1);
                break;
            }
            case rY: {
                this.cpu.Y = val = (byte)(this.cpu.Y - 1);
                break;
            }
            default: {
                throw new IllegalStateException("DEx Invalid Register: " + (Object)((Object)this.reg));
            }
        }
        this.cpu.ZERO = val == 0;
        this.cpu.NEGATIVE = val < 0;
    }
}

