/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.M6502;
import general.m6502.UndocumentedInstruction;

public class uARR
extends UndocumentedInstruction {
    private int ea;
    public static final long serialVersionUID = 1L;

    public uARR(M6502 cpu) {
        super(cpu);
    }

    @Override
    public int fetch() {
        this.ea = this.cpu.fetchImmediateAddress();
        return 2;
    }

    @Override
    public void execute() {
        byte val = (byte)(this.cpu.A & this.cpu.memory.readByte(this.ea));
        int oldCarry = this.cpu.CARRY ? 1 : 0;
        this.cpu.A = val = (byte)(((val & 0xFF) >>> 1) + oldCarry * 128);
        this.cpu.ZERO = val == 0;
        this.cpu.NEGATIVE = val < 0;
        switch (this.cpu.A & 0x60) {
            case 96: {
                this.cpu.CARRY = true;
                this.cpu.OVERFLOW = false;
                break;
            }
            case 0: {
                this.cpu.CARRY = false;
                this.cpu.OVERFLOW = false;
                break;
            }
            case 32: {
                this.cpu.CARRY = false;
                this.cpu.OVERFLOW = true;
                break;
            }
            case 64: {
                this.cpu.CARRY = true;
                this.cpu.OVERFLOW = true;
            }
        }
    }
}

