/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.M6502;
import general.m6502.OperandType;
import general.m6502.UndocumentedInstruction;

public class uRLA
extends UndocumentedInstruction {
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public uRLA(M6502 cpu, OperandType type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 5;
            }
            case Z_PAGE_X: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 6;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 6;
            }
            case ABS_X: {
                this.ea = this.cpu.fetchAbsoluteXAddress();
                return 7;
            }
            case ABS_Y: {
                this.ea = this.cpu.fetchAbsoluteYAddress();
                return 7;
            }
            case IND_X: {
                this.ea = this.cpu.fetchIndirectXAddress();
                return 8;
            }
            case IND_Y: {
                this.ea = this.cpu.fetchIndirectYAddress();
                return 8;
            }
        }
        throw new IllegalStateException("uRLA Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        byte val = this.cpu.memory.readByte(this.ea);
        int oldCarry = this.cpu.CARRY ? 1 : 0;
        this.cpu.CARRY = val < 0;
        val = (byte)((val << 1) + oldCarry);
        this.cpu.memory.writeByte(this.ea, val);
        this.cpu.A = (byte)(this.cpu.A & val);
        this.cpu.ZERO = val == 0;
        this.cpu.NEGATIVE = val < 0;
    }
}

