/*
 * Decompiled with CFR 0.152.
 */
package parameters;

import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import utils.Terminator;

public class Parameters {
    public static String mainArg = null;
    public static double TIA_FORCED_CLOCK = 0.0;
    public static double TIA_DEFAULT_CLOCK_NTSC = 60.0;
    public static double TIA_DEFAULT_CLOCK_PAL = 50.39;
    public static boolean TIA_SYNC_WITH_AUDIO_MONITOR = false;
    public static boolean TIA_SYNC_WITH_VIDEO_MONITOR = false;
    public static int TIA_AUDIO_SAMPLE_RATE = 31430;
    public static float TIA_AUDIO_MAX_AMPLITUDE = 0.5f;
    public static float TIA_AUDIO_MAX_MONO_CHANNEL_AMPLITUDE = 0.5f;
    public static float TIA_AUDIO_MAX_STEREO_CHANNEL_AMPLITUDE = 0.9f;
    public static int RAM_FRY_ZERO_BITS = 100;
    public static int RAM_FRY_ONE_BITS = 25;
    public static float RAM_FRY_VARIANCE = 0.3f;
    public static double SCREEN_DEFAULT_FPS = -1.0;
    public static int SCREEN_DEFAULT_ORIGIN_X = 10;
    public static double SCREEN_DEFAULT_ORIGIN_Y_PCT = 12.0;
    public static int SCREEN_DEFAULT_WIDTH = 160;
    public static double SCREEN_DEFAULT_HEIGHT_PCT = 81.5;
    public static float SCREEN_DEFAULT_SCALE_X = 4.0f;
    public static float SCREEN_DEFAULT_SCALE_Y = 2.0f;
    public static float SCREEN_DEFAULT_SCALE_ASPECT_X = 2.0f;
    public static int SCREEN_BORDER_SIZE = 3;
    public static int SCREEN_OSD_FRAMES = 160;
    public static int SCREEN_VSYNC_TOLERANCE = 10;
    public static boolean SCREEN_QUALITY_RENDERING = false;
    public static int SCREEN_CRT_MODE = 0;
    public static float SCREEN_CRT_RETENTION_ALPHA = 0.75f;
    public static float SCREEN_SCANLINES_STRENGTH = 0.5f;
    public static int SCREEN_MULTI_BUFFERING = 2;
    public static boolean SCREEN_PAGE_FLIPPING = true;
    public static int SCREEN_BUFFER_VSYNC = -1;
    public static float SCREEN_FRAME_ACCELERATION = 0.0f;
    public static float SCREEN_INTERM_FRAME_ACCELERATION = -1.0f;
    public static float SCREEN_SCANLINES_ACCELERATION = -1.0f;
    public static boolean SCREEN_CARTRIDGE_CHANGE = true;
    public static boolean SCREEN_FULLSCREEN = false;
    public static double SPEAKER_DEFAULT_FPS = -1.0;
    public static int SPEAKER_INPUT_BUFFER_SIZE = 1536;
    public static int SPEAKER_OUTPUT_BUFFER_SIZE = 768;
    public static int SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME = 5;
    public static int SPEAKER_NO_DATA_SLEEP_TIME = 20;
    public static int SPEAKER_ADDED_THREAD_PRIORITY = 0;
    public static int CONSOLE_FAST_SPEED_FACTOR = 8;
    public static boolean BUS_DATA_RETENTION = true;
    public static String SERVER_SERVICE_NAME = "AtariP1Server";
    public static int SERVER_SERVICE_PORT = 9998;
    public static int SERVER_MAX_UPDATES_PENDING = 20;
    public static int CLIENT_MAX_UPDATES_PENDING = 20;
    private static Properties props = new Properties();
    private static Preferences userPreferences;
    private static boolean userPreferencesAsked;

    static {
        userPreferencesAsked = false;
    }

    public static void init(String[] args) {
        Parameters.parseMainArg(args);
        Parameters.loadPropertiesFile();
        Parameters.parseOptions(args);
        Parameters.processProperties();
    }

    public static String readPreference(String name) {
        if (Parameters.getUserPreferences() == null) {
            return null;
        }
        return Parameters.getUserPreferences().get(name, "");
    }

    public static boolean storePreference(String name, String value) {
        if (Parameters.getUserPreferences() == null) {
            return false;
        }
        Parameters.getUserPreferences().put(name, value);
        return true;
    }

    public static Preferences getUserPreferences() {
        if (!userPreferencesAsked) {
            try {
                userPreferencesAsked = true;
                userPreferences = Preferences.userRoot().node("javatari");
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return userPreferences;
    }

    private static void parseMainArg(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (!arg.startsWith("-")) {
                mainArg = arg;
                return;
            }
            ++n2;
        }
    }

    private static void parseOptions(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.startsWith("-")) {
                String opt = arg.substring(1);
                Pattern p = Pattern.compile("=");
                String[] params = p.split(opt);
                if (params == null || params.length != 2 || params[0].isEmpty() || params[1].isEmpty()) {
                    System.out.println("Invalid option format: " + arg);
                    Terminator.terminate();
                }
                props.put(params[0].toUpperCase(), params[1]);
            }
            ++n2;
        }
    }

    private static void loadPropertiesFile() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("parameters/javatari.properties");
        try {
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (Exception ex) {
            System.out.println("parameters/javatari.properties not found, using defaults");
        }
        try {
            props.putAll((Map<?, ?>)System.getProperties());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    private static void processProperties() {
        try {
            String val = props.getProperty("TIA_FORCED_CLOCK");
            if (val != null) {
                TIA_FORCED_CLOCK = Double.valueOf(val);
            }
            if ((val = props.getProperty("TIA_DEFAULT_CLOCK_NTSC")) != null) {
                TIA_DEFAULT_CLOCK_NTSC = Double.valueOf(val);
            }
            if ((val = props.getProperty("TIA_DEFAULT_CLOCK_PAL")) != null) {
                TIA_DEFAULT_CLOCK_PAL = Double.valueOf(val);
            }
            if ((val = props.getProperty("TIA_SYNC_WITH_AUDIO_MONITOR")) != null) {
                TIA_SYNC_WITH_AUDIO_MONITOR = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("TIA_SYNC_WITH_VIDEO_MONITOR")) != null) {
                TIA_SYNC_WITH_VIDEO_MONITOR = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("TIA_AUDIO_SAMPLE_RATE")) != null) {
                TIA_AUDIO_SAMPLE_RATE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("TIA_AUDIO_MAX_AMPLITUDE")) != null) {
                TIA_AUDIO_MAX_AMPLITUDE = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("TIA_AUDIO_MAX_MONO_CHANNEL_AMPLITUDE")) != null) {
                TIA_AUDIO_MAX_MONO_CHANNEL_AMPLITUDE = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("TIA_AUDIO_MAX_STEREO_CHANNEL_AMPLITUDE")) != null) {
                TIA_AUDIO_MAX_STEREO_CHANNEL_AMPLITUDE = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("RAM_FRY_ZERO_BITS")) != null) {
                RAM_FRY_ZERO_BITS = Integer.valueOf(val);
            }
            if ((val = props.getProperty("RAM_FRY_ONE_BITS")) != null) {
                RAM_FRY_ONE_BITS = Integer.valueOf(val);
            }
            if ((val = props.getProperty("RAM_FRY_VARIANCE")) != null) {
                RAM_FRY_VARIANCE = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_FPS")) != null) {
                SCREEN_DEFAULT_FPS = Double.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_ORIGIN_X")) != null) {
                SCREEN_DEFAULT_ORIGIN_X = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_ORIGIN_Y_PCT")) != null) {
                SCREEN_DEFAULT_ORIGIN_Y_PCT = Double.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_WIDTH")) != null) {
                SCREEN_DEFAULT_WIDTH = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_HEIGHT_PCT")) != null) {
                SCREEN_DEFAULT_HEIGHT_PCT = Double.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_SCALE_X")) != null) {
                SCREEN_DEFAULT_SCALE_X = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_SCALE_Y")) != null) {
                SCREEN_DEFAULT_SCALE_Y = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_DEFAULT_SCALE_ASPECT_X")) != null) {
                SCREEN_DEFAULT_SCALE_ASPECT_X = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_BORDER_SIZE")) != null) {
                SCREEN_BORDER_SIZE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_OSD_FRAMES")) != null) {
                SCREEN_OSD_FRAMES = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_VSYNC_TOLERANCE")) != null) {
                SCREEN_VSYNC_TOLERANCE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_QUALITY_RENDERING")) != null) {
                SCREEN_QUALITY_RENDERING = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_CRT_MODE")) != null) {
                SCREEN_CRT_MODE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_CRT_RETENTION_ALPHA")) != null) {
                SCREEN_CRT_RETENTION_ALPHA = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_SCANLINES_STRENGTH")) != null) {
                SCREEN_SCANLINES_STRENGTH = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_MULTI_BUFFERING")) != null) {
                SCREEN_MULTI_BUFFERING = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_PAGE_FLIPPING")) != null) {
                SCREEN_PAGE_FLIPPING = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_BUFFER_VSYNC")) != null) {
                SCREEN_BUFFER_VSYNC = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_FRAME_ACCELERATION")) != null) {
                SCREEN_FRAME_ACCELERATION = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_INTERM_FRAME_ACCELERATION")) != null) {
                SCREEN_INTERM_FRAME_ACCELERATION = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_SCANLINES_ACCELERATION")) != null) {
                SCREEN_SCANLINES_ACCELERATION = Float.valueOf(val).floatValue();
            }
            if ((val = props.getProperty("SCREEN_CARTRIDGE_CHANGE")) != null) {
                SCREEN_CARTRIDGE_CHANGE = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SCREEN_FULLSCREEN")) != null) {
                SCREEN_FULLSCREEN = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_DEFAULT_FPS")) != null) {
                SPEAKER_DEFAULT_FPS = Double.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_INPUT_BUFFER_SIZE")) != null) {
                SPEAKER_INPUT_BUFFER_SIZE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_OUTPUT_BUFFER_SIZE")) != null) {
                SPEAKER_OUTPUT_BUFFER_SIZE = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME")) != null) {
                SPEAKER_OUTPUT_BUFFER_FULL_SLEEP_TIME = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_NO_DATA_SLEEP_TIME")) != null) {
                SPEAKER_NO_DATA_SLEEP_TIME = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SPEAKER_ADDED_THREAD_PRIORITY")) != null) {
                SPEAKER_ADDED_THREAD_PRIORITY = Integer.valueOf(val);
            }
            if ((val = props.getProperty("CONSOLE_FAST_SPEED_FACTOR")) != null) {
                CONSOLE_FAST_SPEED_FACTOR = Integer.valueOf(val);
            }
            if ((val = props.getProperty("BUS_DATA_RETENTION")) != null) {
                BUS_DATA_RETENTION = Boolean.valueOf(val);
            }
            if ((val = props.getProperty("SERVER_SERVICE_NAME")) != null) {
                SERVER_SERVICE_NAME = String.valueOf(val);
            }
            if ((val = props.getProperty("SERVER_SERVICE_PORT")) != null) {
                SERVER_SERVICE_PORT = Integer.valueOf(val);
            }
            if ((val = props.getProperty("SERVER_MAX_UPDATES_PENDING")) != null) {
                SERVER_MAX_UPDATES_PENDING = Integer.valueOf(val);
            }
            if ((val = props.getProperty("CLIENT_MAX_UPDATES_PENDING")) != null) {
                CLIENT_MAX_UPDATES_PENDING = Integer.valueOf(val);
            }
        }
        catch (Exception ex) {
            System.out.println("Error processing properties:\n" + ex);
            Terminator.terminate();
        }
    }
}

