/*
 * Decompiled with CFR 0.152.
 */
package pc.controls;

import atari.controls.ConsoleControls;
import atari.controls.ConsoleControlsInput;
import general.av.video.VideoMonitor;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;

public class AWTConsoleControls
implements ConsoleControls,
KeyListener {
    private boolean p1ControlsMode = false;
    private boolean paddleMode = false;
    private int paddle0Position = 0;
    private int paddle0Speed = 2;
    private boolean paddle0MovingLeft = false;
    private boolean paddle0MovingRight = false;
    private int paddle1Position = 0;
    private int paddle1Speed = 2;
    private boolean paddle1MovingLeft = false;
    private boolean paddle1MovingRight = false;
    private PaddlesPositionUpdater paddlePositionUpdater;
    private final VideoMonitor videoMonitor;
    private ConsoleControlsInput consoleControlsInput;
    private final Map<Integer, ConsoleControls.Control> keyCodeMap = new HashMap<Integer, ConsoleControls.Control>();
    private final Map<Integer, ConsoleControls.Control> keyControlCodeMap = new HashMap<Integer, ConsoleControls.Control>();
    private final Map<Integer, ConsoleControls.Control> keyAltCodeMap = new HashMap<Integer, ConsoleControls.Control>();
    private final Map<ConsoleControls.Control, Boolean> controlStateMap = new HashMap<ConsoleControls.Control, Boolean>();
    private static final int KEY_P0_UP = 38;
    private static final int KEY_P0_DOWN = 40;
    private static final int KEY_P0_LEFT = 37;
    private static final int KEY_P0_RIGHT = 39;
    private static final int KEY_P0_BUTTON = 32;
    private static final int KEY_P0_BUTTON2 = 155;
    private static final int KEY_P0_BUTTON3 = 127;
    private static final int KEY_P1_UP = 84;
    private static final int KEY_P1_DOWN = 71;
    private static final int KEY_P1_LEFT = 70;
    private static final int KEY_P1_RIGHT = 72;
    private static final int KEY_P1_BUTTON = 65;
    private static final int KEY_POWER = 112;
    private static final int KEY_BLACK_WHITE = 113;
    private static final int KEY_DIFFICULTY0 = 115;
    private static final int KEY_DIFFICULTY1 = 120;
    private static final int KEY_SELECT = 122;
    private static final int KEY_RESET = 123;
    private static final int KEY_PAUSE = 80;
    private static final int KEY_FRAME = 70;
    private static final int KEY_TRACE = 84;
    private static final int KEY_FAST_SPEED = 9;
    private static final int KEY_DEBUG = 68;
    private static final int KEY_NO_COLLISIONS = 67;
    private static final int KEY_VIDEO_STANDARD = 86;
    private static final int KEY_STATE_0 = 222;
    private static final int KEY_STATE_1 = 49;
    private static final int KEY_STATE_2 = 50;
    private static final int KEY_STATE_3 = 51;
    private static final int KEY_STATE_4 = 52;
    private static final int KEY_STATE_5 = 53;
    private static final int KEY_STATE_6 = 54;
    private static final int KEY_STATE_7 = 55;
    private static final int KEY_STATE_8 = 56;
    private static final int KEY_STATE_9 = 57;
    private static final int KEY_STATE_10 = 48;
    private static final int KEY_STATE_11 = 45;
    private static final int KEY_STATE_12 = 61;
    private static final int KEY_LOCAL_P1_MODE = 74;
    private static final int KEY_LOCAL_PADDLE_MODE = 76;
    private static final ConsoleControls.Control[] playerDigitalControls = new ConsoleControls.Control[]{ConsoleControls.Control.JOY0_UP, ConsoleControls.Control.JOY0_DOWN, ConsoleControls.Control.JOY0_LEFT, ConsoleControls.Control.JOY0_RIGHT, ConsoleControls.Control.JOY0_BUTTON, ConsoleControls.Control.JOY1_UP, ConsoleControls.Control.JOY1_DOWN, ConsoleControls.Control.JOY1_LEFT, ConsoleControls.Control.JOY1_RIGHT, ConsoleControls.Control.JOY1_BUTTON, ConsoleControls.Control.PADDLE0_BUTTON, ConsoleControls.Control.PADDLE1_BUTTON};

    public AWTConsoleControls(ConsoleControlsInput input, VideoMonitor monitor, Component ... sourceComponents) {
        this.videoMonitor = monitor;
        this.consoleControlsInput = input;
        int i = 0;
        while (i < sourceComponents.length) {
            sourceComponents[i].setFocusTraversalKeysEnabled(false);
            sourceComponents[i].addKeyListener(this);
            ++i;
        }
        this.init();
    }

    public void p1ControlsMode(boolean state) {
        this.p1ControlsMode = state;
    }

    public void paddleMode(boolean state) {
        this.paddleMode = state;
        this.paddle1MovingRight = false;
        this.paddle1MovingLeft = false;
        this.paddle0MovingRight = false;
        this.paddle0MovingLeft = false;
        this.paddle1Speed = 2;
        this.paddle0Speed = 2;
        this.paddle1Position = this.paddleMode ? 190 : -1;
        this.paddle0Position = this.paddle1Position;
        ConsoleControls.Control[] controlArray = playerDigitalControls;
        int n = playerDigitalControls.length;
        int n2 = 0;
        while (n2 < n) {
            ConsoleControls.Control control = controlArray[n2];
            this.consoleControlsInput.controlStateChanged(control, false);
            ++n2;
        }
        this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE0_POSITION, this.paddle0Position);
        this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE1_POSITION, this.paddle1Position);
        this.videoMonitor.showOSD(String.valueOf(this.paddleMode ? "Paddles" : "Joysticks") + " connected");
        if (this.paddleMode) {
            if (this.paddlePositionUpdater != null && this.paddlePositionUpdater.isAlive()) {
                return;
            }
            this.paddlePositionUpdater = new PaddlesPositionUpdater();
            this.paddlePositionUpdater.start();
        } else {
            if (this.paddlePositionUpdater == null || !this.paddlePositionUpdater.isAlive()) {
                return;
            }
            try {
                this.paddlePositionUpdater.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.paddlePositionUpdater = null;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiersEx();
        if (this.p1ControlsMode) {
            keyCode = this.translateP1PriorityKeyCode(keyCode);
        }
        if (this.checkLocalControlKeyPressed(keyCode, modifiers)) {
            return;
        }
        ConsoleControls.Control control = this.controlForEvent(keyCode, modifiers);
        if (control == null) {
            return;
        }
        Boolean state = this.controlStateMap.get((Object)control);
        if (state == null || !state.booleanValue()) {
            this.controlStateMap.put(control, true);
            this.consoleControlsInput.controlStateChanged(control, true);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        int modifiers = e.getModifiersEx();
        if (this.p1ControlsMode) {
            keyCode = this.translateP1PriorityKeyCode(keyCode);
        }
        if (this.checkLocalControlKeyReleased(keyCode, modifiers)) {
            return;
        }
        ConsoleControls.Control control = this.controlForEvent(keyCode, modifiers);
        if (control == null) {
            return;
        }
        Boolean state = this.controlStateMap.get((Object)control);
        if (state == null || state.booleanValue()) {
            this.controlStateMap.put(control, false);
            this.consoleControlsInput.controlStateChanged(control, false);
        }
    }

    private boolean checkLocalControlKeyPressed(int keyCode, int modif) {
        if (modif == 512) {
            switch (keyCode) {
                case 74: {
                    this.p1ControlsMode = !this.p1ControlsMode;
                    this.videoMonitor.showOSD(String.valueOf(this.p1ControlsMode ? "P2" : "P1") + " controls mode");
                    return true;
                }
                case 76: {
                    this.paddleMode(!this.paddleMode);
                    return true;
                }
            }
        }
        if (this.paddleMode) {
            switch (keyCode) {
                case 37: {
                    this.paddle0MovingLeft = true;
                    return true;
                }
                case 39: {
                    this.paddle0MovingRight = true;
                    return true;
                }
                case 38: {
                    if (this.paddle0Speed < 10) {
                        ++this.paddle0Speed;
                    }
                    this.videoMonitor.showOSD("Paddle 1 speed: " + this.paddle0Speed);
                    return true;
                }
                case 40: {
                    if (this.paddle0Speed > 1) {
                        --this.paddle0Speed;
                    }
                    this.videoMonitor.showOSD("Paddle 1 speed: " + this.paddle0Speed);
                    return true;
                }
                case 70: {
                    this.paddle1MovingLeft = true;
                    return true;
                }
                case 72: {
                    this.paddle1MovingRight = true;
                    return true;
                }
                case 84: {
                    if (this.paddle1Speed < 10) {
                        ++this.paddle1Speed;
                    }
                    this.videoMonitor.showOSD("Paddle 2 speed: " + this.paddle1Speed);
                    return true;
                }
                case 71: {
                    if (this.paddle1Speed > 1) {
                        --this.paddle1Speed;
                    }
                    this.videoMonitor.showOSD("Paddle 2 speed: " + this.paddle1Speed);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkLocalControlKeyReleased(int keyCode, int modif) {
        if (this.paddleMode) {
            switch (keyCode) {
                case 37: {
                    this.paddle0MovingLeft = false;
                    return true;
                }
                case 39: {
                    this.paddle0MovingRight = false;
                    return true;
                }
                case 70: {
                    this.paddle1MovingLeft = false;
                    return true;
                }
                case 72: {
                    this.paddle1MovingRight = false;
                    return true;
                }
            }
        }
        return false;
    }

    private ConsoleControls.Control controlForEvent(int keyCode, int modif) {
        ConsoleControls.Control control = null;
        switch (modif) {
            case 0: {
                control = this.keyCodeMap.get(keyCode);
                break;
            }
            case 128: {
                control = this.keyControlCodeMap.get(keyCode);
                break;
            }
            case 512: {
                control = this.keyAltCodeMap.get(keyCode);
            }
        }
        if (control == null) {
            return null;
        }
        if (this.paddleMode) {
            return this.translatePaddleModeControl(control);
        }
        return control;
    }

    private int translateP1PriorityKeyCode(int keyCode) {
        switch (keyCode) {
            case 38: {
                return 84;
            }
            case 40: {
                return 71;
            }
            case 37: {
                return 70;
            }
            case 39: {
                return 72;
            }
            case 32: {
                return 65;
            }
            case 155: {
                return 65;
            }
            case 127: {
                return 65;
            }
            case 84: {
                return 38;
            }
            case 71: {
                return 40;
            }
            case 70: {
                return 37;
            }
            case 72: {
                return 39;
            }
            case 65: {
                return 32;
            }
        }
        return keyCode;
    }

    private ConsoleControls.Control translatePaddleModeControl(ConsoleControls.Control control) {
        switch (control) {
            case JOY0_BUTTON: {
                return ConsoleControls.Control.PADDLE0_BUTTON;
            }
            case JOY1_BUTTON: {
                return ConsoleControls.Control.PADDLE1_BUTTON;
            }
            case JOY0_UP: 
            case JOY0_DOWN: 
            case JOY0_LEFT: 
            case JOY0_RIGHT: 
            case JOY1_UP: 
            case JOY1_DOWN: 
            case JOY1_LEFT: 
            case JOY1_RIGHT: {
                return null;
            }
        }
        return control;
    }

    private void paddlesUpdatePosition() {
        if (this.paddle0MovingRight) {
            if (!this.paddle0MovingLeft) {
                this.paddle0Position -= this.paddle0Speed;
                if (this.paddle0Position < 0) {
                    this.paddle0Position = 0;
                }
                this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE0_POSITION, this.paddle0Position);
            }
        } else if (this.paddle0MovingLeft) {
            this.paddle0Position += this.paddle0Speed;
            if (this.paddle0Position > 380) {
                this.paddle0Position = 380;
            }
            this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE0_POSITION, this.paddle0Position);
        }
        if (this.paddle1MovingRight) {
            if (!this.paddle1MovingLeft) {
                this.paddle1Position -= this.paddle1Speed;
                if (this.paddle1Position < 0) {
                    this.paddle1Position = 0;
                }
                this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE1_POSITION, this.paddle1Position);
            }
        } else if (this.paddle1MovingLeft) {
            this.paddle1Position += this.paddle1Speed;
            if (this.paddle1Position > 380) {
                this.paddle1Position = 380;
            }
            this.consoleControlsInput.controlStateChanged(ConsoleControls.Control.PADDLE1_POSITION, this.paddle1Position);
        }
    }

    private void init() {
        this.keyCodeMap.put(37, ConsoleControls.Control.JOY0_LEFT);
        this.keyCodeMap.put(38, ConsoleControls.Control.JOY0_UP);
        this.keyCodeMap.put(39, ConsoleControls.Control.JOY0_RIGHT);
        this.keyCodeMap.put(40, ConsoleControls.Control.JOY0_DOWN);
        this.keyCodeMap.put(32, ConsoleControls.Control.JOY0_BUTTON);
        this.keyCodeMap.put(155, ConsoleControls.Control.JOY0_BUTTON);
        this.keyCodeMap.put(127, ConsoleControls.Control.JOY0_BUTTON);
        this.keyCodeMap.put(70, ConsoleControls.Control.JOY1_LEFT);
        this.keyCodeMap.put(84, ConsoleControls.Control.JOY1_UP);
        this.keyCodeMap.put(72, ConsoleControls.Control.JOY1_RIGHT);
        this.keyCodeMap.put(71, ConsoleControls.Control.JOY1_DOWN);
        this.keyCodeMap.put(65, ConsoleControls.Control.JOY1_BUTTON);
        this.keyCodeMap.put(112, ConsoleControls.Control.POWER);
        this.keyCodeMap.put(113, ConsoleControls.Control.BLACK_WHITE);
        this.keyCodeMap.put(115, ConsoleControls.Control.DIFFICULTY0);
        this.keyCodeMap.put(120, ConsoleControls.Control.DIFFICULTY1);
        this.keyCodeMap.put(122, ConsoleControls.Control.SELECT);
        this.keyCodeMap.put(123, ConsoleControls.Control.RESET);
        this.keyCodeMap.put(9, ConsoleControls.Control.FAST_SPEED);
        this.keyAltCodeMap.put(112, ConsoleControls.Control.POWER_FRY);
        this.keyAltCodeMap.put(80, ConsoleControls.Control.PAUSE);
        this.keyAltCodeMap.put(70, ConsoleControls.Control.FRAME);
        this.keyAltCodeMap.put(84, ConsoleControls.Control.TRACE);
        this.keyAltCodeMap.put(68, ConsoleControls.Control.DEBUG);
        this.keyAltCodeMap.put(67, ConsoleControls.Control.NO_COLLISIONS);
        this.keyAltCodeMap.put(86, ConsoleControls.Control.VIDEO_STANDARD);
        this.keyControlCodeMap.put(222, ConsoleControls.Control.SAVE_STATE_0);
        this.keyControlCodeMap.put(49, ConsoleControls.Control.SAVE_STATE_1);
        this.keyControlCodeMap.put(50, ConsoleControls.Control.SAVE_STATE_2);
        this.keyControlCodeMap.put(51, ConsoleControls.Control.SAVE_STATE_3);
        this.keyControlCodeMap.put(52, ConsoleControls.Control.SAVE_STATE_4);
        this.keyControlCodeMap.put(53, ConsoleControls.Control.SAVE_STATE_5);
        this.keyControlCodeMap.put(54, ConsoleControls.Control.SAVE_STATE_6);
        this.keyControlCodeMap.put(55, ConsoleControls.Control.SAVE_STATE_7);
        this.keyControlCodeMap.put(56, ConsoleControls.Control.SAVE_STATE_8);
        this.keyControlCodeMap.put(57, ConsoleControls.Control.SAVE_STATE_9);
        this.keyControlCodeMap.put(48, ConsoleControls.Control.SAVE_STATE_10);
        this.keyControlCodeMap.put(45, ConsoleControls.Control.SAVE_STATE_11);
        this.keyControlCodeMap.put(61, ConsoleControls.Control.SAVE_STATE_12);
        this.keyAltCodeMap.put(222, ConsoleControls.Control.LOAD_STATE_0);
        this.keyAltCodeMap.put(49, ConsoleControls.Control.LOAD_STATE_1);
        this.keyAltCodeMap.put(50, ConsoleControls.Control.LOAD_STATE_2);
        this.keyAltCodeMap.put(51, ConsoleControls.Control.LOAD_STATE_3);
        this.keyAltCodeMap.put(52, ConsoleControls.Control.LOAD_STATE_4);
        this.keyAltCodeMap.put(53, ConsoleControls.Control.LOAD_STATE_5);
        this.keyAltCodeMap.put(54, ConsoleControls.Control.LOAD_STATE_6);
        this.keyAltCodeMap.put(55, ConsoleControls.Control.LOAD_STATE_7);
        this.keyAltCodeMap.put(56, ConsoleControls.Control.LOAD_STATE_8);
        this.keyAltCodeMap.put(57, ConsoleControls.Control.LOAD_STATE_9);
        this.keyAltCodeMap.put(48, ConsoleControls.Control.LOAD_STATE_10);
        this.keyAltCodeMap.put(45, ConsoleControls.Control.LOAD_STATE_11);
        this.keyAltCodeMap.put(61, ConsoleControls.Control.LOAD_STATE_12);
    }

    private class PaddlesPositionUpdater
    extends Thread {
        private PaddlesPositionUpdater() {
        }

        @Override
        public void run() {
            while (AWTConsoleControls.this.paddleMode) {
                AWTConsoleControls.this.paddlesUpdatePosition();
                try {
                    PaddlesPositionUpdater.sleep(16L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

