/*
 * Decompiled with CFR 0.152.
 */
package pc.screen;

import atari.controls.ConsoleControls;
import atari.controls.ConsoleControlsInput;
import atari.controls.ConsoleControlsRedefinitionListener;
import atari.controls.ConsoleControlsSocket;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import pc.screen.Screen;
import utils.GraphicsDeviceHelper;
import utils.SlickFrame;

public class ConsolePanel
extends SlickFrame
implements ConsoleControls,
ConsoleControlsInput,
ConsoleControlsRedefinitionListener {
    private final JFrame masterWindow;
    private boolean retracted = false;
    private boolean docked = true;
    private Point dockedLocation;
    private Thread sizeAdjustThread;
    private BufferedImage panelImage;
    private BufferedImage retractButtonImage;
    private BufferedImage expandButtonImage;
    private BufferedImage closeButtonImage;
    private BufferedImage powerDownImage;
    private BufferedImage colorDownImage;
    private BufferedImage selectDownImage;
    private BufferedImage resetDownImage;
    private BufferedImage p0DiffDownImage;
    private BufferedImage p1DiffDownImage;
    private BufferedImage paintBackBuffer;
    private final Screen screen;
    private final ConsoleControlsSocket consoleControlsSocket;
    private Map<ConsoleControls.Control, Boolean> controlsStateReport = new HashMap<ConsoleControls.Control, Boolean>();
    public static final int WIDTH = 465;
    public static final int EXPANDED_HEIGHT = 137;
    public static final int RETRACTED_HEIGHT = 10;
    private static final Set<ConsoleControls.Control> visibleControls = new HashSet<ConsoleControls.Control>(Arrays.asList(ConsoleControls.Control.POWER, ConsoleControls.Control.BLACK_WHITE, ConsoleControls.Control.SELECT, ConsoleControls.Control.RESET, ConsoleControls.Control.DIFFICULTY0, ConsoleControls.Control.DIFFICULTY1));
    public static final long serialVersionUID = 1L;

    public ConsolePanel(JFrame masterWindow, Screen screen, ConsoleControlsSocket controlsSocket) {
        super(false);
        this.masterWindow = masterWindow;
        this.screen = screen;
        this.consoleControlsSocket = controlsSocket;
        this.consoleControlsSocket.addForwardedInput(this);
        this.consoleControlsSocket.addRedefinitionListener(this);
        this.buildGUI();
        this.addHotspots();
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, boolean state) {
        if (visibleControls.contains((Object)control)) {
            this.updateVisibleControlsState();
        }
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, int position) {
        if (visibleControls.contains((Object)control)) {
            this.updateVisibleControlsState();
        }
    }

    @Override
    public void controlsStateReport(Map<ConsoleControls.Control, Boolean> report) {
    }

    @Override
    public void controlsStatesRedefined() {
        this.updateVisibleControlsState();
    }

    private void buildGUI() {
        this.loadImages();
        this.setTitle("Atari Controls");
        this.setResizable(false);
        this.setSize(this.desiredSize());
        Toolkit tk = Toolkit.getDefaultToolkit();
        int x = (tk.getScreenSize().width - this.getWidth()) / 2;
        int y = (tk.getScreenSize().height - this.getHeight()) / 3;
        this.setLocation(x, y);
        this.masterWindow.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                ConsolePanel.this.trackMasterWindow();
            }
        });
        this.masterWindow.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ConsolePanel.this.trackMasterWindow();
            }
        });
        this.masterWindow.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ConsolePanel.this.setVisible(true);
            }
        });
        this.masterWindow.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (ConsolePanel.this.masterWindow.getState() == 1 && ConsolePanel.this.isVisible()) {
                    ConsolePanel.this.setVisible(false);
                }
                if (ConsolePanel.this.masterWindow.getState() == 0 && !ConsolePanel.this.isVisible()) {
                    ConsolePanel.this.setVisible(true);
                }
            }
        });
        this.paintBackBuffer = GraphicsDeviceHelper.defaultScreenDeviceConfiguration().createCompatibleImage(465, 137);
    }

    private void loadImages() {
        try {
            this.panelImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/Panel.png");
            this.retractButtonImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/PanelRetractButton.png");
            this.expandButtonImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/PanelExpandButton.png");
            this.closeButtonImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/PanelCloseButton.png");
            this.powerDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/PowerDown.png");
            this.colorDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/ColorDown.png");
            this.selectDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/SelectDown.png");
            this.resetDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/ResetDown.png");
            this.p0DiffDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/P0DiffDown.png");
            this.p1DiffDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/P1DiffDown.png");
        }
        catch (IOException ex) {
            System.out.println("Console Panel: unable to load images\n" + ex);
        }
    }

    @Override
    public void setVisible(final boolean state) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ConsolePanel.this.isVisible()) {
                    ConsolePanel.this.setFocusable(false);
                    ConsolePanel.this.setFocusableWindowState(false);
                }
                ConsolePanel.this.updateVisibleControlsState();
                ConsolePanel.super.setVisible(state);
                if (state) {
                    ConsolePanel.this.setState(0);
                    ConsolePanel.this.setSize(ConsolePanel.this.desiredSize());
                    ConsolePanel.this.toFront();
                    ConsolePanel.this.toFront();
                    ConsolePanel.this.masterWindow.toFront();
                    ConsolePanel.this.masterWindow.requestFocus();
                }
            }
        });
    }

    public void toggle() {
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.toggleRetract();
    }

    private void addHotspots() {
        this.addHotspot(new Rectangle(218, -13, 30, 15), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.toggleRetract();
            }
        });
        this.addHotspot(new Rectangle(446, -133, 14, 13), new Runnable(){

            @Override
            public void run() {
                if (!ConsolePanel.this.docked) {
                    ConsolePanel.this.setVisible(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ConsolePanel.this.toggleRetract();
                        }
                    });
                }
            }
        });
        this.addHotspot(new Rectangle(31, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.POWER, true);
                ConsolePanel.this.updateVisibleControlsState();
            }
        });
        this.addHotspot(new Rectangle(95, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.BLACK_WHITE, true);
                ConsolePanel.this.updateVisibleControlsState();
            }
        });
        this.addHotspot(new Rectangle(351, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.SELECT, true);
                ConsolePanel.this.updateVisibleControlsState();
            }
        }, new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.SELECT, false);
                ConsolePanel.this.updateVisibleControlsState();
            }
        });
        this.addHotspot(new Rectangle(414, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.RESET, true);
                ConsolePanel.this.updateVisibleControlsState();
            }
        }, new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.RESET, false);
                ConsolePanel.this.updateVisibleControlsState();
            }
        });
        this.addHotspot(new Rectangle(161, -133, 34, 21), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.DIFFICULTY0, true);
                ConsolePanel.this.updateVisibleControlsState();
            }
        });
        this.addHotspot(new Rectangle(274, -133, 34, 21), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.DIFFICULTY1, true);
                ConsolePanel.this.updateVisibleControlsState();
            }
        });
        this.addHotspot(new Rectangle(160, -83, 74, 43), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.screen.controlStateChanged(Screen.Control.LOAD_CARTRIDGE_FILE, true);
                ConsolePanel.this.updateVisibleControlsState();
            }
        });
        this.addHotspot(new Rectangle(235, -83, 74, 43), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.screen.controlStateChanged(Screen.Control.LOAD_CARTRIDGE_URL, true);
                ConsolePanel.this.updateVisibleControlsState();
            }
        });
    }

    @Override
    protected void movingTo(int x, int y) {
        if (this.retracted) {
            return;
        }
        this.docked = false;
        if (this.locationDockable(new Point(x, y))) {
            this.goToDockedLocation();
        } else {
            this.setLocation(x, y);
        }
    }

    @Override
    protected void finishedMoving() {
        if (this.locationDockable(this.getLocation())) {
            this.dock();
        } else {
            this.undock();
        }
    }

    private void toggleRetract() {
        if (this.sizeAdjustThread != null && this.sizeAdjustThread.isAlive()) {
            return;
        }
        this.retracted = !this.retracted;
        this.adjustSize();
        if (this.retracted) {
            this.dock();
        }
    }

    private boolean locationDockable(Point p) {
        if (this.dockedLocation == null) {
            return false;
        }
        if (Math.abs(p.y - this.dockedLocation.y) > 16) {
            return false;
        }
        return Math.abs(p.x - this.dockedLocation.x) < Math.max(Math.abs(this.masterWindow.getWidth() - this.getWidth()) / 2, 40);
    }

    private void trackMasterWindow() {
        this.dockedLocation = new Point(this.masterWindow.getLocation().x + (this.masterWindow.getWidth() - this.getWidth()) / 2, this.masterWindow.getLocation().y + this.masterWindow.getHeight());
        if (this.docked) {
            this.goToDockedLocation();
        } else if (this.locationDockable(this.getLocation())) {
            this.dock();
        }
        this.adjustSize();
    }

    private void dock() {
        this.goToDockedLocation();
        this.docked = true;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    private void undock() {
        this.docked = false;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    private void goToDockedLocation() {
        this.setLocation(this.dockedLocation);
    }

    private void adjustSize() {
        final Dimension targetSize = this.desiredSize();
        if (this.getSize().equals(targetSize)) {
            return;
        }
        final int dir = targetSize.height > this.getHeight() ? -1 : 1;
        final int[] delta = new int[]{Math.abs(targetSize.height - this.getHeight())};
        this.sizeAdjustThread = new Thread(){

            @Override
            public void run() {
                while (delta[0] >= 0) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ConsolePanel.this.setSize(targetSize.width, targetSize.height + delta[0] * dir);
                            }
                        });
                        Thread.sleep(7L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    delta[0] = delta[0] - 10;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConsolePanel.this.setSize(targetSize);
                    }
                });
            }
        };
        this.sizeAdjustThread.start();
    }

    private Dimension desiredSize() {
        Insets ins = this.getInsets();
        int h = this.retracted ? (this.masterWindow.getWidth() < 465 ? 0 : 10) : 137;
        return new Dimension(465 + ins.left + ins.right, h + ins.top + ins.bottom);
    }

    private void updateVisibleControlsState() {
        this.consoleControlsSocket.controlsStateReport(this.controlsStateReport);
        if (this.isVisible() && !this.retracted) {
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics origGraphics) {
        Insets ins = this.getInsets();
        int initialHeight = 137 - (this.getHeight() - ins.top - ins.bottom);
        boolean retr = this.retracted;
        boolean dock = this.docked;
        Graphics2D g = this.paintBackBuffer.createGraphics();
        g.drawImage(this.panelImage, 0, initialHeight, 465, 137, 0, initialHeight, 465, 137, null);
        if (retr) {
            g.drawImage((Image)this.expandButtonImage, 225, 127, null);
        } else {
            g.drawImage((Image)this.retractButtonImage, 225, 127, null);
        }
        if (!dock) {
            g.drawImage((Image)this.closeButtonImage, 448, 5, null);
        }
        if (!this.controlsStateReport.get((Object)ConsoleControls.Control.POWER).booleanValue()) {
            g.drawImage((Image)this.powerDownImage, 33, 50, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.BLACK_WHITE).booleanValue()) {
            g.drawImage((Image)this.colorDownImage, 97, 50, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.SELECT).booleanValue()) {
            g.drawImage((Image)this.selectDownImage, 353, 50, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.RESET).booleanValue()) {
            g.drawImage((Image)this.resetDownImage, 416, 50, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.DIFFICULTY0).booleanValue()) {
            g.drawImage((Image)this.p0DiffDownImage, 164, 6, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.DIFFICULTY1).booleanValue()) {
            g.drawImage((Image)this.p1DiffDownImage, 277, 6, null);
        }
        g.dispose();
        origGraphics.drawImage(this.paintBackBuffer, ins.left, ins.top, this.getWidth() - ins.right, this.getHeight() - ins.bottom, 0, initialHeight, this.getWidth() - ins.left - ins.right, initialHeight + this.getHeight() - ins.top - ins.bottom, null);
    }
}

