/*
 * Decompiled with CFR 0.152.
 */
package pc.screen;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import pc.screen.Screen;

public class ScreenControlsAdapter
implements KeyListener {
    private Screen screen;
    private final Map<Integer, Screen.Control> keyCodeMap = new HashMap<Integer, Screen.Control>();
    private final Map<Integer, Screen.Control> keyShiftCodeMap = new HashMap<Integer, Screen.Control>();
    private final Map<Integer, Screen.Control> keyAltCodeMap = new HashMap<Integer, Screen.Control>();
    private final Map<Integer, Screen.Control> keyShiftControlCodeMap = new HashMap<Integer, Screen.Control>();
    private final Map<Integer, Screen.Control> keyShiftAltCodeMap = new HashMap<Integer, Screen.Control>();
    private final Map<Integer, Screen.Control> keyControlAltCodeMap = new HashMap<Integer, Screen.Control>();
    public static final int KEY_UP = 38;
    public static final int KEY_DOWN = 40;
    public static final int KEY_LEFT = 37;
    public static final int KEY_RIGHT = 39;
    public static final int KEY_SIZE_DEFAULT = 8;
    public static final int KEY_EXIT = 27;
    public static final int KEY_CART_FILE = 116;
    public static final int KEY_CART_URL = 117;
    public static final int KEY_CART_EMPTY = 118;
    public static final int KEY_FULL_SCR = 10;
    public static final int KEY_QUALITY = 81;
    public static final int KEY_CRT_MODES = 82;
    public static final int KEY_VIDEO_STAND = 86;
    public static final int KEY_DEBUG = 68;
    public static final int KEY_HELP = 72;

    public ScreenControlsAdapter(Screen screen, Component ... components) {
        this.screen = screen;
        this.init(components);
    }

    private void init(Component ... components) {
        int i = 0;
        while (i < components.length) {
            components[i].addKeyListener(this);
            ++i;
        }
        this.keyCodeMap.put(27, Screen.Control.EXIT);
        this.keyCodeMap.put(116, Screen.Control.LOAD_CARTRIDGE_FILE);
        this.keyCodeMap.put(117, Screen.Control.LOAD_CARTRIDGE_URL);
        this.keyCodeMap.put(118, Screen.Control.LOAD_CARTRIDGE_EMPTY);
        this.keyAltCodeMap.put(72, Screen.Control.HELP);
        this.keyAltCodeMap.put(10, Screen.Control.FULL_SCREEN);
        this.keyAltCodeMap.put(81, Screen.Control.QUALITY);
        this.keyAltCodeMap.put(68, Screen.Control.DEBUG);
        this.keyAltCodeMap.put(82, Screen.Control.CRT_MODES);
        this.keyAltCodeMap.put(116, Screen.Control.LOAD_CARTRIDGE_FILE_NO_AUTO_POWER);
        this.keyAltCodeMap.put(117, Screen.Control.LOAD_CARTRIDGE_URL_NO_AUTO_POWER);
        this.keyShiftCodeMap.put(38, Screen.Control.SIZE_MINUS);
        this.keyShiftCodeMap.put(40, Screen.Control.SIZE_PLUS);
        this.keyShiftCodeMap.put(37, Screen.Control.SIZE_MINUS);
        this.keyShiftCodeMap.put(39, Screen.Control.SIZE_PLUS);
        this.keyShiftAltCodeMap.put(38, Screen.Control.SCALE_Y_MINUS);
        this.keyShiftAltCodeMap.put(40, Screen.Control.SCALE_Y_PLUS);
        this.keyShiftAltCodeMap.put(37, Screen.Control.SCALE_X_MINUS);
        this.keyShiftAltCodeMap.put(39, Screen.Control.SCALE_X_PLUS);
        this.keyControlAltCodeMap.put(38, Screen.Control.ORIGIN_Y_MINUS);
        this.keyControlAltCodeMap.put(40, Screen.Control.ORIGIN_Y_PLUS);
        this.keyControlAltCodeMap.put(37, Screen.Control.ORIGIN_X_MINUS);
        this.keyControlAltCodeMap.put(39, Screen.Control.ORIGIN_X_PLUS);
        this.keyShiftControlCodeMap.put(38, Screen.Control.HEIGHT_MINUS);
        this.keyShiftControlCodeMap.put(40, Screen.Control.HEIGHT_PLUS);
        this.keyShiftControlCodeMap.put(37, Screen.Control.WIDTH_MINUS);
        this.keyShiftControlCodeMap.put(39, Screen.Control.WIDTH_PLUS);
        this.keyCodeMap.put(8, Screen.Control.SIZE_DEFAULT);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Screen.Control control = this.controlForEvent(e);
        if (control == null) {
            return;
        }
        this.screen.controlStateChanged(control, true);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Screen.Control control = this.controlForEvent(e);
        if (control == null) {
            return;
        }
        this.screen.controlStateChanged(control, false);
    }

    private Screen.Control controlForEvent(KeyEvent e) {
        switch (e.getModifiersEx()) {
            case 0: {
                return this.keyCodeMap.get(e.getKeyCode());
            }
            case 512: {
                return this.keyAltCodeMap.get(e.getKeyCode());
            }
            case 64: {
                return this.keyShiftCodeMap.get(e.getKeyCode());
            }
            case 640: {
                return this.keyControlAltCodeMap.get(e.getKeyCode());
            }
            case 192: {
                return this.keyShiftControlCodeMap.get(e.getKeyCode());
            }
            case 576: {
                return this.keyShiftAltCodeMap.get(e.getKeyCode());
            }
        }
        return null;
    }
}

