;=================================================;
;=          AspeQt Client utility v1.0            ;
;=        Copyright 2010 Ray. N. Ataergin		  ;
;=================================================;
; This program and its source is released under:  ;
;           GNU GENERAL PUBLIC LICENSE            ;
; Please read the details in the file LICENCE.TXT ;
; included with AspeQT distribution archive       ;
;=================================================;
; This version of the AspeQT Client will only     ;
; work with Spartados versions > 2.5 and with all ;
; versions of SpartaDos X.                        ;
;=================================================;

; Zero Page Usage
hlpadr      =   $CB

; Various OS Vectors
dosvec		=	$0A			
ciov		= 	$E456
siov		=	$E459

; Device Control Block
ddevic		=	$0300
dunit		=	$0301
dcomnd		=	$0302
dstats		=	$0303
dbuflo		=	$0304
dbufhi		=	$0305
dbytlo		=	$0308
dbythi		=   $0309
daux1		=	$030A
daux2		=	$030B

; I/O Control Block for Msg Display
iocb0		=	$0340
iccom0		=	$0342
icbal0		=	$0344
icbah0		=	$0345
icbll0		=	$0348
icblh0		=	$0349

; Hardware Registers
portb		=	$D301

; SpartaDos Kernel Area (Page 7)
sparta		=	$700
spver		=	$701
skernel		=	$703
sdevic		=	$761
sdate		=	$77B

; SpartaDos User Area
comfnam		= 	33

; SpartaDos Vectors
vsettd		=	$FFC3
vtdon		=	$FFC6

*			= 	$6000

;==============================
; Housekeeping
;==============================
aStart

;==============================
; Check for SpartaDos
;==============================
			lda sparta			
			cmp #83				
			beq aVers			

;==============================
; Not SpartaDos
;==============================
			pla
			pla
			jmp	aExit		
				
;==============================
; Retrieve SpartaDos Version
;==============================
aVers
			lda spver			
			ldx #0			
aLoo1
			cmp aSpvI,x				
			beq aFound
			inx
			cpx #6
			bne	aLoo1
			jmp	adispV
			 
aFound
			lda aSpvo,x
			sta aVerno
						
adispV

;================================
; Get the command line switches
;================================			
			ldy	#5
			ldx	#2
aLoo2			
			lda (dosvec),y
			sta zcrname,x
			dey
			dex
			bne aLoo2
aLoo5		jsr zcrname
			bne aAna
			lda #1
			cmp aIfSw			
			bne aNoSw					;No command line switches were specified, exit with help display
			rts							;All requests were fullfilled exit program

;====================================
; Analyze the command line switches
;====================================
aAna
			lda #1
			sta aIfSw					;Set switches found flag
			ldy #comfnam+3				;Get switches from the command line
			lda (dosvec),y
			sta aSlSw					;Store switch for later use
			cmp aTime					;Date/Time?
			beq aDT1
			cmp aDisk					;Disk?
			beq aDSK1
			
;==============================
; No command line switches
;==============================
aNoSw
			rts							;Exit Program															

;====================================
; See if Date/Time options present
;====================================
aDt1
			iny
			ldx #0
			stx aSlSo
aLoo6
			lda (dosvec),y
			cmp aTopt,x
			bne aLoo7 
			lda aTopt,x			
			sta aSlSo					;Store selected switch option for later use
			jmp	aDt2
			
aLoo7
			inx
			lda #155
			cmp aTopt,x
			bne aLoo6
			jmp aNoSw					;Date/Time Options not specified, exit with help display

;====================================
; See if Disk options present
;====================================
aDsk1
			iny
			ldx #0
			stx aSlSo
aLoo8
			lda (dosvec),y
			cmp aDopt,x
			bne aLoo9 
			lda aDopt,x			
			sta aSlSo
			jmp	aDsk2
			
aLoo9
			inx
			lda #155
			cmp aTopt,x
			bne aLoo8
			jmp aNoSw 					;Disk Options not specified, exit with help display
			

;==================================			
; Date/Time Requested
;==================================
aDt2
	
;==================================
; Get the Date/Time from the server
;==================================
			jsr aSioInit
			ldx #0
			lda aComnd,x			; Date/Time
			sta dcomnd
			lda #64					; Data from Peripheral (Server) to Computer (Client)
			sta dstats
			lda #0
			sta daux1
			lda #1					; Send Date/Time
			sta daux2
			jsr siov
					
			lda dstats
			cmp #1
			beq aSucc1
			
;=================================										
; Failed to receive Date/Time
;=================================		
aErr1
			rts							; Exit program

;===================================						
; Successfuly received the Date/Time
;===================================
aSucc1				
			
;===================================
; Determine which vectors to use
;===================================
			lda aVerno
			cmp #4
			beq aKernel
						
;=========================================
; Set Date/Time in COMTAB+13 (SpartaDos)
;=========================================
aComtab
			ldx	#0
			ldy	#13
aLoo3
			lda aBuf,x
			sta (dosvec),y
			inx
			iny
			cpx #6
			bne aLoo3
aPortb
			lda	portb
			pha
			and #254
			sta	portb
			clc
			jsr vsettd
			pla
			sta portb												
			bcc aOK
			
;==============================
; Failed to Set the Date/Time			
;==============================
aNOk
			rts							; Exit Program
			
;===============================
; Successfuly set the Date/Time
;===============================
aOk
			
;===================================
; See if we turn the TD Line ON/OFF
;===================================
			ldy #0
			lda aSlSo
			cmp #'S						; Set Date/Time
			bne	aNotS
			jmp aLoo5					; Get next switch
aNotS
			cmp #'O						; Set Date/Time & TD Line ON
			bne aNotO
			ldy #1
aNotO
			lda	portb
			pha
			and #254
			sta	portb
			clc
			jsr vtdon
			pla
			sta portb
			bcs aErr2
			jmp aLoo5					; Get next switch
			
;================================
; Failed to turn TD line ON/OFF
;================================
aErr2
			rts							; Exit Program
						
;=======================================
; Set Date/Time in Kernel (SpartaDos X)
;=======================================
aKernel								
			ldx	#0
aLoo4
			lda aBuf,x
			sta sdate,x
			inx
			cpx #6
			bne aLoo4
			ldy	#$65
			lda #$10
			sta sdevic
			jmp skernel
			
			cmp #0
			beq aOK
			jmp aNOK
			
;==================================			
; Disk Image Operation Requested
;==================================
aDsk2
			lda aSlSo
			cmp #'S						; Disk Swap
			bne aDsk3
			iny
			lda (dosvec),y
			sta aSwD1
			iny
			lda (dosvec),y
			sta aSwD2
			
;==================================
; Send disk swap information
;==================================
			jsr aSioInit
			ldx #1
			lda aComnd,x
			sta dcomnd
			lda #0						; No data required from server
			sta dstats
			lda aSwD1
			sec
			sbc #48
			sta daux1
			lda aSwD2					; Send Date/Time
			sec
			sbc #48
			sta daux2
			jsr siov
					
			lda dstats
			cmp #1
			beq aSucc2
aErr3
			rts
aSucc2
			jmp aLoo5					; Get next switch
			
aDsk3		cmp #'U						; Disk UnMount
			bne aDsk4
			iny
			lda (dosvec),y
			sta aUnMD1
			
;==================================
; Send disk unmount information
;==================================
			jsr aSioInit
			ldx #2
			lda aComnd,x
			sta dcomnd
			lda #0						; No data required from server
			sta dstats
			lda #0
			sta daux1
			lda #'*
			cmp aUnMD1
			bne aSingleD
			lda #'9
			jmp acont1
aSingleD
			lda aUnMD1
aCont1
			sec
			sbc #48
			sta daux2					
			jsr siov
							
			lda dstats
			cmp #1
			beq aSucc3
aErr4
			rts
aSucc3
			jmp aLoo5					; Get next switch

			
aDsk4		cmp #'M						; Disk Mount
			beq aDsk5
			jmp aNoSw
			
aDsk5
			rts
						
					
;==============================;
;    S U B R O U T I N E S     ;
;==============================;
						
		
;===============================			
; Print a line on the screen
;===============================
aPrint
			txa
			ldx #$00		
			sta	icbal0,x
			tya			
			sta icbah0,x
			lda aCmd
			sta iccom0,x					
			lda aBlen				
			sta icbll0,x
			jsr ciov
			rts
			
;===============================
; Set-up DCB (SIO)
;===============================
aSioInit
			lda aDevic					
			sta ddevic
			lda aUnit
			sta dunit
			lda #<aBuf
			sta dbuflo
			lda #>aBuf
			sta dbufhi
			lda abytlo
			sta dbytlo
			lda #0
			sta dbythi
			rts
					
;================================
; Exit for non-sparta DOS
;================================	
aExit		
			jmp (dosvec)					
			rts
zcrname
			jmp $FFFF

;===============================================================;
; DATA AREAS                                                    ;
;===============================================================;
aSwD1	.DS 1
aSwD2   .DS 1
aUnMD1  .DS 1
aVerNo	.byte "?"
aSpvI	.byte "%23@CD"
aSpvO   .byte "233444"
aIfSw   .byte $0									;Switches present >> 0:NO, 1:YES
aSlSw	.byte $0									;Selected switch
aSlSo	.byte $0									;Selected Switch Option
aTime	.byte "T"									;Command Line switches (T: Time/Date)
aTopt	.byte "SOF", 155							;Switch options
aDisk	.byte "D"									;Command Line switches (D: Disk)
aDopt	.byte "MSU", 155							;Switch options
aDevic	.byte $46									;Device: 46: AspeQt Server
aUnit	.byte $01									;Unit: 01
aComnd	.byte $93, $94, $95								;Command
														;   $93 (147): Date/Time
														;   $94 (148): Disk Swap
														;   $95 (149): Disk Unmount
aBytlo	.byte $06									;Data buffer length low nibble (high nibble is 0)
aCmd	.byte $09									;Default Command for E: (Put Record)
aBlen	.byte $FF									;Default Buffer Length for E:
aBuf	.byte $FF, $FF, $FF, $FF, $FF, $FF 			;Storage for server data
aCr		.byte 155
		
*			=	$02E0								;Run Address
		.word	aStart

