#include "miscdevices.h"
#include "aspeqtsettings.h"
#include "mainwindow.h"

#include <QDateTime>
#include <QtDebug>

// Ray A.
bool conversionMsgdisplayedOnce;

void Printer::handleCommand(quint8 command, quint16 aux)
{
    switch(command) {
    case 0x53:
        {
            // Get status
            if (!sio->port()->writeCommandAck()) {
                return;
            }

            QByteArray status(4, 0);
            status[0] = 0;
            status[1] = m_lastOperation;
            status[2] = 3;
            status[3] = 0;
            sio->port()->writeComplete();
            sio->port()->writeDataFrame(status);
            qDebug() << "!n" << tr("[%1] Get status.").arg(deviceName());
            break;
        }
    case 0x57:
        {
            // Write
            int aux2 = aux % 256;
            int len;
            switch (aux2) {
            case 0x4e:
                // Normal
                len = 40;
                break;
            case 0x53:
                // Sideways
                len = 29;
                break;
            case 0x44:
                // Double width
                len = 21;
                break;
            default:
                sio->port()->writeCommandNak();
                qWarning() << "!w" << tr("[%1] command: $%2, aux: $%3 NAKed.")
                               .arg(deviceName())
                               .arg(command, 2, 16, QChar('0'))
                               .arg(aux, 4, 16, QChar('0'));
                return;
            }
            // Display Info message once  // Ray A.
            if (!conversionMsgdisplayedOnce) {
                qDebug() << "!n" << tr("[%1] Converting Inverse Video Characters for ASCII viewing").arg(deviceName()).arg(len);
                conversionMsgdisplayedOnce = true;
            }
            sio->port()->writeCommandAck();

            QByteArray data = sio->port()->readDataFrame(len);
            if (data.isEmpty()) {
                qCritical() << "!e" << tr("[%1] Print: data frame failed")
                              .arg(deviceName());
                sio->port()->writeDataNak();
                return;
            }           
            sio->port()->writeDataAck();
            qDebug() << "!n" << tr("[%1] Print (%2 chars)").arg(deviceName()).arg(len);
            int n = data.indexOf('\x9b');
            if (n == -1) {
                n = len;
            }
            data.resize(n);
            data.replace('\n', '\x9b');
            if (n < len) {
                data.append("\n");
            }
            emit print(QString::fromLatin1(data));
            sio->port()->writeComplete();
            break;
        }
    default:
        sio->port()->writeCommandNak();
        qWarning() << "!w" << tr("[%1] command: $%2, aux: $%3 NAKed.")
                       .arg(deviceName())
                       .arg(command, 2, 16, QChar('0'))
                       .arg(aux, 4, 16, QChar('0'));
    }
}

void ApeTime::handleCommand(quint8 command, quint16 aux)
{
    QByteArray data(5, 0);
    QDateTime dateTime = QDateTime::currentDateTime();

    if (command == 0x93) {
        if (!sio->port()->writeCommandAck()) {
            return;
        }

        data[0] = dateTime.date().day();
        data[1] = dateTime.date().month();
        data[2] = dateTime.date().year() % 100;
        data[3] = dateTime.time().hour();
        data[4] = dateTime.time().minute();
        data[5] = dateTime.time().second();

        sio->port()->writeComplete();
        sio->port()->writeDataFrame(data);

        qDebug() << "!n" << tr("[%1] Read date/time (%2).")
                       .arg(deviceName())
                       .arg(dateTime.toString(Qt::SystemLocaleShortDate));
    } else {
        sio->port()->writeCommandNak();
        qWarning() << "!w" << tr("[%1] command: $%2, aux: $%3 NAKed.")
                       .arg(deviceName())
                       .arg(command, 2, 16, QChar('0'))
                       .arg(aux, 4, 16, QChar('0'));
    }
}
// AspeQt Client // Ray A.
void AspeCl::handleCommand(quint8 command, quint16 aux)
{
    QByteArray data(5, 0);
    QDateTime dateTime = QDateTime::currentDateTime();

    switch (command) {
      case 0x93 :   // Send Date/Time
         {
            if (!sio->port()->writeCommandAck()) {
                return;
            }
            qint8 clRequest = aux % 256;
            if (clRequest == 0) {
                data[0] = dateTime.date().day();
                data[1] = dateTime.date().month();
                data[2] = dateTime.date().year() % 100;
                data[3] = dateTime.time().hour();
                data[4] = dateTime.time().minute();
                data[5] = dateTime.time().second();
                qDebug() << "!n" << tr("[%1] Date/time sent to client (%2).")
                           .arg(deviceName())
                           .arg(dateTime.toString(Qt::SystemLocaleShortDate));
            } else {
                sio->port()->writeCommandNak();
                qDebug() << "!e" << tr("[%1] Unrecognized Client Date Request (%2).")
                           .arg(deviceName())
                           .arg(clRequest);
            }
            sio->port()->writeComplete();
            sio->port()->writeDataFrame(data);
         }
         break;

      case 0x94 :   // Swap Disks
         {
            if (!sio->port()->writeCommandAck()) {
                return;
            }
            qint8 swapDisk1, swapDisk2;
            swapDisk1 = aux /256 - 1;
            swapDisk2 = aux % 256 - 1;
            if (swapDisk1 >= 0 and swapDisk1 <= 7 and swapDisk2 >=0 and swapDisk2 <=7 and swapDisk1 != swapDisk2) {
                sio->swapDevices(swapDisk1 + 0x31, swapDisk2 + 0x31);
                aspeqtSettings->swapImages(swapDisk1, swapDisk2);
                qDebug() << "!n" << tr("Swapped disk %1 with disk %2.").arg(swapDisk2 + 1).arg(swapDisk1 + 1);
            } else {
                sio->port()->writeCommandNak();
                qDebug() << "!e" << tr("[%1] Invalid swap request for drives: (%2)-(%3).")
                           .arg(deviceName())
                           .arg(swapDisk2 + 1)
                           .arg(swapDisk1 + 1);
            }
            sio->port()->writeComplete();
            sio->port()->writeDataFrame(data);
         }
         break;

    case 0x95 :   // Unmount Disk(s)
       {
          if (!sio->port()->writeCommandAck()) {
              return;
          }
          qint8 unmountDisk;
          unmountDisk = aux /256;
          if (unmountDisk >= 1 and unmountDisk <= 9) {
              if (unmountDisk == 9) {
              // Eject All disks
                  int toBeSaved = 0;
                  for (int i = 0; i < 8; i++) {
                      SimpleDiskImage *img = qobject_cast <SimpleDiskImage*> (sio->getDevice(i + 0x31));
                      if (img && img->isModified()) {
                          toBeSaved++;
                      }
                  }
                  if (!toBeSaved) {
                      for (int i = 7; i >= 0; i--) {
                          SimpleDiskImage *img = qobject_cast <SimpleDiskImage*> (sio->getDevice(i + 0x31));
                          sio->uninstallDevice(i + 0x31);
                          delete img;
                          aspeqtSettings->unmountImage(i);
                          qDebug() << "!n" << tr("Unmounted disk %1").arg(i + 1);
                      }
                      qDebug() << "!n" << tr("[%1] ALL images were remotely unmounted")
                                .arg(deviceName());
                  } else {
                      sio->port()->writeCommandNak();
                      qDebug() << "!e" << tr("[%1] Can not remotely unmount ALL images due to pending changes.")
                                .arg(deviceName());
                  }
              } else {
                  // Single Disk Eject
                  SimpleDiskImage *img = qobject_cast <SimpleDiskImage*> (sio->getDevice(unmountDisk - 1 + 0x31));

                  if (img->isModified()) {
                      sio->port()->writeCommandNak();
                      qDebug() << "!e" << tr("[%1] Can not remotely unmount disk %2 due to pending changes.")
                                .arg(deviceName())
                                .arg(unmountDisk);
                  } else {
                      sio->uninstallDevice(unmountDisk - 1 + 0x31);
                      delete img;
                      aspeqtSettings->unmountImage(unmountDisk - 1);
                      qDebug() << "!n" << tr("[%1] Remotely unmounted disk %2")
                                  .arg(deviceName())
                                  .arg(unmountDisk);
                  }
                }

              } else {
                  sio->port()->writeCommandNak();
                  qDebug() << "!e" << tr("[%1] Invalid drive number: %2 for remote unmount")
                         .arg(deviceName())
                         .arg(unmountDisk);
            }
            sio->port()->writeComplete();
            sio->port()->writeDataFrame(data);
       }
       break;

      default :
      // Invalid Command
         sio->port()->writeCommandNak();
         qWarning() << "!e" << tr("[%1] command: $%2, aux: $%3 NAKed.")
                       .arg(deviceName())
                       .arg(command, 2, 16, QChar('0'))
                       .arg(aux, 4, 16, QChar('0'));
    }
}
