/*
 * Decompiled with CFR 0.152.
 */
package atari.pia;

import atari.console.Console;
import atari.controls.ConsoleControls;
import atari.controls.ConsoleControlsInput;
import general.board.BUS16Bits;
import general.board.ClockDriven;
import java.io.Serializable;
import java.util.Map;
import utils.Randomizer;

public final class PIA
implements BUS16Bits,
ClockDriven,
ConsoleControlsInput {
    private Console console;
    public boolean debug = false;
    private int timerCount = 1024;
    private int currentTimerInterval = 1024;
    private int lastSetTimerInterval = 1024;
    private int SWCHA = 255;
    private int SWACNT;
    private int SWCHB = 11;
    private int SWBCNT;
    private int INTIM = Randomizer.instance.nextInt() & 0xFF;
    private int INSTAT;
    private int TIM1T;
    private int TIM8T;
    private int TIM64T;
    private int T1024T;
    private static final int READ_ADDRESS_MASK = 7;
    private static final int WRITE_ADDRESS_MASK = 7;

    public PIA(Console console) {
        this.console = console;
    }

    public void powerOn() {
    }

    public void powerOff() {
    }

    @Override
    public void clockPulse() {
        if (--this.timerCount <= 0) {
            this.decrementTimer();
        }
    }

    private void setTimerInterval(int value, int interval) {
        this.INTIM = value & 0xFF;
        this.INSTAT &= 0x3F;
        this.currentTimerInterval = this.lastSetTimerInterval = interval;
        this.timerCount = this.lastSetTimerInterval;
        this.decrementTimer();
    }

    private void decrementTimer() {
        if (--this.INTIM < 0) {
            this.INSTAT |= 0xC0;
            this.INTIM = 255;
            this.currentTimerInterval = 1;
            this.timerCount = 1;
        } else {
            this.timerCount = this.currentTimerInterval;
        }
    }

    private void readFromINTIM() {
        this.INSTAT &= 0xBF;
        if (this.currentTimerInterval == 1) {
            this.timerCount = this.currentTimerInterval = this.lastSetTimerInterval;
        }
    }

    private void swchbWrite(int val) {
        this.SWCHB = this.SWCHB & 0xCB | val & 0x22;
    }

    private void debugInfo(String str) {
        if (this.debug) {
            System.out.println(str);
        }
    }

    @Override
    public byte readByte(int address) {
        switch (address & 7) {
            case 0: {
                return (byte)this.SWCHA;
            }
            case 1: {
                return (byte)this.SWACNT;
            }
            case 2: {
                return (byte)this.SWCHB;
            }
            case 3: {
                return (byte)this.SWBCNT;
            }
            case 4: 
            case 6: {
                this.readFromINTIM();
                return (byte)this.INTIM;
            }
            case 5: 
            case 7: {
                return (byte)this.INSTAT;
            }
        }
        this.debugInfo(String.format("Invalid PIA read register address: %04x", address));
        return 0;
    }

    @Override
    public void writeByte(int address, byte b) {
        int i = b & 0xFF;
        switch (address & 7) {
            case 0: {
                this.debugInfo(String.format(">>>> Unsupported Write to PIA SWCHA: %02x", i));
                return;
            }
            case 1: {
                this.debugInfo(String.format(">>>> Unsupported Write to PIA SWACNT: %02x", i));
                return;
            }
            case 2: {
                this.swchbWrite(i);
                return;
            }
            case 3: {
                this.SWBCNT = i;
                this.debugInfo(String.format(">>>> Ineffective Write to PIA SWBCNT: %02x", i));
                return;
            }
            case 4: {
                this.TIM1T = i;
                this.setTimerInterval(i, 1);
                return;
            }
            case 5: {
                this.TIM8T = i;
                this.setTimerInterval(i, 8);
                return;
            }
            case 6: {
                this.TIM64T = i;
                this.setTimerInterval(i, 64);
                return;
            }
            case 7: {
                this.T1024T = i;
                this.setTimerInterval(i, 1024);
                return;
            }
        }
        this.debugInfo(String.format("Invalid PIA write register address: %04x value %d", address, b));
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, boolean state) {
        switch (control) {
            case JOY0_UP: {
                this.SWCHA = state ? (this.SWCHA &= 0xEF) : (this.SWCHA |= 0x10);
                return;
            }
            case JOY0_DOWN: {
                this.SWCHA = state ? (this.SWCHA &= 0xDF) : (this.SWCHA |= 0x20);
                return;
            }
            case JOY0_LEFT: 
            case PADDLE1_BUTTON: {
                this.SWCHA = state ? (this.SWCHA &= 0xBF) : (this.SWCHA |= 0x40);
                return;
            }
            case JOY0_RIGHT: 
            case PADDLE0_BUTTON: {
                this.SWCHA = state ? (this.SWCHA &= 0x7F) : (this.SWCHA |= 0x80);
                return;
            }
            case JOY1_UP: {
                this.SWCHA = state ? (this.SWCHA &= 0xFE) : (this.SWCHA |= 1);
                return;
            }
            case JOY1_DOWN: {
                this.SWCHA = state ? (this.SWCHA &= 0xFD) : (this.SWCHA |= 2);
                return;
            }
            case JOY1_LEFT: {
                this.SWCHA = state ? (this.SWCHA &= 0xFB) : (this.SWCHA |= 4);
                return;
            }
            case JOY1_RIGHT: {
                this.SWCHA = state ? (this.SWCHA &= 0xF7) : (this.SWCHA |= 8);
                return;
            }
            case RESET: {
                this.SWCHB = state ? (this.SWCHB &= 0xFE) : (this.SWCHB |= 1);
                return;
            }
            case SELECT: {
                this.SWCHB = state ? (this.SWCHB &= 0xFD) : (this.SWCHB |= 2);
                return;
            }
        }
        if (!state) {
            return;
        }
        switch (control) {
            case BLACK_WHITE: {
                this.SWCHB = (this.SWCHB & 8) == 0 ? (this.SWCHB |= 8) : (this.SWCHB &= 0xF7);
                this.console.showOSD((this.SWCHB & 8) != 0 ? "COLOR" : "B/W");
                return;
            }
            case DIFFICULTY0: {
                this.SWCHB = (this.SWCHB & 0x40) == 0 ? (this.SWCHB |= 0x40) : (this.SWCHB &= 0xBF);
                this.console.showOSD((this.SWCHB & 0x40) != 0 ? "P1 Expert" : "P1 Novice");
                return;
            }
            case DIFFICULTY1: {
                this.SWCHB = (this.SWCHB & 0x80) == 0 ? (this.SWCHB |= 0x80) : (this.SWCHB &= 0x7F);
                this.console.showOSD((this.SWCHB & 0x80) != 0 ? "P2 Expert" : "P2 Novice");
                return;
            }
        }
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, int position) {
    }

    @Override
    public void controlsStateReport(Map<ConsoleControls.Control, Boolean> report) {
        report.put(ConsoleControls.Control.BLACK_WHITE, (this.SWCHB & 8) == 0);
        report.put(ConsoleControls.Control.DIFFICULTY0, (this.SWCHB & 0x40) != 0);
        report.put(ConsoleControls.Control.DIFFICULTY1, (this.SWCHB & 0x80) != 0);
        report.put(ConsoleControls.Control.SELECT, (this.SWCHB & 2) == 0);
        report.put(ConsoleControls.Control.RESET, (this.SWCHB & 1) == 0);
    }

    public PIAState saveState() {
        PIAState state = new PIAState();
        state.debug = this.debug;
        state.timerCount = this.timerCount;
        state.currentTimerInterval = this.currentTimerInterval;
        state.lastSetTimerInterval = this.lastSetTimerInterval;
        state.SWCHA = this.SWCHA;
        state.SWACNT = this.SWACNT;
        state.SWCHB = this.SWCHB;
        state.SWBCNT = this.SWBCNT;
        state.INTIM = this.INTIM;
        state.INSTAT = this.INSTAT;
        state.TIM1T = this.TIM1T;
        state.TIM8T = this.TIM8T;
        state.TIM64T = this.TIM64T;
        state.T1024T = this.T1024T;
        return state;
    }

    public void loadState(PIAState state) {
        this.timerCount = state.timerCount;
        this.currentTimerInterval = state.currentTimerInterval;
        this.lastSetTimerInterval = state.lastSetTimerInterval;
        this.SWACNT = state.SWACNT;
        this.SWCHB = state.SWCHB;
        this.SWBCNT = state.SWBCNT;
        this.INTIM = state.INTIM;
        this.INSTAT = state.INSTAT;
        this.TIM1T = state.TIM1T;
        this.TIM8T = state.TIM8T;
        this.TIM64T = state.TIM64T;
        this.T1024T = state.T1024T;
    }

    public static class PIAState
    implements Serializable {
        boolean debug;
        int timerCount;
        int currentTimerInterval;
        int lastSetTimerInterval;
        int SWCHA;
        int SWACNT;
        int SWCHB;
        int SWBCNT;
        int INTIM;
        int INSTAT;
        int TIM1T;
        int TIM8T;
        int TIM64T;
        int T1024T;
        public static final long serialVersionUID = 2L;
    }
}

