/*
 * Decompiled with CFR 0.152.
 */
package atari.tia.audio;

import atari.tia.audio.ChannelStream;
import general.av.audio.AudioMonitor;
import general.av.audio.AudioSignal;
import general.av.video.VideoStandard;
import javax.sound.sampled.AudioFormat;
import parameters.Parameters;

public abstract class AudioGenerator
implements AudioSignal {
    protected final ChannelStream channel0 = new ChannelStream();
    protected final ChannelStream channel1 = new ChannelStream();
    public AudioMonitor monitor;
    public VideoStandard videoStandard;
    protected int generatedSamples = 0;
    protected final byte[] samples = new byte[1024];
    protected static final float MAX_AMPLITUDE = Parameters.TIA_AUDIO_MAX_AMPLITUDE;

    @Override
    public abstract AudioFormat getAudioFormat();

    @Override
    public void connectMonitor(AudioMonitor monitor) {
        this.monitor = monitor;
    }

    public void generateNextSamples(int samples) {
        int remainingSamples = Math.max(this.desiredSamplesPerFrame() - this.generatedSamples, 0);
        this.internalGenerateNextSamples(Math.min(samples, remainingSamples));
    }

    public ChannelStream channel0() {
        return this.channel0;
    }

    public ChannelStream channel1() {
        return this.channel1;
    }

    public void sendSamplesFrameToMonitor() {
        int missingSamples = this.desiredSamplesPerFrame() - this.generatedSamples;
        if (missingSamples > 0) {
            this.generateNextSamples(missingSamples);
        }
        if (this.monitor != null) {
            this.monitor.nextSamples(this.samples, this.generatedSamples);
        }
        this.generatedSamples = 0;
    }

    protected abstract void internalGenerateNextSamples(int var1);

    private int desiredSamplesPerFrame() {
        return this.videoStandard.height * 2;
    }
}

