/*
 * Decompiled with CFR 0.152.
 */
package general.board;

import general.board.BUS16Bits;
import java.util.Arrays;

public final class RAM64k
implements BUS16Bits {
    private byte[] bytes = new byte[65536];

    public RAM64k() {
        Arrays.fill(this.bytes, (byte)0);
    }

    @Override
    public byte readByte(int address) {
        return this.bytes[(char)address];
    }

    public int unsignedByte(int address) {
        return this.readByte(address) & 0xFF;
    }

    @Override
    public void writeByte(int address, byte b) {
        this.bytes[(char)address] = b;
    }

    public void dump(int init, int quant) {
        System.out.printf("MEMORY DUMP FROM %04x:\n", init);
        int i = init;
        while (i < init + quant) {
            System.out.printf("%02x ", this.unsignedByte(i));
            ++i;
        }
        System.out.println();
    }

    public byte[] getMattrix() {
        return this.bytes;
    }
}

