/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.OperandType;

public class JMP
extends Instruction {
    private final OperandType type;
    private char newPC;
    public static final long serialVersionUID = 1L;

    public JMP(M6502 cpu, OperandType type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case ABS: {
                this.newPC = this.cpu.fetchAbsoluteAddress();
                return 3;
            }
            case IND: {
                this.newPC = (char)this.cpu.fetchIndirectAddress();
                return 5;
            }
        }
        throw new IllegalStateException("JMP Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        this.cpu.PC = this.newPC;
    }
}

