/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.OperandType;
import general.m6502.Register;

public class STx
extends Instruction {
    private final Register reg;
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public STx(M6502 cpu, Register reg, OperandType type) {
        super(cpu);
        this.reg = reg;
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 3;
            }
            case Z_PAGE_X: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 4;
            }
            case Z_PAGE_Y: {
                this.ea = this.cpu.fetchZeroPageYAddress();
                return 4;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 4;
            }
            case ABS_X: {
                this.ea = this.cpu.fetchAbsoluteXAddress();
                return 5;
            }
            case ABS_Y: {
                this.ea = this.cpu.fetchAbsoluteYAddress();
                return 5;
            }
            case IND_X: {
                this.ea = this.cpu.fetchIndirectXAddress();
                return 6;
            }
            case IND_Y: {
                this.ea = this.cpu.fetchIndirectYAddress();
                return 6;
            }
        }
        throw new IllegalStateException("STx Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        switch (this.reg) {
            case rA: {
                this.cpu.memory.writeByte(this.ea, this.cpu.A);
                break;
            }
            case rX: {
                this.cpu.memory.writeByte(this.ea, this.cpu.X);
                break;
            }
            case rY: {
                this.cpu.memory.writeByte(this.ea, this.cpu.Y);
                break;
            }
            default: {
                throw new IllegalStateException("STx Invalid Register: " + (Object)((Object)this.reg));
            }
        }
    }
}

