/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.M6502;
import general.m6502.OperandType;
import general.m6502.UndocumentedInstruction;

public class uISB
extends UndocumentedInstruction {
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public uISB(M6502 cpu, OperandType type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 5;
            }
            case Z_PAGE_X: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 6;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 6;
            }
            case ABS_X: {
                this.ea = this.cpu.fetchAbsoluteXAddress();
                return 7;
            }
            case ABS_Y: {
                this.ea = this.cpu.fetchAbsoluteYAddress();
                return 7;
            }
            case IND_X: {
                this.ea = this.cpu.fetchIndirectXAddress();
                return 8;
            }
            case IND_Y: {
                this.ea = this.cpu.fetchIndirectYAddress();
                return 8;
            }
        }
        throw new IllegalStateException("uISB Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        byte val = (byte)(this.cpu.memory.readByte(this.ea) + 1);
        this.cpu.memory.writeByte(this.ea, val);
        byte b = val;
        int uB = M6502.toUnsignedByte(val);
        byte oldA = this.cpu.A;
        int uOldA = M6502.toUnsignedByte(oldA);
        boolean oldCarry = this.cpu.CARRY;
        int aux = oldA - b - (!oldCarry ? 1 : 0);
        int uAux = uOldA - uB - (!oldCarry ? 1 : 0);
        byte newA = (byte)M6502.toUnsignedByte(uAux);
        this.cpu.ZERO = newA == 0;
        this.cpu.NEGATIVE = newA < 0;
        this.cpu.OVERFLOW = aux > 127 || aux < -128;
        boolean bl = this.cpu.CARRY = uAux >= 0;
        if (!this.cpu.DECIMAL_MODE) {
            this.cpu.A = newA;
            return;
        }
        uAux = (uOldA & 0xF) - (uB & 0xF) - (!oldCarry ? 1 : 0);
        if (uAux < 0) {
            uAux = (uAux - 6 & 0xF) - 16;
        }
        if ((uAux = (uOldA & 0xF0) - (uB & 0xF0) + uAux) < 0) {
            uAux -= 96;
        }
        this.cpu.A = (byte)M6502.toUnsignedByte(uAux);
    }
}

