/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.M6502;
import general.m6502.OperandType;
import general.m6502.UndocumentedInstruction;

public class uNOP
extends UndocumentedInstruction {
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public uNOP(M6502 cpu, OperandType type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case IMM: {
                this.ea = this.cpu.fetchImmediateAddress();
                return 2;
            }
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 3;
            }
            case Z_PAGE_X: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 4;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 4;
            }
            case ABS_X: {
                this.ea = this.cpu.fetchAbsoluteXAddress();
                return 4 + (this.cpu.pageCrossed ? 1 : 0);
            }
        }
        throw new IllegalStateException("uNOP Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        this.cpu.memory.readByte(this.ea);
    }
}

