/*
 * Decompiled with CFR 0.152.
 */
package pc.cartridge;

import atari.cartridge.Cartridge;
import atari.cartridge.Cartridge4K;
import atari.cartridge.bankswitching.Cartridge12K;
import atari.cartridge.bankswitching.Cartridge16K;
import atari.cartridge.bankswitching.Cartridge28K;
import atari.cartridge.bankswitching.Cartridge32K;
import atari.cartridge.bankswitching.Cartridge8K;
import atari.cartridge.bankswitching.Cartridge8KSliced;
import general.av.video.VideoStandard;
import pc.cartridge.UnsupportedROMFormatException;

public class CartridgeCreator {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Cartridge create(byte[] content, String name) throws UnsupportedROMFormatException {
        void var3_11;
        String cartName = name.toUpperCase();
        Object var3_3 = null;
        if (cartName.indexOf("(SLICED)") >= 0 || cartName.indexOf("(E0)") >= 0) {
            if (content.length != 8192) throw new UnsupportedROMFormatException("ROM (SLICED, E0) size not supported: " + content.length);
            Cartridge8KSliced cartridge8KSliced = new Cartridge8KSliced(content);
        } else {
            Boolean sc = null;
            if (cartName.indexOf("(SC)") >= 0) {
                sc = true;
            } else if (cartName.indexOf("(NOSC)") >= 0) {
                sc = false;
            }
            switch (content.length) {
                case 0: {
                    return null;
                }
                case 2048: 
                case 4096: {
                    Cartridge4K cartridge4K = new Cartridge4K(content);
                    break;
                }
                case 8192: {
                    Cartridge8K cartridge8K = new Cartridge8K(content, sc);
                    break;
                }
                case 12288: {
                    Cartridge12K cartridge12K = new Cartridge12K(content);
                    break;
                }
                case 16384: {
                    Cartridge16K cartridge16K = new Cartridge16K(content, sc);
                    break;
                }
                case 28672: {
                    Cartridge28K cartridge28K = new Cartridge28K(content);
                    break;
                }
                case 32768: {
                    Cartridge32K cartridge32K = new Cartridge32K(content, sc);
                    break;
                }
                default: {
                    throw new UnsupportedROMFormatException("ROM size not supported: " + content.length);
                }
            }
        }
        if (cartName.indexOf("(PAL)") >= 0) {
            var3_11.suggestedVideoStandard(VideoStandard.PAL);
            return var3_11;
        } else {
            if (cartName.indexOf("(NTSC)") < 0) return var3_11;
            var3_11.suggestedVideoStandard(VideoStandard.NTSC);
        }
        return var3_11;
    }
}

