/*
 * Decompiled with CFR 0.152.
 */
package pc.screen;

import atari.cartridge.Cartridge;
import atari.cartridge.CartridgeSocket;
import atari.controls.ConsoleControlsSocket;
import general.av.video.VideoSignal;
import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import parameters.Parameters;
import pc.room.Room;
import pc.screen.Monitor;
import pc.screen.MonitorDisplay;
import pc.screen.ROMTransferHandlerUtil;
import utils.GraphicsDeviceHelper;
import utils.Terminator;
import utils.slickframe.HotspotManager;

public class MonitorPanel
extends JPanel
implements MonitorDisplay {
    private Monitor monitor;
    private Canvas canvas;
    private BufferStrategy bufferStrategy;
    private HotspotManager hotspots;
    private BufferedImage topLeft;
    private BufferedImage bottomLeft;
    private BufferedImage topRight;
    private BufferedImage bottomRight;
    private BufferedImage top;
    private BufferedImage bottomBar;
    private BufferedImage bottomLeftBar;
    private BufferedImage bottomLeftBarNoPower;
    private BufferedImage bottomRightBar;
    private BufferedImage bottomRightBarFixedSize;
    private BufferedImage logoBar;
    public static final int BORDER_SIZE = Parameters.SCREEN_BORDER_SIZE;
    private int totalCanvasVertPadding;
    private int totalCanvasHorizPadding;
    private static final Insets SLICK_INSETS = new Insets(4, 4, 30, 4);
    public static final long serialVersionUID = 1L;

    public MonitorPanel() {
        this.totalCanvasVertPadding = MonitorPanel.SLICK_INSETS.top + MonitorPanel.SLICK_INSETS.bottom + BORDER_SIZE * 2;
        this.totalCanvasHorizPadding = MonitorPanel.SLICK_INSETS.left + MonitorPanel.SLICK_INSETS.right + BORDER_SIZE * 2;
        this.init();
        this.monitor = new Monitor();
        this.monitor.setDisplay(this);
    }

    public void connect(VideoSignal videoSignal, ConsoleControlsSocket controlsSocket, CartridgeSocket cartridgeSocket) {
        this.monitor.connect(videoSignal, cartridgeSocket);
    }

    public Monitor monitor() {
        return this.monitor;
    }

    public void powerOn() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MonitorPanel.this.setVisible(true);
                MonitorPanel.this.monitor.powerOn();
            }
        });
    }

    public void powerOff() {
        this.monitor.powerOff();
    }

    public void destroy() {
        this.monitor.destroy();
    }

    private void init() {
        this.loadImages();
        this.setBackground(Color.BLACK);
        this.setIgnoreRepaint(true);
        this.setLayout(null);
        this.canvas = new Canvas();
        this.canvas.setBackground(Color.BLACK);
        this.canvas.setIgnoreRepaint(true);
        this.canvas.setFocusTraversalKeysEnabled(false);
        this.add(this.canvas);
        this.positionCanvas();
        this.addKeyListener(new AppletScreenControlKeyListener());
        this.setTransferHandler(new ROMDropTransferHandler());
        this.addHotspots();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Insets ins = this.getInsets();
            this.totalCanvasHorizPadding = ins.left + ins.right + MonitorPanel.SLICK_INSETS.left + MonitorPanel.SLICK_INSETS.right + BORDER_SIZE * 2;
            this.totalCanvasVertPadding = ins.top + ins.bottom + MonitorPanel.SLICK_INSETS.top + MonitorPanel.SLICK_INSETS.bottom + BORDER_SIZE * 2;
            this.canvasSetRenderingMode();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MonitorPanel.this.repaint();
                }
            });
        }
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.canvas.addKeyListener(l);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.canvas.removeKeyListener(l);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        super.addMouseListener(l);
        this.canvas.addMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        super.addMouseMotionListener(l);
        this.canvas.addMouseMotionListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        super.removeMouseListener(l);
        this.canvas.removeMouseListener(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        super.removeMouseMotionListener(l);
        this.canvas.removeMouseMotionListener(l);
    }

    @Override
    public void displaySize(Dimension size) {
        Dimension panelDim = this.panelDimensionForCanvasDimension(size);
        if (this.getSize().equals(panelDim)) {
            return;
        }
        this.setSize(panelDim);
        this.setPreferredSize(panelDim);
        this.setMinimumSize(panelDim);
        this.setMaximumSize(panelDim);
        this.canvas.setSize(size);
        this.validate();
    }

    @Override
    public void displayCenter() {
    }

    @Override
    public Dimension displayEffectiveSize() {
        return this.canvas.getSize();
    }

    @Override
    public Graphics2D displayGraphics() {
        Graphics2D graphics = (Graphics2D)(this.bufferStrategy != null ? this.bufferStrategy.getDrawGraphics() : this.canvas.getGraphics());
        return graphics;
    }

    @Override
    public void displayFinishFrame(Graphics2D graphics) {
        graphics.dispose();
        if (this.bufferStrategy != null) {
            this.bufferStrategy.show();
        }
    }

    @Override
    public Container displayContainer() {
        return this;
    }

    @Override
    public void displayClear() {
        Graphics2D canvasGraphics = this.displayGraphics();
        canvasGraphics.setColor(Color.BLACK);
        canvasGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.displayFinishFrame(canvasGraphics);
    }

    @Override
    public float displayDefaultOpenningScaleX(int displayWidh, int displayHeight) {
        return Monitor.DEFAULT_SCALE_X;
    }

    @Override
    public void displayMinimumSize(Dimension minSize) {
    }

    @Override
    public void displayRequestFocus() {
        this.requestFocus();
    }

    @Override
    public void displayLeaveFullscreen() {
    }

    public void canvasSetRenderingMode() {
        if (Monitor.MULTI_BUFFERING <= 0) {
            return;
        }
        BufferCapabilities desiredCaps = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), Monitor.PAGE_FLIPPING ? BufferCapabilities.FlipContents.BACKGROUND : null);
        Class<?> extBufCapClass = null;
        if (Monitor.BUFFER_VSYNC != -1) {
            try {
                extBufCapClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities");
                Class<?> vSyncTypeClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities$VSyncType");
                Constructor<?> extBufCapConstructor = extBufCapClass.getConstructor(BufferCapabilities.class, vSyncTypeClass);
                Object vSyncType = vSyncTypeClass.getField(Monitor.BUFFER_VSYNC == 1 ? "VSYNC_ON" : "VSYNC_OFF").get(null);
                BufferCapabilities extBuffCaps = (BufferCapabilities)extBufCapConstructor.newInstance(desiredCaps, vSyncType);
                this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING, extBuffCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.canvas.getBufferStrategy() == null) {
            try {
                this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING, desiredCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.canvas.getBufferStrategy() == null) {
            System.out.println("Could not create desired BufferStrategy. Switching to default...");
            this.canvas.createBufferStrategy(Monitor.MULTI_BUFFERING);
        }
        this.bufferStrategy = this.canvas.getBufferStrategy();
        BufferCapabilities grantedCaps = this.bufferStrategy.getCapabilities();
        System.out.println("Backbuffer accelerated: " + grantedCaps.getBackBufferCapabilities().isAccelerated());
        System.out.println("PageFlipping active: " + grantedCaps.isPageFlipping() + ", " + grantedCaps.getFlipContents());
        if (extBufCapClass != null && grantedCaps.getClass().equals(extBufCapClass)) {
            try {
                System.out.println("VSynch active: " + extBufCapClass.getMethod("getVSync", null).invoke((Object)grantedCaps, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Dimension panelDimensionForCanvasDimension(Dimension size) {
        return new Dimension(size.width + this.totalCanvasHorizPadding, size.height + this.totalCanvasVertPadding);
    }

    private void positionCanvas() {
        this.canvas.setLocation(MonitorPanel.SLICK_INSETS.left + BORDER_SIZE, MonitorPanel.SLICK_INSETS.top + BORDER_SIZE);
    }

    private void addHotspots() {
        this.hotspots = new HotspotManager(this);
        this.hotspots.addHotspot(new Rectangle(-10000, -27, 24, 28), new Runnable(){

            @Override
            public void run() {
            }
        });
        this.hotspots.addHotspot(new Rectangle(-28, -24, 17, 19), new Runnable(){

            @Override
            public void run() {
                Room.openCurrentRoomSettings();
                MonitorPanel.this.requestFocus();
            }
        });
    }

    private void loadImages() {
        try {
            this.topLeft = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/TopLeft.png");
            this.bottomLeft = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomLeft.png");
            this.topRight = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/TopRight.png");
            this.bottomRight = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomRight.png");
            this.top = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/Top.png");
            this.bottomLeftBar = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomLeftBar.png");
            this.bottomLeftBarNoPower = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomLeftBarNoPower.png");
            this.bottomRightBar = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomRightBar.png");
            this.bottomRightBarFixedSize = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomRightBarFixedSize.png");
            this.bottomBar = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/BottomBar.png");
            this.logoBar = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/LogoBar.png");
        }
        catch (IOException ex) {
            System.out.println("Screen Window: unable to load images\n" + ex);
        }
    }

    private void exit() {
        Terminator.terminate();
    }

    @Override
    public void paintComponent(Graphics origGraphics) {
        super.paintComponent(origGraphics);
        Insets ins = this.getInsets();
        int w = this.getWidth() - ins.left - ins.right;
        int h = this.getHeight() - ins.top - ins.bottom;
        Graphics g = origGraphics.create(ins.left, ins.top, w, h);
        g.setColor(Color.BLACK);
        g.fillRect(MonitorPanel.SLICK_INSETS.left, MonitorPanel.SLICK_INSETS.top, this.getWidth() - MonitorPanel.SLICK_INSETS.left - MonitorPanel.SLICK_INSETS.right, this.getHeight() - MonitorPanel.SLICK_INSETS.top - MonitorPanel.SLICK_INSETS.bottom);
        int halfH = (h - 30) / 2;
        int halfW = w / 2;
        int maxHalfW = Math.min(halfW - 11, 512);
        int x = 0;
        while (x < w) {
            g.drawImage(this.top, x, 0, null);
            x += 512;
        }
        g.drawImage(this.topLeft, 0, 0, null);
        g.drawImage(this.topRight, w - 4, 0, null);
        x = 512;
        while (x < w - 512) {
            g.drawImage(this.bottomBar, x, h - 30, x + 256, h, 0, 0, 256, 30, null);
            x += 256;
        }
        g.drawImage(this.logoBar, halfW - 12, h - 30, null);
        BufferedImage bLeftBar = this.monitor.isFixedSize() ? this.bottomLeftBarNoPower : this.bottomLeftBar;
        g.drawImage(bLeftBar, 0, h - 30, maxHalfW, h, 0, 0, maxHalfW, 30, null);
        BufferedImage bRightBar = this.monitor.isFixedSize() ? this.bottomRightBarFixedSize : this.bottomRightBar;
        g.drawImage(bRightBar, w - maxHalfW, h - 30, w, h, 512 - maxHalfW, 0, 512, 30, null);
        g.drawImage(this.bottomLeft, 0, halfH, 4, h - 30, 0, 600 - halfH, 4, 600, null);
        g.drawImage(this.bottomRight, w - 4, halfH, w, h - 30, 0, 600 - halfH, 4, 600, null);
        g.dispose();
    }

    private class AppletScreenControlKeyListener
    extends KeyAdapter {
        static final int KEY_EXIT = 27;
        static final int KEY_HELP = 72;

        private AppletScreenControlKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            switch (e.getModifiersEx()) {
                case 0: {
                    if (code == 27) {
                        MonitorPanel.this.exit();
                    }
                    return;
                }
                case 512: {
                    switch (code) {
                        case 72: {
                            return;
                        }
                    }
                }
            }
        }
    }

    class ROMDropTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        ROMDropTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!MonitorPanel.this.monitor.isCartridgeChangeEnabled()) {
                return false;
            }
            Transferable transf = support.getTransferable();
            if (!ROMTransferHandlerUtil.canAccept(transf)) {
                return false;
            }
            if (support.isDrop() && support.getUserDropAction() != 0x40000000) {
                support.setDropAction(1);
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Cartridge cart = ROMTransferHandlerUtil.importCartridgeData(support.getTransferable());
            if (cart == null) {
                return false;
            }
            boolean autoPower = !support.isDrop() || support.getDropAction() != 0x40000000;
            MonitorPanel.this.monitor.cartridgeInsert(cart, autoPower);
            return true;
        }
    }
}

