/*
 * Decompiled with CFR 0.152.
 */
package pc.screen;

import atari.cartridge.CartridgeSocket;
import atari.controls.ConsoleControlsSocket;
import general.av.video.VideoSignal;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import parameters.Parameters;
import pc.screen.ConsolePanel;
import pc.screen.Monitor;
import pc.screen.MonitorPanel;
import pc.screen.Screen;

public class PanelScreen
extends JPanel
implements Screen {
    public MonitorPanel monitorPanel = new MonitorPanel();
    public ConsolePanel consolePanel;
    private static final boolean CONSOLE_PANEL = Parameters.SCREEN_CONSOLE_PANEL;
    private static final long serialVersionUID = 1L;

    public PanelScreen(boolean screenFixedSize) {
        this.monitorPanel.monitor().setFixedSize(screenFixedSize);
        this.monitorPanel.monitor().addControlInputComponents(this);
        if (CONSOLE_PANEL) {
            this.consolePanel = new ConsolePanel(this.monitorPanel.monitor(), null);
        }
        this.setup();
    }

    @Override
    public void connect(VideoSignal videoSignal, ConsoleControlsSocket controlsSocket, CartridgeSocket cartridgeSocket) {
        this.monitorPanel.connect(videoSignal, controlsSocket, cartridgeSocket);
        if (this.consolePanel != null) {
            this.consolePanel.connect(controlsSocket);
        }
    }

    @Override
    public void powerOn() {
        this.monitorPanel.powerOn();
    }

    @Override
    public void powerOff() {
        this.monitorPanel.powerOff();
    }

    @Override
    public void destroy() {
        this.monitorPanel.destroy();
    }

    @Override
    public Monitor monitor() {
        return this.monitorPanel.monitor();
    }

    @Override
    public Component[] controlsInputComponents() {
        return new Component[]{this};
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.monitorPanel.addKeyListener(l);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener l) {
        super.removeKeyListener(l);
        this.monitorPanel.removeKeyListener(l);
    }

    private void setup() {
        this.monitorPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (e.getComponent() == PanelScreen.this.monitorPanel) {
                    PanelScreen.this.validate();
                }
            }
        });
        this.setLayout(new FlowLayout(1, 0, 0));
        this.setOpaque(false);
        this.add(this.monitorPanel);
        if (this.consolePanel != null) {
            this.add(this.consolePanel);
        }
        this.validate();
    }
}

