/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.StatusBit;

public class SEx
extends Instruction {
    private final StatusBit bit;
    public static final long serialVersionUID = 1L;

    public SEx(M6502 cpu, StatusBit bit) {
        super(cpu);
        this.bit = bit;
    }

    @Override
    public int fetch() {
        return 2;
    }

    @Override
    public void execute() {
        switch (this.bit) {
            case bCARRY: {
                this.cpu.CARRY = true;
                break;
            }
            case bDECIMAL_MODE: {
                this.cpu.DECIMAL_MODE = true;
                break;
            }
            case bINTERRUPT_DISABLE: {
                this.cpu.INTERRUPT_DISABLE = true;
                break;
            }
            default: {
                throw new IllegalStateException("SEx Invalid StatusBit: " + (Object)((Object)this.bit));
            }
        }
    }
}

