/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.Register;

public class Txx
extends Instruction {
    private final Register source;
    private final Register dest;
    public static final long serialVersionUID = 1L;

    public Txx(M6502 cpu, Register source, Register dest) {
        super(cpu);
        this.source = source;
        this.dest = dest;
    }

    @Override
    public int fetch() {
        return 2;
    }

    @Override
    public void execute() {
        byte val;
        switch (this.source) {
            case rA: {
                val = this.cpu.A;
                break;
            }
            case rX: {
                val = this.cpu.X;
                break;
            }
            case rY: {
                val = this.cpu.Y;
                break;
            }
            case rSP: {
                val = this.cpu.SP;
                break;
            }
            default: {
                throw new IllegalStateException("Txx Invalid Source Register: " + (Object)((Object)this.source));
            }
        }
        switch (this.dest) {
            case rA: {
                this.cpu.A = val;
                break;
            }
            case rX: {
                this.cpu.X = val;
                break;
            }
            case rY: {
                this.cpu.Y = val;
                break;
            }
            case rSP: {
                this.cpu.SP = val;
                break;
            }
            default: {
                throw new IllegalStateException("Txx Invalid Destination Register: " + (Object)((Object)this.dest));
            }
        }
        if (this.dest != Register.rSP) {
            this.cpu.ZERO = val == 0;
            this.cpu.NEGATIVE = val < 0;
        }
    }
}

