/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.M6502;
import general.m6502.OperandType;
import general.m6502.UndocumentedInstruction;

public class uSAX
extends UndocumentedInstruction {
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public uSAX(M6502 cpu, OperandType type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 3;
            }
            case Z_PAGE_Y: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 4;
            }
            case IND_X: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 6;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 4;
            }
        }
        throw new IllegalStateException("uAAX Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        byte val = (byte)(this.cpu.A & this.cpu.X);
        this.cpu.memory.writeByte(this.ea, val);
    }
}

