/*
 * Decompiled with CFR 0.152.
 */
package pc.screen;

import atari.controls.ConsoleControls;
import atari.controls.ConsoleControlsInput;
import atari.controls.ConsoleControlsRedefinitionListener;
import atari.controls.ConsoleControlsSocket;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import pc.screen.Monitor;
import utils.GraphicsDeviceHelper;
import utils.slickframe.HotspotManager;
import utils.slickframe.MousePressAndMotionListener;

public class ConsolePanel
extends JPanel
implements ConsoleControls,
ConsoleControlsInput,
ConsoleControlsRedefinitionListener {
    private HotspotManager hotspots;
    private BufferedImage panelImage;
    private BufferedImage powerDownImage;
    private BufferedImage colorDownImage;
    private BufferedImage selectDownImage;
    private BufferedImage resetDownImage;
    private BufferedImage p0DiffDownImage;
    private BufferedImage p1DiffDownImage;
    private final Monitor screen;
    private ConsoleControlsSocket consoleControlsSocket;
    private Map<ConsoleControls.Control, Boolean> controlsStateReport = new HashMap<ConsoleControls.Control, Boolean>();
    public static final int WIDTH = 465;
    public static final int HEIGHT = 137;
    private static final Set<ConsoleControls.Control> visibleControls = new HashSet<ConsoleControls.Control>(Arrays.asList(ConsoleControls.Control.POWER, ConsoleControls.Control.BLACK_WHITE, ConsoleControls.Control.SELECT, ConsoleControls.Control.RESET, ConsoleControls.Control.DIFFICULTY0, ConsoleControls.Control.DIFFICULTY1));
    public static final long serialVersionUID = 1L;

    public ConsolePanel(Monitor screen, MousePressAndMotionListener forwardListener) {
        this.screen = screen;
        this.buildGUI();
        this.addHotspots(forwardListener);
    }

    public void connect(ConsoleControlsSocket controlsSocket) {
        this.consoleControlsSocket = controlsSocket;
        this.consoleControlsSocket.addForwardedInput(this);
        this.consoleControlsSocket.addRedefinitionListener(this);
        this.updateVisibleControlsState();
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, boolean state) {
        if (visibleControls.contains((Object)control)) {
            this.updateVisibleControlsState();
        }
    }

    @Override
    public void controlStateChanged(ConsoleControls.Control control, int position) {
        if (visibleControls.contains((Object)control)) {
            this.updateVisibleControlsState();
        }
    }

    @Override
    public void controlsStateReport(Map<ConsoleControls.Control, Boolean> report) {
    }

    @Override
    public void controlsStatesRedefined() {
        this.updateVisibleControlsState();
    }

    private void buildGUI() {
        this.loadImages();
        Dimension size = this.desiredSize();
        this.setSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.setFocusable(false);
    }

    private void loadImages() {
        try {
            this.panelImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/Panel.png");
            this.powerDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/PowerDown.png");
            this.colorDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/ColorDown.png");
            this.selectDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/SelectDown.png");
            this.resetDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/ResetDown.png");
            this.p0DiffDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/P0DiffDown.png");
            this.p1DiffDownImage = GraphicsDeviceHelper.loadAsCompatibleImage("pc/screen/images/P1DiffDown.png");
        }
        catch (IOException ex) {
            System.out.println("Console Panel: unable to load images\n" + ex);
        }
    }

    private void addHotspots(MousePressAndMotionListener forwardListener) {
        this.hotspots = forwardListener != null ? new HotspotManager(this, forwardListener) : new HotspotManager(this);
        this.hotspots.addHotspot(new Rectangle(31, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.POWER, true);
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(95, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.BLACK_WHITE, true);
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(351, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.SELECT, true);
                }
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.SELECT, false);
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(414, -85, 24, 46), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.RESET, true);
                }
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.RESET, false);
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(161, -133, 34, 21), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.DIFFICULTY0, true);
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(274, -133, 34, 21), new Runnable(){

            @Override
            public void run() {
                if (ConsolePanel.this.consoleControlsSocket != null) {
                    ConsolePanel.this.consoleControlsSocket.controlStateChanged(ConsoleControls.Control.DIFFICULTY1, true);
                }
            }
        });
        this.hotspots.addHotspot(new Rectangle(160, -83, 74, 43), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.screen.controlStateChanged(Monitor.Control.LOAD_CARTRIDGE_FILE, true);
            }
        });
        this.hotspots.addHotspot(new Rectangle(235, -83, 74, 43), new Runnable(){

            @Override
            public void run() {
                ConsolePanel.this.screen.controlStateChanged(Monitor.Control.LOAD_CARTRIDGE_URL, true);
            }
        });
    }

    private Dimension desiredSize() {
        Insets ins = this.getInsets();
        return new Dimension(465 + ins.left + ins.right, 137 + ins.top + ins.bottom);
    }

    private void updateVisibleControlsState() {
        this.consoleControlsSocket.controlsStateReport(this.controlsStateReport);
        if (this.isVisible()) {
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets ins = this.getInsets();
        int initialHeight = 137 - (this.getHeight() - ins.top - ins.bottom);
        g.drawImage(this.panelImage, ins.left, ins.top, this.getWidth() - ins.right, this.getHeight() - ins.bottom, 0, initialHeight, this.getWidth() - ins.left - ins.right, initialHeight + this.getHeight() - ins.top - ins.bottom, null);
        if (this.controlsStateReport.isEmpty()) {
            return;
        }
        int panelBottom = this.getHeight() - ins.bottom;
        if (!this.controlsStateReport.get((Object)ConsoleControls.Control.POWER).booleanValue()) {
            g.drawImage(this.powerDownImage, ins.left + 33, panelBottom - 87, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.BLACK_WHITE).booleanValue()) {
            g.drawImage(this.colorDownImage, ins.left + 97, panelBottom - 87, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.SELECT).booleanValue()) {
            g.drawImage(this.selectDownImage, ins.left + 353, panelBottom - 87, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.RESET).booleanValue()) {
            g.drawImage(this.resetDownImage, ins.left + 416, panelBottom - 87, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.DIFFICULTY0).booleanValue()) {
            g.drawImage(this.p0DiffDownImage, ins.left + 164, panelBottom - 131, null);
        }
        if (this.controlsStateReport.get((Object)ConsoleControls.Control.DIFFICULTY1).booleanValue()) {
            g.drawImage(this.p1DiffDownImage, ins.left + 277, panelBottom - 131, null);
        }
    }
}

