/*
 * Decompiled with CFR 0.152.
 */
package pc.screen;

import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.ImageCapabilities;
import java.awt.image.BufferStrategy;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import pc.screen.DesktopScreenWindow;
import pc.screen.Monitor;
import pc.screen.MonitorDisplay;

public class DesktopScreenFullWindow
extends JFrame
implements MonitorDisplay {
    private final DesktopScreenWindow window;
    private int canvasOriginX;
    private int canvasOriginY;
    private Dimension canvasEffectiveSize;
    private int clearBackgoundFrames = 0;
    private BufferStrategy bufferStrategy;
    public static final long serialVersionUID = 1L;

    public DesktopScreenFullWindow(DesktopScreenWindow window) {
        this.window = window;
        this.init();
    }

    private void init() {
        this.setLayout(null);
        this.setUndecorated(true);
        this.setBackground(Color.BLACK);
        this.setIgnoreRepaint(true);
        this.getContentPane().setBackground(Color.BLACK);
        this.getContentPane().setIgnoreRepaint(true);
        this.setIconImages(Arrays.asList(this.window.icon64, this.window.icon32, this.window.favicon));
        this.setTitle("javatari - Fullwindow");
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.canvasSetRenderingMode();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DesktopScreenFullWindow.this.repaint();
                }
            });
        }
    }

    @Override
    public void displaySize(Dimension size) {
        this.canvasOriginX = (this.getWidth() - size.width) / 2;
        this.canvasOriginY = (this.getHeight() - size.height) / 2;
        this.canvasEffectiveSize = size;
        this.repaint();
        if (this.bufferStrategy != null && this.bufferStrategy.getCapabilities().getFlipContents() != BufferCapabilities.FlipContents.BACKGROUND) {
            this.clearBackgoundFrames = Monitor.MULTI_BUFFERING + 2;
        }
    }

    @Override
    public void displayMinimumSize(Dimension minSize) {
    }

    @Override
    public void displayCenter() {
    }

    @Override
    public Dimension displayEffectiveSize() {
        return this.canvasEffectiveSize;
    }

    @Override
    public Graphics2D displayGraphics() {
        Graphics2D canvasGraphics = (Graphics2D)(this.bufferStrategy != null ? this.bufferStrategy.getDrawGraphics() : this.getGraphics());
        if (this.clearBackgoundFrames-- > 0) {
            canvasGraphics.setColor(Color.BLACK);
            canvasGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
        canvasGraphics.translate(this.canvasOriginX, this.canvasOriginY);
        return canvasGraphics;
    }

    @Override
    public void displayFinishFrame(Graphics2D graphics) {
        graphics.dispose();
        if (this.bufferStrategy != null) {
            this.bufferStrategy.show();
        }
    }

    @Override
    public void displayClear() {
        Graphics2D canvasGraphics = this.displayGraphics();
        canvasGraphics.setColor(Color.BLACK);
        canvasGraphics.clearRect(0, 0, this.getWidth(), this.getHeight());
        this.displayFinishFrame(canvasGraphics);
    }

    @Override
    public Container displayContainer() {
        return this;
    }

    @Override
    public float displayDefaultOpenningScaleX(int displayWidth, int displayHeight) {
        float scaleX = this.getWidth() / displayWidth;
        scaleX -= scaleX % Monitor.DEFAULT_SCALE_ASPECT_X;
        float h = scaleX / Monitor.DEFAULT_SCALE_ASPECT_X * (float)displayHeight;
        while (h > (float)(this.getHeight() + 20)) {
            h = (scaleX -= Monitor.DEFAULT_SCALE_ASPECT_X) / Monitor.DEFAULT_SCALE_ASPECT_X * (float)displayHeight;
        }
        return scaleX;
    }

    @Override
    public void displayRequestFocus() {
        this.requestFocus();
    }

    @Override
    public void displayLeaveFullscreen() {
        this.window.displayLeaveFullscreen();
    }

    public void canvasSetRenderingMode() {
        if (Monitor.MULTI_BUFFERING <= 0) {
            return;
        }
        BufferCapabilities desiredCaps = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), Monitor.PAGE_FLIPPING ? BufferCapabilities.FlipContents.BACKGROUND : null);
        Class<?> extBufCapClass = null;
        if (Monitor.BUFFER_VSYNC != -1) {
            try {
                extBufCapClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities");
                Class<?> vSyncTypeClass = Class.forName("sun.java2d.pipe.hw.ExtendedBufferCapabilities$VSyncType");
                Constructor<?> extBufCapConstructor = extBufCapClass.getConstructor(BufferCapabilities.class, vSyncTypeClass);
                Object vSyncType = vSyncTypeClass.getField(Monitor.BUFFER_VSYNC == 1 ? "VSYNC_ON" : "VSYNC_OFF").get(null);
                BufferCapabilities extBuffCaps = (BufferCapabilities)extBufCapConstructor.newInstance(desiredCaps, vSyncType);
                this.createBufferStrategy(Monitor.MULTI_BUFFERING, extBuffCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.getBufferStrategy() == null) {
            try {
                this.createBufferStrategy(Monitor.MULTI_BUFFERING, desiredCaps);
            }
            catch (Exception vSyncTypeClass) {
                // empty catch block
            }
        }
        if (this.getBufferStrategy() == null) {
            System.out.println("Could not create desired BufferStrategy. Switching to default...");
            this.createBufferStrategy(Monitor.MULTI_BUFFERING);
        }
        this.bufferStrategy = this.getBufferStrategy();
        BufferCapabilities grantedCaps = this.bufferStrategy.getCapabilities();
        System.out.println("Backbuffer accelerated: " + grantedCaps.getBackBufferCapabilities().isAccelerated());
        System.out.println("PageFlipping active: " + grantedCaps.isPageFlipping() + ", " + grantedCaps.getFlipContents());
        if (extBufCapClass != null && grantedCaps.getClass().equals(extBufCapClass)) {
            try {
                System.out.println("VSynch active: " + extBufCapClass.getMethod("getVSync", null).invoke((Object)grantedCaps, new Object[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

