/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge;

import general.av.video.VideoStandard;
import general.board.BUS16Bits;
import java.io.Serializable;
import java.util.Arrays;

public abstract class Cartridge
implements BUS16Bits,
Cloneable,
Serializable {
    protected byte[] bytes;
    private VideoStandard suggestedVideoStandard = null;
    public static final long serialVersionUID = 1L;

    @Override
    public byte readByte(int address) {
        return this.bytes[this.maskAddress(address)];
    }

    @Override
    public void writeByte(int address, byte b) {
    }

    public Cartridge clone() {
        try {
            return (Cartridge)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public VideoStandard suggestedVideoStandard() {
        return this.suggestedVideoStandard;
    }

    public void suggestedVideoStandard(VideoStandard videoStandard) {
        this.suggestedVideoStandard = videoStandard;
    }

    protected int maskAddress(int address) {
        return address & 0xFFF;
    }

    protected void setContent(byte[] content) {
        this.bytes = content;
    }

    protected void emptyContent(int size) {
        this.bytes = new byte[size];
        Arrays.fill(this.bytes, (byte)0);
    }
}

