/*
 * Decompiled with CFR 0.152.
 */
package atari.cartridge.bankswitching;

import atari.cartridge.Cartridge;
import java.util.Arrays;

public abstract class CartridgeBanked
extends Cartridge {
    protected int bankAddressOffset = 0;
    private boolean superChipMode = false;
    private final boolean superChipAutoDetect;
    private final int extraRAMSize;
    private byte[] extraRAM;
    public static final long serialVersionUID = 1L;

    protected CartridgeBanked(byte[] content, Boolean superChip, int extraRAMSize) {
        this.setContent(content);
        this.extraRAMSize = extraRAMSize;
        if (superChip == null) {
            this.superChipMode = false;
            this.superChipAutoDetect = true;
        } else {
            this.superChipMode = superChip;
            this.superChipAutoDetect = false;
        }
        this.extraRAM = superChip == null || superChip != false ? Arrays.copyOf(this.bytes, extraRAMSize) : null;
    }

    @Override
    public byte readByte(int address) {
        int addr = this.maskAddress(address);
        if (this.superChipMode && addr >= this.extraRAMSize && addr < this.extraRAMSize * 2) {
            return this.extraRAM[addr - this.extraRAMSize];
        }
        return this.bytes[addr + this.bankAddressOffset];
    }

    @Override
    public void writeByte(int address, byte b) {
        int addr = this.maskAddress(address);
        if (addr < this.extraRAMSize && (this.superChipMode || this.superChipAutoDetect)) {
            if (!this.superChipMode) {
                System.out.println(">>>> SuperChip ON");
                this.superChipMode = true;
            }
            this.extraRAM[addr] = b;
        }
    }

    @Override
    public CartridgeBanked clone() {
        CartridgeBanked clone = (CartridgeBanked)super.clone();
        if (this.extraRAM != null) {
            clone.extraRAM = (byte[])this.extraRAM.clone();
        }
        return clone;
    }
}

