/*
 * Decompiled with CFR 0.152.
 */
package general.board;

import general.board.ClockDriven;
import java.util.Locale;

public class Clock
extends Thread {
    protected double hertz;
    protected ClockDriven driven;
    protected boolean alive = true;
    protected boolean running = false;
    protected long cycleDuration;
    protected long cycle = 0L;
    protected long startTime = 0L;

    public Clock(String name, ClockDriven driven, double hertz) {
        this(name);
        this.driven = driven;
        this.speed(hertz);
        this.start();
    }

    protected Clock(String name) {
        super(name);
    }

    public void go() {
        if (this.cycleDuration == 0L) {
            return;
        }
        this.running = true;
        this.interrupt();
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void pause() {
        this.running = false;
        this.interrupt();
        Clock clock = this;
        // MONITORENTER : clock
        // MONITOREXIT : clock
    }

    public void terminate() {
        this.alive = false;
        this.running = false;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void speed(double hertz) {
        if (this.hertz == hertz) {
            return;
        }
        boolean wasRunning = this.running;
        this.pause();
        this.hertz = hertz;
        long l = this.cycleDuration = hertz > 0.0 ? (long)(1.0 / hertz * 1.0E9) : (long)hertz;
        if (wasRunning) {
            this.go();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized void run() {
        ** GOTO lbl29
        {
            try {
                this.wait();
            }
            catch (InterruptedException var1_1) {
                // empty catch block
            }
            do {
                if (this.alive && !this.running) continue block4;
                if (!this.alive) {
                    return;
                }
                this.cycle = 0L;
                this.startTime = this.systemNanos();
                try {
                    while (this.running) {
                        this.driven.clockPulse();
                        ++this.cycle;
                        if (this.cycleDuration > 0L) {
                            waitTime = this.startTime + this.cycle * this.cycleDuration - this.systemNanos();
                            if (waitTime > 0L) {
                                Clock.sleep(waitTime / 1000000L, (int)(waitTime % 1000000L));
                                continue;
                            }
                            Clock.yield();
                            continue;
                        }
                        Clock.yield();
                    }
                }
                catch (InterruptedException var3_3) {
                    // empty catch block
                }
lbl29:
                // 3 sources

            } while (this.alive);
        }
    }

    @Override
    public String toString() {
        String res;
        String string = this.alive ? (this.running ? "Running" : "Paused") : (res = "Terminated");
        if (this.running) {
            float cy = this.cyclesPerSecond();
            res = cy > 1000000.0f ? String.valueOf(res) + " at " + String.format(Locale.ENGLISH, "%.3fMHz", Float.valueOf(cy / 1000000.0f)) : (cy > 1000.0f ? String.valueOf(res) + " at " + String.format(Locale.ENGLISH, "%.3fKHz", Float.valueOf(cy / 1000.0f)) : String.valueOf(res) + " at " + String.format(Locale.ENGLISH, "%.3fHz", Float.valueOf(cy)));
        }
        return res;
    }

    protected long systemNanos() {
        return System.nanoTime();
    }

    private float cyclesPerSecond() {
        long elapsed = this.systemNanos() - this.startTime;
        if (elapsed <= 0L) {
            return -1.0f;
        }
        return (float)this.cycle / ((float)elapsed / 1.0E9f);
    }
}

