/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.OperandType;
import general.m6502.Register;

public class CPx
extends Instruction {
    private final Register reg;
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public CPx(M6502 cpu, Register reg, OperandType type) {
        super(cpu);
        this.reg = reg;
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case IMM: {
                this.ea = this.cpu.fetchImmediateAddress();
                return 2;
            }
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 3;
            }
            case Z_PAGE_X: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 4;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 4;
            }
            case ABS_X: {
                this.ea = this.cpu.fetchAbsoluteXAddress();
                return 4 + (this.cpu.pageCrossed ? 1 : 0);
            }
            case ABS_Y: {
                this.ea = this.cpu.fetchAbsoluteYAddress();
                return 4 + (this.cpu.pageCrossed ? 1 : 0);
            }
            case IND_X: {
                this.ea = this.cpu.fetchIndirectXAddress();
                return 6;
            }
            case IND_Y: {
                this.ea = this.cpu.fetchIndirectYAddress();
                return 5 + (this.cpu.pageCrossed ? 1 : 0);
            }
        }
        throw new IllegalStateException("CPx Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        int uR;
        int uVal = M6502.toUnsignedByte(this.cpu.memory.readByte(this.ea));
        switch (this.reg) {
            case rA: {
                uR = M6502.toUunsignedByte(this.cpu.A);
                break;
            }
            case rX: {
                uR = M6502.toUunsignedByte(this.cpu.X);
                break;
            }
            case rY: {
                uR = M6502.toUunsignedByte(this.cpu.Y);
                break;
            }
            default: {
                throw new IllegalStateException("CPx Invalid Register: " + (Object)((Object)this.reg));
            }
        }
        this.cpu.CARRY = uR >= uVal;
        this.cpu.ZERO = uR == uVal;
        this.cpu.NEGATIVE = (byte)(uR - uVal) < 0;
    }
}

