/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.Instruction;
import general.m6502.M6502;
import general.m6502.OperandType;
import general.m6502.Register;

public class LDx
extends Instruction {
    private final Register reg;
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public LDx(M6502 cpu, Register reg, OperandType type) {
        super(cpu);
        this.reg = reg;
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case IMM: {
                this.ea = this.cpu.fetchImmediateAddress();
                return 2;
            }
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 3;
            }
            case Z_PAGE_X: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 4;
            }
            case Z_PAGE_Y: {
                this.ea = this.cpu.fetchZeroPageYAddress();
                return 4;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 4;
            }
            case ABS_X: {
                this.ea = this.cpu.fetchAbsoluteXAddress();
                return 4 + (this.cpu.pageCrossed ? 1 : 0);
            }
            case ABS_Y: {
                this.ea = this.cpu.fetchAbsoluteYAddress();
                return 4 + (this.cpu.pageCrossed ? 1 : 0);
            }
            case IND_X: {
                this.ea = this.cpu.fetchIndirectXAddress();
                return 6;
            }
            case IND_Y: {
                this.ea = this.cpu.fetchIndirectYAddress();
                return 5 + (this.cpu.pageCrossed ? 1 : 0);
            }
        }
        throw new IllegalStateException("LDx Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        byte val = this.cpu.memory.readByte(this.ea);
        switch (this.reg) {
            case rA: {
                this.cpu.A = val;
                break;
            }
            case rX: {
                this.cpu.X = val;
                break;
            }
            case rY: {
                this.cpu.Y = val;
                break;
            }
            default: {
                throw new IllegalStateException("LDx Invalid Register: " + (Object)((Object)this.reg));
            }
        }
        this.cpu.ZERO = val == 0;
        this.cpu.NEGATIVE = val < 0;
    }
}

