/*
 * Decompiled with CFR 0.152.
 */
package general.m6502.instructions;

import general.m6502.M6502;
import general.m6502.OperandType;
import general.m6502.UndocumentedInstruction;

public class uDCP
extends UndocumentedInstruction {
    private final OperandType type;
    private int ea;
    public static final long serialVersionUID = 1L;

    public uDCP(M6502 cpu, OperandType type) {
        super(cpu);
        this.type = type;
    }

    @Override
    public int fetch() {
        switch (this.type) {
            case Z_PAGE: {
                this.ea = this.cpu.fetchZeroPageAddress();
                return 5;
            }
            case Z_PAGE_X: {
                this.ea = this.cpu.fetchZeroPageXAddress();
                return 6;
            }
            case ABS: {
                this.ea = this.cpu.fetchAbsoluteAddress();
                return 6;
            }
            case ABS_X: {
                this.ea = this.cpu.fetchAbsoluteXAddress();
                return 7;
            }
            case ABS_Y: {
                this.ea = this.cpu.fetchAbsoluteYAddress();
                return 7;
            }
            case IND_X: {
                this.ea = this.cpu.fetchIndirectXAddress();
                return 8;
            }
            case IND_Y: {
                this.ea = this.cpu.fetchIndirectYAddress();
                return 8;
            }
        }
        throw new IllegalStateException("uDCP Invalid Operand Type: " + (Object)((Object)this.type));
    }

    @Override
    public void execute() {
        byte val = (byte)(this.cpu.memory.readByte(this.ea) - 1);
        this.cpu.memory.writeByte(this.ea, val);
        int uVal = M6502.toUunsignedByte(val);
        int uA = M6502.toUunsignedByte(this.cpu.A);
        this.cpu.CARRY = uA >= uVal;
        this.cpu.ZERO = uA == uVal;
        this.cpu.NEGATIVE = (byte)(uA - uVal) < 0;
    }
}

