/*
 * Decompiled with CFR 0.152.
 */
package pc.room;

import atari.cartridge.Cartridge;
import atari.console.Console;
import atari.network.ClientConsole;
import atari.network.RemoteReceiver;
import atari.network.RemoteTransmitter;
import atari.network.ServerConsole;
import parameters.Parameters;
import pc.cartridge.ROMLoader;
import pc.controls.AWTConsoleControls;
import pc.room.AppletRoom;
import pc.room.settings.SettingsDialog;
import pc.savestate.FileSaveStateMedia;
import pc.screen.DesktopScreenWindow;
import pc.screen.Screen;
import pc.speaker.Speaker;
import utils.Terminator;

public class Room {
    private Console currentConsole;
    private Console standaloneConsole;
    private ServerConsole serverConsole;
    private ClientConsole clientConsole;
    private Screen screen;
    private Speaker speaker;
    private AWTConsoleControls controls;
    private FileSaveStateMedia stateMedia;
    private Cartridge cartridgeProvided;
    private boolean triedToLoadCartridgeProvided = false;
    private static Room currentRoom;
    private static SettingsDialog settingsDialog;

    Room() {
    }

    public void powerOn() {
        this.screen.powerOn();
        this.speaker.powerOn();
        this.insertCartridgeProvidedIfNoneInserted();
        if (this.currentConsole.cartridgeSocket().inserted() != null) {
            this.currentConsole.powerOn();
        }
    }

    public void powerOff() {
        this.currentConsole.powerOff();
        this.speaker.powerOff();
        this.screen.powerOff();
    }

    public Console currentConsole() {
        return this.currentConsole;
    }

    public Console standaloneCurrentConsole() {
        if (this.currentConsole != this.standaloneConsole) {
            throw new IllegalStateException();
        }
        return this.standaloneConsole;
    }

    public ServerConsole serverCurrentConsole() {
        if (this.currentConsole != this.serverConsole) {
            throw new IllegalStateException();
        }
        return this.serverConsole;
    }

    public ClientConsole clientCurrentConsole() {
        if (this.currentConsole != this.clientConsole) {
            throw new IllegalStateException();
        }
        return this.clientConsole;
    }

    public Screen screen() {
        return this.screen;
    }

    public Speaker speaker() {
        return this.speaker;
    }

    public AWTConsoleControls controls() {
        return this.controls;
    }

    public FileSaveStateMedia stateMedia() {
        return this.stateMedia;
    }

    public boolean isStandaloneMode() {
        return this.currentConsole == this.standaloneConsole;
    }

    public boolean isServerMode() {
        return this.currentConsole == this.serverConsole;
    }

    public boolean isClientMode() {
        return this.currentConsole == this.clientConsole;
    }

    public void morphToStandaloneMode() {
        Cartridge lastCartridge;
        if (this.isStandaloneMode()) {
            return;
        }
        this.powerOff();
        Cartridge cartridge = lastCartridge = this.isClientMode() ? null : this.currentConsole.cartridgeSocket().inserted();
        if (this.standaloneConsole == null) {
            this.buildAndPlugStandaloneConsole();
        } else {
            this.plugConsole(this.standaloneConsole);
        }
        this.adjustPeripheralsToStandaloneOrServerOperation();
        if (lastCartridge != null) {
            this.currentConsole.cartridgeSocket().insert(lastCartridge, false);
        }
        this.powerOn();
    }

    public void morphToServerMode() {
        Cartridge lastCartridge;
        if (this.isServerMode()) {
            return;
        }
        this.powerOff();
        Cartridge cartridge = lastCartridge = this.isClientMode() ? null : this.currentConsole.cartridgeSocket().inserted();
        if (this.serverConsole == null) {
            this.buildAndPlugServerConsole();
        } else {
            this.plugConsole(this.serverConsole);
        }
        this.adjustPeripheralsToStandaloneOrServerOperation();
        if (lastCartridge != null) {
            this.currentConsole.cartridgeSocket().insert(lastCartridge, false);
        }
        this.powerOn();
    }

    public void morphToClientMode() {
        if (this.isClientMode()) {
            return;
        }
        this.powerOff();
        if (this.clientConsole == null) {
            this.buildAndPlugClientConsole();
        } else {
            this.plugConsole(this.clientConsole);
        }
        this.adjustPeripheralsToClientOperation();
        this.powerOn();
    }

    public void destroy() {
        this.powerOff();
        if (this.standaloneConsole != null) {
            this.standaloneConsole.destroy();
        }
        if (this.serverConsole != null) {
            this.serverConsole.destroy();
        }
        if (this.clientConsole != null) {
            this.clientConsole.destroy();
        }
        this.screen.destroy();
        this.speaker.destroy();
        currentRoom = null;
    }

    protected void buildPeripherals() {
        if (this.screen != null) {
            throw new IllegalStateException();
        }
        this.screen = this.buildScreenPeripheral();
        this.speaker = new Speaker();
        this.controls = new AWTConsoleControls(this.screen.monitor());
        this.controls.addInputComponents(this.screen.controlsInputComponents());
        this.stateMedia = new FileSaveStateMedia();
    }

    protected Screen buildScreenPeripheral() {
        return new DesktopScreenWindow();
    }

    private void plugConsole(Console console) {
        if (this.currentConsole == console) {
            return;
        }
        this.currentConsole = console;
        this.screen.connect(this.currentConsole.videoOutput(), this.currentConsole.controlsSocket(), this.currentConsole.cartridgeSocket());
        this.speaker.connect(this.currentConsole.audioOutput());
        this.controls.connect(this.currentConsole.controlsSocket());
        this.stateMedia.connect(this.currentConsole.saveStateSocket());
    }

    private void insertCartridgeProvidedIfNoneInserted() {
        if (this.currentConsole.cartridgeSocket().inserted() != null) {
            return;
        }
        this.loadCartridgeProvided();
        if (this.cartridgeProvided != null) {
            this.currentConsole.cartridgeSocket().insert(this.cartridgeProvided, false);
        }
    }

    private void loadCartridgeProvided() {
        if (this.triedToLoadCartridgeProvided) {
            return;
        }
        this.triedToLoadCartridgeProvided = true;
        if (this.isClientMode() || Parameters.mainArg == null) {
            return;
        }
        this.cartridgeProvided = ROMLoader.load(Parameters.mainArg);
        if (this.cartridgeProvided == null) {
            Terminator.terminate();
        }
    }

    private Console buildAndPlugStandaloneConsole() {
        if (this.standaloneConsole != null) {
            throw new IllegalStateException();
        }
        this.standaloneConsole = new Console();
        this.plugConsole(this.standaloneConsole);
        return this.standaloneConsole;
    }

    private ServerConsole buildAndPlugServerConsole() {
        if (this.serverConsole != null) {
            throw new IllegalStateException();
        }
        RemoteTransmitter remoteTransmitter = new RemoteTransmitter();
        this.serverConsole = new ServerConsole(remoteTransmitter);
        this.plugConsole(this.serverConsole);
        return this.serverConsole;
    }

    private ClientConsole buildAndPlugClientConsole() {
        RemoteReceiver remoteReceiver = new RemoteReceiver();
        this.clientConsole = new ClientConsole(remoteReceiver);
        this.plugConsole(this.clientConsole);
        return this.clientConsole;
    }

    public static Room currentRoom() {
        return currentRoom;
    }

    public static Room buildStandaloneRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new Room();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToStandaloneOrServerOperation();
        currentRoom.buildAndPlugStandaloneConsole();
        return currentRoom;
    }

    public static Room buildServerRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new Room();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToStandaloneOrServerOperation();
        currentRoom.buildAndPlugServerConsole();
        return currentRoom;
    }

    public static Room buildClientRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new Room();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToClientOperation();
        currentRoom.buildAndPlugClientConsole();
        return currentRoom;
    }

    public static Room buildAppletStandaloneRoom() {
        if (currentRoom != null) {
            throw new IllegalStateException("Room already built");
        }
        currentRoom = new AppletRoom();
        currentRoom.buildPeripherals();
        currentRoom.adjustPeripheralsToStandaloneOrServerOperation();
        currentRoom.buildAndPlugStandaloneConsole();
        return currentRoom;
    }

    private void adjustPeripheralsToStandaloneOrServerOperation() {
        currentRoom.controls().p1ControlsMode(false);
        currentRoom.screen().monitor().setCartridgeChangeEnabled(Parameters.SCREEN_CARTRIDGE_CHANGE);
    }

    private void adjustPeripheralsToClientOperation() {
        currentRoom.controls().p1ControlsMode(true);
        currentRoom.screen().monitor().setCartridgeChangeEnabled(false);
    }

    public static void openCurrentRoomSettings() {
        if (settingsDialog == null) {
            settingsDialog = new SettingsDialog(currentRoom);
        }
        settingsDialog.setVisible(true);
    }
}

