/*
 * Decompiled with CFR 0.152.
 */
package pc.room.settings;

import atari.network.ConnectionStatusListener;
import atari.network.RemoteReceiver;
import atari.network.RemoteTransmitter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import parameters.Parameters;
import pc.room.Room;
import pc.room.settings.KeyNames;

public class SettingsDialog
extends JDialog
implements ConnectionStatusListener {
    private final Room room;
    private final JPanel contentPanel = new JPanel();
    private JPanel controlsPanel;
    private JTextField keyP0Up;
    private JTextField keyP0Down;
    private JTextField keyP0Left;
    private JTextField keyP0Right;
    private JTextField keyP0Button;
    private JTextField keyP0Button2;
    private JTextField keyP1Up;
    private JTextField keyP1Down;
    private JTextField keyP1Left;
    private JTextField keyP1Right;
    private JTextField keyP1Button;
    private JTextField keyP1Button2;
    private List<JTextField> keyFieldsList;
    private int newKEY_P0_UP;
    private int newKEY_P0_DOWN;
    private int newKEY_P0_LEFT;
    private int newKEY_P0_RIGHT;
    private int newKEY_P0_BUTTON;
    private int newKEY_P0_BUTTON2;
    private int newKEY_P1_UP;
    private int newKEY_P1_DOWN;
    private int newKEY_P1_LEFT;
    private int newKEY_P1_RIGHT;
    private int newKEY_P1_BUTTON;
    private int newKEY_P1_BUTTON2;
    private boolean buildFinished = false;
    private static final long serialVersionUID = 1L;
    private JTextField clientServerAddressTf;
    private JTextField serverPortTf;
    private JButton serverStartB;
    private JButton clientConnectB;
    private JLabel modeL;
    private JTabbedPane mainTabbedPane;
    private JButton defaultsB;
    private JButton okB;
    private JButton cancelB;
    private JLabel standaloneConsoleL;
    private JLabel serverConsoleL;
    private JLabel clientConsoleL;
    private JLabel networkL;

    public static void main(String[] args) {
        try {
            SettingsDialog dialog = new SettingsDialog(null);
            dialog.setDefaultCloseOperation(2);
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SettingsDialog(Room room) {
        this.room = room;
        this.buildGUI();
        this.setEscActionListener();
        this.buildKeyFieldsList();
        this.setControlsKeyListener();
        this.setMultiplayerDefaults();
        this.mainTabbedPane.setSelectedIndex(3);
        this.mainTabbedPane.setEnabledAt(0, Parameters.MULTIPLAYER_UI);
    }

    @Override
    public void connectionStatusChanged() {
        if (this.isVisible()) {
            this.refreshMultiplayerImages();
        }
    }

    @Override
    public void setVisible(boolean state) {
        this.setupConnectionStatulsListeners();
        this.initNewKeys();
        this.refreshContols();
        this.refreshMultiplayer();
        this.mainTabbedPaneChanged();
        super.setVisible(state);
    }

    private void refreshContols() {
        this.keyP0Up.setText(KeyNames.get(this.newKEY_P0_UP));
        this.keyP0Down.setText(KeyNames.get(this.newKEY_P0_DOWN));
        this.keyP0Left.setText(KeyNames.get(this.newKEY_P0_LEFT));
        this.keyP0Right.setText(KeyNames.get(this.newKEY_P0_RIGHT));
        this.keyP0Button.setText(KeyNames.get(this.newKEY_P0_BUTTON));
        this.keyP0Button2.setText(KeyNames.get(this.newKEY_P0_BUTTON2));
        this.keyP1Up.setText(KeyNames.get(this.newKEY_P1_UP));
        this.keyP1Down.setText(KeyNames.get(this.newKEY_P1_DOWN));
        this.keyP1Left.setText(KeyNames.get(this.newKEY_P1_LEFT));
        this.keyP1Right.setText(KeyNames.get(this.newKEY_P1_RIGHT));
        this.keyP1Button.setText(KeyNames.get(this.newKEY_P1_BUTTON));
        this.keyP1Button2.setText(KeyNames.get(this.newKEY_P1_BUTTON2));
        for (JTextField field : this.keyFieldsList) {
            field.setBackground(field.getText().trim().isEmpty() ? Color.YELLOW : Color.WHITE);
        }
        this.defaultsB.setVisible(true);
        this.okB.setVisible(true);
        this.cancelB.setText("Cancel");
    }

    private void refreshMultiplayer() {
        if (this.room == null) {
            this.modeL.setText("STANDALONE MODE");
            this.modeL.setForeground(new Color(0, 127, 0));
            this.serverStartB.setText("");
            this.serverStartB.setEnabled(false);
            this.serverPortTf.setEditable(false);
            this.serverPortTf.setText("");
            this.clientConnectB.setText("");
            this.clientConnectB.setEnabled(false);
            this.clientServerAddressTf.setEditable(false);
            this.standaloneConsoleL.setVisible(true);
            this.networkL.setVisible(false);
            this.serverConsoleL.setVisible(false);
            this.clientConsoleL.setVisible(false);
            this.defaultsB.setVisible(false);
            this.okB.setVisible(false);
            this.cancelB.setText("Close");
            return;
        }
        boolean serverMode = this.room.isServerMode();
        boolean clientMode = this.room.isClientMode();
        this.modeL.setText(serverMode ? "P1 SERVER MODE" : (clientMode ? "P2 CLIENT MODE" : "STANDALONE MODE"));
        this.modeL.setForeground(serverMode ? Color.BLUE : (clientMode ? Color.RED : new Color(0, 127, 0)));
        this.serverStartB.setText(serverMode ? "STOP" : "START");
        this.serverStartB.setEnabled(!clientMode);
        this.serverPortTf.setEditable(!serverMode && !clientMode);
        this.clientConnectB.setText(clientMode ? "DISCONNECT" : "CONNECT");
        this.clientConnectB.setEnabled(!serverMode);
        this.clientServerAddressTf.setEditable(!serverMode && !clientMode);
        this.refreshMultiplayerImages();
        this.defaultsB.setVisible(!serverMode && !clientMode);
        this.okB.setVisible(false);
        this.cancelB.setText("Close");
    }

    private void refreshMultiplayerImages() {
        boolean serverMode = this.room.isServerMode();
        boolean clientMode = this.room.isClientMode();
        boolean clientConnected = serverMode && this.room.serverCurrentConsole().remoteTransmitter().isClientConnected();
        boolean connectedToServer = clientMode && this.room.clientCurrentConsole().remoteReceiver().isConnected();
        this.standaloneConsoleL.setVisible(!serverMode && !clientMode);
        this.networkL.setVisible(serverMode || clientMode);
        this.serverConsoleL.setVisible(serverMode || connectedToServer);
        this.clientConsoleL.setVisible(clientMode || clientConnected);
    }

    private void setControlsKeyListener() {
        KeyAdapter lis = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SettingsDialog.this.setControlKey(e);
            }
        };
        for (JTextField field : this.keyFieldsList) {
            field.addKeyListener(lis);
        }
    }

    private void setControlKey(KeyEvent e) {
        int code = e.getKeyCode();
        if (!KeyNames.hasName(code)) {
            return;
        }
        this.unsetControlKey(code);
        Object comp = e.getSource();
        if (comp == this.keyP0Up) {
            this.newKEY_P0_UP = code;
        }
        if (comp == this.keyP0Down) {
            this.newKEY_P0_DOWN = code;
        }
        if (comp == this.keyP0Left) {
            this.newKEY_P0_LEFT = code;
        }
        if (comp == this.keyP0Right) {
            this.newKEY_P0_RIGHT = code;
        }
        if (comp == this.keyP0Button) {
            this.newKEY_P0_BUTTON = code;
        }
        if (comp == this.keyP0Button2) {
            this.newKEY_P0_BUTTON2 = code;
        }
        if (comp == this.keyP1Up) {
            this.newKEY_P1_UP = code;
        }
        if (comp == this.keyP1Down) {
            this.newKEY_P1_DOWN = code;
        }
        if (comp == this.keyP1Left) {
            this.newKEY_P1_LEFT = code;
        }
        if (comp == this.keyP1Right) {
            this.newKEY_P1_RIGHT = code;
        }
        if (comp == this.keyP1Button) {
            this.newKEY_P1_BUTTON = code;
        }
        if (comp == this.keyP1Button2) {
            this.newKEY_P1_BUTTON2 = code;
        }
        this.refreshContols();
    }

    private void unsetControlKey(int code) {
        if (this.newKEY_P0_UP == code) {
            this.newKEY_P0_UP = -1;
        }
        if (this.newKEY_P0_DOWN == code) {
            this.newKEY_P0_DOWN = -1;
        }
        if (this.newKEY_P0_LEFT == code) {
            this.newKEY_P0_LEFT = -1;
        }
        if (this.newKEY_P0_RIGHT == code) {
            this.newKEY_P0_RIGHT = -1;
        }
        if (this.newKEY_P0_BUTTON == code) {
            this.newKEY_P0_BUTTON = -1;
        }
        if (this.newKEY_P0_BUTTON2 == code) {
            this.newKEY_P0_BUTTON2 = -1;
        }
        if (this.newKEY_P1_UP == code) {
            this.newKEY_P1_UP = -1;
        }
        if (this.newKEY_P1_DOWN == code) {
            this.newKEY_P1_DOWN = -1;
        }
        if (this.newKEY_P1_LEFT == code) {
            this.newKEY_P1_LEFT = -1;
        }
        if (this.newKEY_P1_RIGHT == code) {
            this.newKEY_P1_RIGHT = -1;
        }
        if (this.newKEY_P1_BUTTON == code) {
            this.newKEY_P1_BUTTON = -1;
        }
        if (this.newKEY_P1_BUTTON2 == code) {
            this.newKEY_P1_BUTTON2 = -1;
        }
    }

    private void acceptKeyChanges() {
        Parameters.KEY_P0_UP = this.newKEY_P0_UP;
        Parameters.KEY_P0_DOWN = this.newKEY_P0_DOWN;
        Parameters.KEY_P0_LEFT = this.newKEY_P0_LEFT;
        Parameters.KEY_P0_RIGHT = this.newKEY_P0_RIGHT;
        Parameters.KEY_P0_BUTTON = this.newKEY_P0_BUTTON;
        Parameters.KEY_P0_BUTTON2 = this.newKEY_P0_BUTTON2;
        Parameters.KEY_P1_UP = this.newKEY_P1_UP;
        Parameters.KEY_P1_DOWN = this.newKEY_P1_DOWN;
        Parameters.KEY_P1_LEFT = this.newKEY_P1_LEFT;
        Parameters.KEY_P1_RIGHT = this.newKEY_P1_RIGHT;
        Parameters.KEY_P1_BUTTON = this.newKEY_P1_BUTTON;
        Parameters.KEY_P1_BUTTON2 = this.newKEY_P1_BUTTON2;
        Parameters.savePreferences();
        this.room.controls().initJoystickKeys();
    }

    private void buildKeyFieldsList() {
        this.keyFieldsList = Arrays.asList(this.keyP0Up, this.keyP0Down, this.keyP0Left, this.keyP0Right, this.keyP0Button, this.keyP0Button2, this.keyP1Up, this.keyP1Down, this.keyP1Left, this.keyP1Right, this.keyP1Button, this.keyP1Button2);
    }

    private void initNewKeys() {
        this.newKEY_P0_UP = Parameters.KEY_P0_UP;
        this.newKEY_P0_DOWN = Parameters.KEY_P0_DOWN;
        this.newKEY_P0_LEFT = Parameters.KEY_P0_LEFT;
        this.newKEY_P0_RIGHT = Parameters.KEY_P0_RIGHT;
        this.newKEY_P0_BUTTON = Parameters.KEY_P0_BUTTON;
        this.newKEY_P0_BUTTON2 = Parameters.KEY_P0_BUTTON2;
        this.newKEY_P1_UP = Parameters.KEY_P1_UP;
        this.newKEY_P1_DOWN = Parameters.KEY_P1_DOWN;
        this.newKEY_P1_LEFT = Parameters.KEY_P1_LEFT;
        this.newKEY_P1_RIGHT = Parameters.KEY_P1_RIGHT;
        this.newKEY_P1_BUTTON = Parameters.KEY_P1_BUTTON;
        this.newKEY_P1_BUTTON2 = Parameters.KEY_P1_BUTTON2;
    }

    private void setControlsKeysDefaults() {
        this.newKEY_P0_UP = 38;
        this.newKEY_P0_DOWN = 40;
        this.newKEY_P0_LEFT = 37;
        this.newKEY_P0_RIGHT = 39;
        this.newKEY_P0_BUTTON = 32;
        this.newKEY_P0_BUTTON2 = 127;
        this.newKEY_P1_UP = 84;
        this.newKEY_P1_DOWN = 71;
        this.newKEY_P1_LEFT = 70;
        this.newKEY_P1_RIGHT = 72;
        this.newKEY_P1_BUTTON = 65;
        this.newKEY_P1_BUTTON2 = 46;
        this.refreshContols();
    }

    private void setMultiplayerDefaults() {
        this.serverPortTf.setText(String.valueOf(Parameters.SERVER_SERVICE_PORT));
    }

    private void setupConnectionStatulsListeners() {
        if (this.room == null) {
            return;
        }
        if (this.room.isServerMode()) {
            this.room.serverCurrentConsole().remoteTransmitter().addConnectionStatusListener(this);
        }
        if (this.room.isClientMode()) {
            this.room.clientCurrentConsole().remoteReceiver().addConnectionStatusListener(this);
        }
    }

    private void setEscActionListener() {
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.cancelAction();
            }
        };
        this.getRootPane().getInputMap(2).put(escKeyStroke, "ESC");
        this.getRootPane().getActionMap().put("ESC", escapeAction);
    }

    private void mainTabbedPaneChanged() {
        if (!this.buildFinished) {
            return;
        }
        switch (this.mainTabbedPane.getSelectedIndex()) {
            case 0: {
                this.refreshMultiplayer();
                break;
            }
            case 1: {
                this.refreshContols();
                break;
            }
            default: {
                this.defaultsB.setVisible(false);
                this.okB.setVisible(false);
                this.cancelB.setText("Close");
            }
        }
    }

    private void officialWebPageAction() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        try {
            Desktop desktop = Desktop.getDesktop();
            if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                return;
            }
            this.setVisible(false);
            desktop.browse(new URI(Parameters.OFFICIAL_WEBSITE));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void serverStartAction() {
        if (!this.room.isServerMode()) {
            this.room.morphToServerMode();
            this.setupConnectionStatulsListeners();
            try {
                RemoteTransmitter transmitter = this.room.serverCurrentConsole().remoteTransmitter();
                String portString = this.serverPortTf.getText().trim();
                try {
                    if (portString.isEmpty()) {
                        transmitter.start();
                    } else {
                        transmitter.start(Integer.valueOf(portString));
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid port number: " + portString);
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Could not start Server:\n" + ex, "javatari P1 Server", 0);
                this.room.morphToStandaloneMode();
            }
        } else {
            try {
                RemoteTransmitter transmitter = this.room.serverCurrentConsole().remoteTransmitter();
                transmitter.stop();
                this.room.morphToStandaloneMode();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Error stopping Server:\n" + ex, "javatari P1 Server", 0);
            }
        }
        this.refreshMultiplayer();
    }

    private void clientConnectAction() {
        if (!this.room.isClientMode()) {
            this.room.morphToClientMode();
            this.setupConnectionStatulsListeners();
            String serverAddress = "";
            try {
                RemoteReceiver receiver = this.room.clientCurrentConsole().remoteReceiver();
                serverAddress = this.clientServerAddressTf.getText().trim();
                receiver.connect(serverAddress);
                this.cancelAction();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Connection failed: " + serverAddress + "\n" + ex, "javatari P2 Client", 0);
                this.room.morphToStandaloneMode();
            }
        } else {
            try {
                RemoteReceiver receiver = this.room.clientCurrentConsole().remoteReceiver();
                receiver.disconnect();
                this.room.morphToStandaloneMode();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Error disconnecting from Server:\n" + ex, "javatari P2 Client", 0);
            }
        }
        this.refreshMultiplayer();
    }

    private void defaultsAction() {
        switch (this.mainTabbedPane.getSelectedIndex()) {
            case 0: {
                this.setMultiplayerDefaults();
                break;
            }
            case 1: {
                this.setControlsKeysDefaults();
            }
        }
    }

    private void okAction() {
        this.acceptKeyChanges();
        this.setVisible(false);
    }

    private void cancelAction() {
        this.setVisible(false);
    }

    private void buildGUI() {
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(SettingsDialog.class.getResource("/pc/screen/images/Favicon.png")));
        this.setTitle("javatari");
        this.setResizable(false);
        this.setSize(491, 324);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        this.mainTabbedPane = new JTabbedPane(1);
        this.mainTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SettingsDialog.this.mainTabbedPaneChanged();
            }
        });
        this.mainTabbedPane.setFont(new Font("Arial", 0, 13));
        this.mainTabbedPane.setBackground(UIManager.getColor("TabbedPane.background"));
        this.contentPanel.add((Component)this.mainTabbedPane, "Center");
        JPanel panel_1 = new JPanel();
        this.mainTabbedPane.addTab("Multiplayer", null, panel_1, null);
        panel_1.setLayout(null);
        this.clientConsoleL = new JLabel("");
        this.clientConsoleL.setIcon(new ImageIcon(SettingsDialog.class.getResource("/pc/room/settings/images/ServerClientConsole.png")));
        this.clientConsoleL.setBounds(316, 124, 139, 94);
        panel_1.add(this.clientConsoleL);
        this.serverConsoleL = new JLabel("");
        this.serverConsoleL.setIcon(new ImageIcon(SettingsDialog.class.getResource("/pc/room/settings/images/ServerClientConsole.png")));
        this.serverConsoleL.setBounds(12, 124, 139, 94);
        panel_1.add(this.serverConsoleL);
        this.networkL = new JLabel("");
        this.networkL.setIcon(new ImageIcon(SettingsDialog.class.getResource("/pc/room/settings/images/Network.png")));
        this.networkL.setBounds(116, 73, 237, 98);
        panel_1.add(this.networkL);
        JLabel lblNewLabel_1 = new JLabel("P1 Server");
        lblNewLabel_1.setFont(new Font("Arial", 1, 16));
        lblNewLabel_1.setHorizontalAlignment(0);
        lblNewLabel_1.setBounds(24, 13, 100, 20);
        panel_1.add(lblNewLabel_1);
        this.serverStartB = new JButton("START");
        this.serverStartB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.serverStartAction();
            }
        });
        this.serverStartB.setBounds(20, 36, 108, 26);
        panel_1.add(this.serverStartB);
        this.clientConnectB = new JButton("CONNECT");
        this.clientConnectB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.clientConnectAction();
            }
        });
        this.clientConnectB.setBounds(341, 36, 108, 26);
        panel_1.add(this.clientConnectB);
        this.clientServerAddressTf = new JTextField();
        this.clientServerAddressTf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.clientConnectAction();
            }
        });
        this.clientServerAddressTf.setFont(new Font("Arial", 0, 12));
        this.clientServerAddressTf.setBounds(337, 87, 117, 22);
        panel_1.add(this.clientServerAddressTf);
        this.clientServerAddressTf.setColumns(10);
        JLabel lblServerAddressport = new JLabel("Server address [:port]");
        lblServerAddressport.setHorizontalAlignment(0);
        lblServerAddressport.setFont(new Font("Arial", 0, 12));
        lblServerAddressport.setBounds(337, 70, 117, 15);
        panel_1.add(lblServerAddressport);
        this.serverPortTf = new JTextField();
        this.serverPortTf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.serverStartAction();
            }
        });
        this.serverPortTf.setFont(new Font("Arial", 0, 12));
        this.serverPortTf.setHorizontalAlignment(4);
        this.serverPortTf.setColumns(10);
        this.serverPortTf.setBounds(43, 87, 62, 22);
        panel_1.add(this.serverPortTf);
        JLabel lblPort = new JLabel("Server port");
        lblPort.setHorizontalAlignment(0);
        lblPort.setFont(new Font("Arial", 0, 12));
        lblPort.setBounds(43, 70, 62, 15);
        panel_1.add(lblPort);
        JLabel lblPClient = new JLabel("P2 Client");
        lblPClient.setHorizontalAlignment(0);
        lblPClient.setFont(new Font("Arial", 1, 16));
        lblPClient.setBounds(345, 13, 100, 20);
        panel_1.add(lblPClient);
        this.modeL = new JLabel("P1 SERVER MODE");
        this.modeL.setBorder(new EtchedBorder(1, null, null));
        this.modeL.setFont(new Font("Arial", 1, 13));
        this.modeL.setOpaque(true);
        this.modeL.setHorizontalAlignment(0);
        this.modeL.setBounds(160, 36, 149, 26);
        panel_1.add(this.modeL);
        this.standaloneConsoleL = new JLabel("");
        this.standaloneConsoleL.setIcon(new ImageIcon(SettingsDialog.class.getResource("/pc/room/settings/images/StandaloneConsole.png")));
        this.standaloneConsoleL.setBounds(118, 74, 202, 146);
        panel_1.add(this.standaloneConsoleL);
        this.controlsPanel = new JPanel();
        this.mainTabbedPane.addTab("Controls", null, this.controlsPanel, null);
        this.controlsPanel.setLayout(null);
        JLabel lblNewLabel = new JLabel("");
        lblNewLabel.setIcon(new ImageIcon(SettingsDialog.class.getResource("/pc/room/settings/images/Joystick.png")));
        lblNewLabel.setBounds(64, 76, 75, 90);
        this.controlsPanel.add(lblNewLabel);
        this.keyP0Up = new JTextField();
        this.keyP0Up.setBackground(Color.WHITE);
        this.keyP0Up.setEditable(false);
        this.keyP0Up.setFont(new Font("Arial", 0, 11));
        this.keyP0Up.setHorizontalAlignment(0);
        this.keyP0Up.setText("UP");
        this.keyP0Up.setBounds(81, 54, 40, 20);
        this.controlsPanel.add(this.keyP0Up);
        this.keyP0Up.setColumns(10);
        this.keyP0Right = new JTextField();
        this.keyP0Right.setBackground(Color.WHITE);
        this.keyP0Right.setEditable(false);
        this.keyP0Right.setFont(new Font("Arial", 0, 11));
        this.keyP0Right.setText("RIGHT");
        this.keyP0Right.setHorizontalAlignment(0);
        this.keyP0Right.setColumns(10);
        this.keyP0Right.setBounds(138, 115, 40, 20);
        this.controlsPanel.add(this.keyP0Right);
        this.keyP0Left = new JTextField();
        this.keyP0Left.setBackground(Color.WHITE);
        this.keyP0Left.setEditable(false);
        this.keyP0Left.setFont(new Font("Arial", 0, 11));
        this.keyP0Left.setText("LEFT");
        this.keyP0Left.setHorizontalAlignment(0);
        this.keyP0Left.setColumns(10);
        this.keyP0Left.setBounds(23, 115, 40, 20);
        this.controlsPanel.add(this.keyP0Left);
        this.keyP0Down = new JTextField();
        this.keyP0Down.setBackground(Color.WHITE);
        this.keyP0Down.setEditable(false);
        this.keyP0Down.setFont(new Font("Arial", 0, 11));
        this.keyP0Down.setText("DOWN");
        this.keyP0Down.setHorizontalAlignment(0);
        this.keyP0Down.setColumns(10);
        this.keyP0Down.setBounds(81, 168, 40, 20);
        this.controlsPanel.add(this.keyP0Down);
        JLabel lblRight = new JLabel("Right");
        lblRight.setFont(new Font("Arial", 0, 12));
        lblRight.setHorizontalAlignment(0);
        lblRight.setBounds(139, 99, 38, 14);
        this.controlsPanel.add(lblRight);
        JLabel lblLeft = new JLabel("Left");
        lblLeft.setFont(new Font("Arial", 0, 12));
        lblLeft.setHorizontalAlignment(0);
        lblLeft.setBounds(25, 99, 36, 14);
        this.controlsPanel.add(lblLeft);
        JLabel lblDown = new JLabel("Down");
        lblDown.setFont(new Font("Arial", 0, 12));
        lblDown.setHorizontalAlignment(0);
        lblDown.setBounds(82, 189, 38, 14);
        this.controlsPanel.add(lblDown);
        JLabel lblUp = new JLabel("Up");
        lblUp.setFont(new Font("Arial", 0, 12));
        lblUp.setHorizontalAlignment(0);
        lblUp.setBounds(82, 38, 38, 14);
        this.controlsPanel.add(lblUp);
        this.keyP0Button = new JTextField();
        this.keyP0Button.setBackground(Color.WHITE);
        this.keyP0Button.setEditable(false);
        this.keyP0Button.setFont(new Font("Arial", 0, 11));
        this.keyP0Button.setText("SPC");
        this.keyP0Button.setHorizontalAlignment(0);
        this.keyP0Button.setColumns(10);
        this.keyP0Button.setBounds(23, 66, 40, 20);
        this.controlsPanel.add(this.keyP0Button);
        JLabel lblFire = new JLabel("Fire 1");
        lblFire.setFont(new Font("Arial", 0, 12));
        lblFire.setHorizontalAlignment(0);
        lblFire.setBounds(24, 50, 38, 14);
        this.controlsPanel.add(lblFire);
        JLabel lblPlayer = new JLabel("Player 1");
        lblPlayer.setFont(new Font("Arial", 1, 16));
        lblPlayer.setHorizontalAlignment(0);
        lblPlayer.setBounds(64, 13, 74, 20);
        this.controlsPanel.add(lblPlayer);
        JLabel lblFire_1 = new JLabel("Fire 2");
        lblFire_1.setFont(new Font("Arial", 0, 12));
        lblFire_1.setHorizontalAlignment(0);
        lblFire_1.setBounds(139, 50, 38, 14);
        this.controlsPanel.add(lblFire_1);
        this.keyP0Button2 = new JTextField();
        this.keyP0Button2.setBackground(Color.WHITE);
        this.keyP0Button2.setEditable(false);
        this.keyP0Button2.setFont(new Font("Arial", 0, 11));
        this.keyP0Button2.setText("DEL");
        this.keyP0Button2.setHorizontalAlignment(0);
        this.keyP0Button2.setColumns(10);
        this.keyP0Button2.setBounds(138, 66, 40, 20);
        this.controlsPanel.add(this.keyP0Button2);
        JTextPane txtpnAltJ_1 = new JTextPane();
        txtpnAltJ_1.setOpaque(false);
        txtpnAltJ_1.setEditable(false);
        txtpnAltJ_1.setFont(new Font("Arial", 0, 12));
        txtpnAltJ_1.setText("ALT + J : Swap P1<>P2\r\nALT + L : Toggle Paddles");
        txtpnAltJ_1.setBounds(163, 171, 145, 36);
        this.controlsPanel.add(txtpnAltJ_1);
        JLabel label = new JLabel("");
        label.setIcon(new ImageIcon(SettingsDialog.class.getResource("/pc/room/settings/images/Joystick.png")));
        label.setBounds(334, 76, 75, 90);
        this.controlsPanel.add(label);
        this.keyP1Up = new JTextField();
        this.keyP1Up.setText("T");
        this.keyP1Up.setHorizontalAlignment(0);
        this.keyP1Up.setFont(new Font("Arial", 0, 11));
        this.keyP1Up.setEditable(false);
        this.keyP1Up.setColumns(10);
        this.keyP1Up.setBackground(Color.WHITE);
        this.keyP1Up.setBounds(351, 54, 40, 20);
        this.controlsPanel.add(this.keyP1Up);
        this.keyP1Right = new JTextField();
        this.keyP1Right.setText("H");
        this.keyP1Right.setHorizontalAlignment(0);
        this.keyP1Right.setFont(new Font("Arial", 0, 11));
        this.keyP1Right.setEditable(false);
        this.keyP1Right.setColumns(10);
        this.keyP1Right.setBackground(Color.WHITE);
        this.keyP1Right.setBounds(408, 115, 40, 20);
        this.controlsPanel.add(this.keyP1Right);
        this.keyP1Left = new JTextField();
        this.keyP1Left.setText("F");
        this.keyP1Left.setHorizontalAlignment(0);
        this.keyP1Left.setFont(new Font("Arial", 0, 11));
        this.keyP1Left.setEditable(false);
        this.keyP1Left.setColumns(10);
        this.keyP1Left.setBackground(Color.WHITE);
        this.keyP1Left.setBounds(293, 115, 40, 20);
        this.controlsPanel.add(this.keyP1Left);
        this.keyP1Down = new JTextField();
        this.keyP1Down.setText("G");
        this.keyP1Down.setHorizontalAlignment(0);
        this.keyP1Down.setFont(new Font("Arial", 0, 11));
        this.keyP1Down.setEditable(false);
        this.keyP1Down.setColumns(10);
        this.keyP1Down.setBackground(Color.WHITE);
        this.keyP1Down.setBounds(351, 168, 40, 20);
        this.controlsPanel.add(this.keyP1Down);
        JLabel label_1 = new JLabel("Right");
        label_1.setHorizontalAlignment(0);
        label_1.setFont(new Font("Arial", 0, 12));
        label_1.setBounds(409, 99, 38, 14);
        this.controlsPanel.add(label_1);
        JLabel label_2 = new JLabel("Left");
        label_2.setHorizontalAlignment(0);
        label_2.setFont(new Font("Arial", 0, 12));
        label_2.setBounds(295, 99, 36, 14);
        this.controlsPanel.add(label_2);
        JLabel label_3 = new JLabel("Down");
        label_3.setHorizontalAlignment(0);
        label_3.setFont(new Font("Arial", 0, 12));
        label_3.setBounds(352, 189, 38, 14);
        this.controlsPanel.add(label_3);
        JLabel label_4 = new JLabel("Up");
        label_4.setHorizontalAlignment(0);
        label_4.setFont(new Font("Arial", 0, 12));
        label_4.setBounds(352, 38, 38, 14);
        this.controlsPanel.add(label_4);
        this.keyP1Button = new JTextField();
        this.keyP1Button.setText("A");
        this.keyP1Button.setHorizontalAlignment(0);
        this.keyP1Button.setFont(new Font("Arial", 0, 11));
        this.keyP1Button.setEditable(false);
        this.keyP1Button.setColumns(10);
        this.keyP1Button.setBackground(Color.WHITE);
        this.keyP1Button.setBounds(293, 66, 40, 20);
        this.controlsPanel.add(this.keyP1Button);
        JLabel label_5 = new JLabel("Fire 1");
        label_5.setHorizontalAlignment(0);
        label_5.setFont(new Font("Arial", 0, 12));
        label_5.setBounds(294, 50, 38, 14);
        this.controlsPanel.add(label_5);
        JLabel lblPlayer_1 = new JLabel("Player 2");
        lblPlayer_1.setHorizontalAlignment(0);
        lblPlayer_1.setFont(new Font("Arial", 1, 16));
        lblPlayer_1.setBounds(334, 13, 74, 20);
        this.controlsPanel.add(lblPlayer_1);
        JLabel label_7 = new JLabel("Fire 2");
        label_7.setHorizontalAlignment(0);
        label_7.setFont(new Font("Arial", 0, 12));
        label_7.setBounds(409, 50, 38, 14);
        this.controlsPanel.add(label_7);
        this.keyP1Button2 = new JTextField();
        this.keyP1Button2.setHorizontalAlignment(0);
        this.keyP1Button2.setFont(new Font("Arial", 0, 11));
        this.keyP1Button2.setEditable(false);
        this.keyP1Button2.setColumns(10);
        this.keyP1Button2.setBackground(Color.WHITE);
        this.keyP1Button2.setBounds(408, 66, 40, 20);
        this.controlsPanel.add(this.keyP1Button2);
        JLabel lbldoubleclickToChange = new JLabel("(double-click to change)");
        lbldoubleclickToChange.setToolTipText("");
        lbldoubleclickToChange.setHorizontalAlignment(0);
        lbldoubleclickToChange.setFont(new Font("Arial", 0, 12));
        lbldoubleclickToChange.setBounds(169, 16, 133, 15);
        this.controlsPanel.add(lbldoubleclickToChange);
        JPanel panel = new JPanel();
        this.mainTabbedPane.addTab("Help", null, panel, null);
        panel.setLayout(null);
        JTextPane txtpnAltJ = new JTextPane();
        txtpnAltJ.setOpaque(false);
        txtpnAltJ.setEditable(false);
        txtpnAltJ.setFont(new Font("Arial", 0, 12));
        txtpnAltJ.setBounds(18, 10, 78, 203);
        panel.add(txtpnAltJ);
        txtpnAltJ.setText("CTR + 1-0 :\r\nALT + 1-0 :\r\n\r\nALT + ENT :\r\nALT + V :\r\nALT + R :\r\nALT + Q :\r\n\r\nALT + D :\r\nALT + C :\r\nALT + P :\r\nALT + F :\r\nTAB :");
        JTextPane txtpnFullscreenNtsc = new JTextPane();
        txtpnFullscreenNtsc.setOpaque(false);
        txtpnFullscreenNtsc.setEditable(false);
        txtpnFullscreenNtsc.setText("Save State\r\nLoad State\r\n\r\nFullscreen\r\nNTSC / PAL\r\nCRT Modes\r\nFilter\r\n\r\nDebug Modes\r\nCollisions\r\nPause\r\nNext Frame\r\nFast Speed");
        txtpnFullscreenNtsc.setFont(new Font("Arial", 0, 12));
        txtpnFullscreenNtsc.setBounds(95, 10, 92, 203);
        panel.add(txtpnFullscreenNtsc);
        JTextPane txtpnAltF = new JTextPane();
        txtpnAltF.setOpaque(false);
        txtpnAltF.setEditable(false);
        txtpnAltF.setText("ALT + F1 :\r\n\r\nALT + F5 :\r\nALT + F6 :\r\nF7 :\r\n");
        txtpnAltF.setFont(new Font("Arial", 0, 12));
        txtpnAltF.setBounds(218, 10, 71, 81);
        panel.add(txtpnAltF);
        JTextPane txtpnFryConsoleLoad = new JTextPane();
        txtpnFryConsoleLoad.setOpaque(false);
        txtpnFryConsoleLoad.setEditable(false);
        txtpnFryConsoleLoad.setText("Fry Console\r\n\r\nLoad Cartridge\r\nwith no Power Cycle\r\nRemove Cartridge");
        txtpnFryConsoleLoad.setFont(new Font("Arial", 0, 12));
        txtpnFryConsoleLoad.setBounds(287, 10, 127, 81);
        panel.add(txtpnFryConsoleLoad);
        JTextPane txtpnCtraltArrows = new JTextPane();
        txtpnCtraltArrows.setOpaque(false);
        txtpnCtraltArrows.setEditable(false);
        txtpnCtraltArrows.setText("CTR-ALT + Arrows :\r\nCTR-SHT + Arrows :\r\nALT-SHT + Arrows :\r\n\r\nBACKSPACE :\r\n");
        txtpnCtraltArrows.setFont(new Font("Arial", 0, 12));
        txtpnCtraltArrows.setBounds(218, 130, 121, 81);
        panel.add(txtpnCtraltArrows);
        JTextPane txtpnAlsoPossibleDo = new JTextPane();
        txtpnAlsoPossibleDo.setOpaque(false);
        txtpnAlsoPossibleDo.setEditable(false);
        txtpnAlsoPossibleDo.setText("Drag/Drop or Copy/Paste of files and URLs");
        txtpnAlsoPossibleDo.setFont(new Font("Arial", 0, 12));
        txtpnAlsoPossibleDo.setBounds(218, 100, 240, 21);
        panel.add(txtpnAlsoPossibleDo);
        JTextPane txtpnDisplayOriginDisplay = new JTextPane();
        txtpnDisplayOriginDisplay.setOpaque(false);
        txtpnDisplayOriginDisplay.setEditable(false);
        txtpnDisplayOriginDisplay.setText("Display Origin\r\nDisplay Size\r\nDisplay Scale\r\n\r\nDisplay Defaults");
        txtpnDisplayOriginDisplay.setFont(new Font("Arial", 0, 12));
        txtpnDisplayOriginDisplay.setBounds(343, 130, 100, 81);
        panel.add(txtpnDisplayOriginDisplay);
        JPanel panel_2 = new JPanel();
        panel_2.setCursor(Cursor.getPredefinedCursor(0));
        panel_2.setBackground(UIManager.getColor("Panel.background"));
        this.mainTabbedPane.addTab("About", null, panel_2, null);
        panel_2.setLayout(null);
        JLabel lblNewButton = new JLabel("");
        lblNewButton.setBounds(29, 23, 162, 158);
        panel_2.add(lblNewButton);
        lblNewButton.setIcon(new ImageIcon(SettingsDialog.class.getResource("/pc/room/settings/images/LogoAbout.png")));
        lblNewButton.setPreferredSize(new Dimension(200, 250));
        lblNewButton.setBorder(new BevelBorder(1, null, null, null, null));
        JLabel lblVerion = new JLabel("version 2.01");
        lblVerion.setHorizontalAlignment(0);
        lblVerion.setFont(new Font("Arial", 0, 13));
        lblVerion.setBounds(68, 187, 85, 14);
        panel_2.add(lblVerion);
        JLabel lblCreate = new JLabel("Paulo Augusto Peccin");
        lblCreate.setHorizontalAlignment(0);
        lblCreate.setFont(new Font("Arial", 0, 15));
        lblCreate.setBounds(256, 62, 143, 18);
        panel_2.add(lblCreate);
        JLabel lblCreated = new JLabel("created by");
        lblCreated.setHorizontalAlignment(0);
        lblCreated.setFont(new Font("Arial", 0, 13));
        lblCreated.setBounds(259, 39, 137, 21);
        panel_2.add(lblCreated);
        JLabel lblOfficialHomepage = new JLabel("official homepage:");
        lblOfficialHomepage.setHorizontalAlignment(0);
        lblOfficialHomepage.setFont(new Font("Arial", 0, 13));
        lblOfficialHomepage.setBounds(259, 125, 137, 21);
        panel_2.add(lblOfficialHomepage);
        JButton lblHttpjavatariotg = new JButton("http://javatari.org");
        lblHttpjavatariotg.setFocusPainted(false);
        lblHttpjavatariotg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.officialWebPageAction();
            }
        });
        lblHttpjavatariotg.setCursor(Cursor.getPredefinedCursor(12));
        lblHttpjavatariotg.setBorder(null);
        lblHttpjavatariotg.setContentAreaFilled(false);
        lblHttpjavatariotg.setBorderPainted(false);
        lblHttpjavatariotg.setHorizontalAlignment(0);
        lblHttpjavatariotg.setForeground(Color.BLUE);
        lblHttpjavatariotg.setFont(new Font("Arial", 0, 15));
        lblHttpjavatariotg.setBounds(274, 149, 107, 18);
        panel_2.add(lblHttpjavatariotg);
        JLabel lblppeccin = new JLabel("@ppeccin");
        lblppeccin.setHorizontalAlignment(0);
        lblppeccin.setFont(new Font("Arial", 0, 13));
        lblppeccin.setBounds(259, 82, 137, 19);
        panel_2.add(lblppeccin);
        JPanel buttonPane = new JPanel();
        this.getContentPane().add((Component)buttonPane, "South");
        buttonPane.setLayout(new BorderLayout(0, 0));
        JPanel panel2 = new JPanel();
        FlowLayout flowLayout = (FlowLayout)panel2.getLayout();
        flowLayout.setAlignment(0);
        buttonPane.add((Component)panel2, "West");
        this.defaultsB = new JButton("Defaults");
        this.defaultsB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.defaultsAction();
            }
        });
        panel2.add(this.defaultsB);
        JPanel panel_12 = new JPanel();
        buttonPane.add((Component)panel_12, "East");
        this.okB = new JButton("  OK  ");
        panel_12.add(this.okB);
        this.okB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.okAction();
            }
        });
        this.okB.setActionCommand("OK");
        this.cancelB = new JButton("Cancel");
        panel_12.add(this.cancelB);
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.cancelAction();
            }
        });
        this.cancelB.setActionCommand("Cancel");
        this.setLocationRelativeTo(null);
        this.buildFinished = true;
    }
}

