/*
 * Decompiled with CFR 0.152.
 */
package pc.screen;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import pc.screen.Monitor;

public class MonitorControls
implements KeyListener {
    private Monitor monitor;
    private final Map<Integer, Monitor.Control> keyCodeMap = new HashMap<Integer, Monitor.Control>();
    private final Map<Integer, Monitor.Control> keyShiftCodeMap = new HashMap<Integer, Monitor.Control>();
    private final Map<Integer, Monitor.Control> keyAltCodeMap = new HashMap<Integer, Monitor.Control>();
    private final Map<Integer, Monitor.Control> keyShiftControlCodeMap = new HashMap<Integer, Monitor.Control>();
    private final Map<Integer, Monitor.Control> keyShiftAltCodeMap = new HashMap<Integer, Monitor.Control>();
    private final Map<Integer, Monitor.Control> keyControlCodeMap = new HashMap<Integer, Monitor.Control>();
    private final Map<Integer, Monitor.Control> keyControlAltCodeMap = new HashMap<Integer, Monitor.Control>();
    public static final int KEY_UP = 38;
    public static final int KEY_DOWN = 40;
    public static final int KEY_LEFT = 37;
    public static final int KEY_RIGHT = 39;
    public static final int KEY_SIZE_DEFAULT = 8;
    public static final int KEY_CART_FILE = 116;
    public static final int KEY_CART_URL = 117;
    public static final int KEY_CART_PASTE_V = 86;
    public static final int KEY_CART_PASTE_INS = 155;
    public static final int KEY_CART_EMPTY = 118;
    public static final int KEY_QUALITY = 81;
    public static final int KEY_CRT_MODES = 82;
    public static final int KEY_VIDEO_STAND = 86;
    public static final int KEY_DEBUG = 68;

    public MonitorControls(Monitor monitor) {
        this.monitor = monitor;
        this.init();
    }

    public void addInputComponents(Component ... inputs) {
        int i = 0;
        while (i < inputs.length) {
            inputs[i].addKeyListener(this);
            ++i;
        }
    }

    private void init() {
        this.keyCodeMap.put(116, Monitor.Control.LOAD_CARTRIDGE_FILE);
        this.keyCodeMap.put(117, Monitor.Control.LOAD_CARTRIDGE_URL);
        this.keyCodeMap.put(118, Monitor.Control.LOAD_CARTRIDGE_EMPTY);
        this.keyAltCodeMap.put(81, Monitor.Control.QUALITY);
        this.keyAltCodeMap.put(68, Monitor.Control.DEBUG);
        this.keyAltCodeMap.put(82, Monitor.Control.CRT_MODES);
        this.keyAltCodeMap.put(116, Monitor.Control.LOAD_CARTRIDGE_FILE_NO_AUTO_POWER);
        this.keyAltCodeMap.put(117, Monitor.Control.LOAD_CARTRIDGE_URL_NO_AUTO_POWER);
        this.keyShiftCodeMap.put(38, Monitor.Control.SIZE_MINUS);
        this.keyShiftCodeMap.put(40, Monitor.Control.SIZE_PLUS);
        this.keyShiftCodeMap.put(37, Monitor.Control.SIZE_MINUS);
        this.keyShiftCodeMap.put(39, Monitor.Control.SIZE_PLUS);
        this.keyShiftAltCodeMap.put(38, Monitor.Control.SCALE_Y_MINUS);
        this.keyShiftAltCodeMap.put(40, Monitor.Control.SCALE_Y_PLUS);
        this.keyShiftAltCodeMap.put(37, Monitor.Control.SCALE_X_MINUS);
        this.keyShiftAltCodeMap.put(39, Monitor.Control.SCALE_X_PLUS);
        this.keyControlAltCodeMap.put(38, Monitor.Control.ORIGIN_Y_MINUS);
        this.keyControlAltCodeMap.put(40, Monitor.Control.ORIGIN_Y_PLUS);
        this.keyControlAltCodeMap.put(37, Monitor.Control.ORIGIN_X_MINUS);
        this.keyControlAltCodeMap.put(39, Monitor.Control.ORIGIN_X_PLUS);
        this.keyShiftControlCodeMap.put(38, Monitor.Control.HEIGHT_MINUS);
        this.keyShiftControlCodeMap.put(40, Monitor.Control.HEIGHT_PLUS);
        this.keyShiftControlCodeMap.put(37, Monitor.Control.WIDTH_MINUS);
        this.keyShiftControlCodeMap.put(39, Monitor.Control.WIDTH_PLUS);
        this.keyShiftCodeMap.put(155, Monitor.Control.LOAD_CARTRIDGE_PASTE);
        this.keyControlCodeMap.put(86, Monitor.Control.LOAD_CARTRIDGE_PASTE);
        this.keyCodeMap.put(8, Monitor.Control.SIZE_DEFAULT);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Monitor.Control control = this.controlForEvent(e);
        if (control == null) {
            return;
        }
        this.monitor.controlStateChanged(control, true);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Monitor.Control control = this.controlForEvent(e);
        if (control == null) {
            return;
        }
        this.monitor.controlStateChanged(control, false);
    }

    private Monitor.Control controlForEvent(KeyEvent e) {
        switch (e.getModifiersEx()) {
            case 0: {
                return this.keyCodeMap.get(e.getKeyCode());
            }
            case 512: {
                return this.keyAltCodeMap.get(e.getKeyCode());
            }
            case 64: {
                return this.keyShiftCodeMap.get(e.getKeyCode());
            }
            case 128: {
                return this.keyControlCodeMap.get(e.getKeyCode());
            }
            case 640: {
                return this.keyControlAltCodeMap.get(e.getKeyCode());
            }
            case 192: {
                return this.keyShiftControlCodeMap.get(e.getKeyCode());
            }
            case 576: {
                return this.keyShiftAltCodeMap.get(e.getKeyCode());
            }
        }
        return null;
    }
}

