#include <string.h>

#ifndef snprintf
#  define snprintf sprintf_s
#endif
#ifdef LINUX
#  define strnicmp strncasecmp
#endif

#ifndef bool
#  define bool int
#endif

#ifndef false
#  define false 0
#  define true 1
#endif



typedef unsigned long (*CycleConverter)( float samples );

enum MachineType { VIC20, C16, C64, BBC, ELECTRON };
enum VideoType { PAL, NTSC, NTSC2 };

struct MachineData
{
	char string[ 12 ];
	char machineID;
	enum MachineType type;
	unsigned long speed_PAL;
	unsigned long speed_NTSC;
	bool halfWave;
	float divisors[ 2 ];
	CycleConverter converter;
};

extern struct MachineData gMachineData;
extern int gRawLength;
extern float gRawCycles[], gThresholdDivisor[];

enum MediumType { WAV, T64, TAP, UEF };
enum AlgorithmType { TRIGGER, WAVE };
extern enum MediumType gInputType, gOutputType;
extern enum AlgorithmType gAlgorithmType;
extern enum VideoType gVideoType;


void AddRawCycle( float length );
unsigned long CorrectEndianLong( unsigned long source );
unsigned short CorrectEndianShort( unsigned short source );
unsigned long ConvertTo8087Float( float value );


