notecol	;routine for note-keys which are not hexa characters
		lda actwind
		bne jamming  ;check if we're in pattern editor. if not, these keys can still be used for jamming
		lda subwpos2+0
		bne jamming  ;check if we're in note column. if not, these keys can still be used for jamming
		lda jammode+1
		bne jamming ;if in note-columnm, these keys will be used for jamming
		jsr repeat  ;otherwise they're typed into the pattern
		beq noterep
		rts ;jmp retukey
noterep	stx notstor+1  ;X holds the musical keyboardjam note relative to given octave
		stx jammin0+1
		jsr jamming
		jsr setptnptr ;set pattern pointers in advance based upon actual track/pattern position
		jsr compcur ;don't write value if end of pattern, overwrites Y!
		beq nonotew
		jmp notewri
nonotew	rts

jammin0	LDX #0 ;SELF-written
jamming	;jamming will be in cooperation with Player
		cpx #$5f
		bcs nonotew ;no pitch-change if x is not in note-range	
		stx jamnote+1		
		rts  

;==========================================================================
writevalue      ;common point to write value in Y to cursor-position, and note in X to cursor position
        ;here to solve constant jam-key handling, before repeater starts working
chkptnw	lda actwind
		beq ptnwrit   ;patternwindow?
		jmp wrordli ;if not, go to test orderlist
ptnwrit	sty wrhxad1+1
		sty wrhxad3+1
		stx notstor+1
		stx jammin0+1
		jsr setptnptr ;set pattern pointers in advance based upon actual track/pattern position
		jsr compcur ;overwrites Y, it holds actual pattern number
		beq jammin0 ;nonotew ;don't write value if cursor at the endsignal of pattern 
		lda subwpos2+0 ;column number inside track
		bne isincol  ;note column?
		
;-----------------------------------Note column
		lda jammode+1
		bne jammin0 ;jamming ;will be used for jamming
		jsr repeat    ;repeater for value typing/writing
		bne nonotew ;noknote
		
notewri lda followp+1 ;if follow-playing, don't allow typing notes into pattern
		bne nonotew
		;note storing parts, no insertion because this column always exists
		jsr getcurnote ;detect vibrato amplitude typing
		and #$70
		cmp #$60 ;check, if vibrato existing
		bne notstor
		jsr getcurnote
		ldy wrhxad3+1 ;if value 0, delete vibrato
		bne nodelvi
		and #$80
nodelvi	jsr writehex2
		jmp instpt2
notstor	lda #0 ;self-written previously - prepare note value in A (from X)
		beq justwrn ;if note is 0 (key 1 or A), just write NOP
		cmp #$ff ;$ff signs if no note for key
		beq nonotew ;noknote
		;and #$7f ;trust ourselves, we didn´t send note (X-reg.) more than $60 from key-subroutines
		cmp #$60 ;special char above notes, no need to add octave info
		bpl justwrn
		
		jsr calcoct ;add octave multiplied by 12
		bpl nonotew
		
		jsr jammin0
		
justwrn	sta astorp1+1
		jsr getcurnote ;notevalue in A, positon in X (from pattern displayposition) 
		and #$80 ;delete previous character data (vibrato will be handled differently)
astorp1	ora #0 ;self-written previously from notenumber in X and octave
		jsr instpt2 
		
		lda autoadv  ;autoadvance in pattern by pre-adjusted amount
		sta pgdncnt+1
		beq endnotw
advplop	jsr godownp  ;go down in pattern
		dec pgdncnt+1
		bne advplop
endnotw	rts

calcoct	;add octave multiplied by 12 to Accu (note in octave)
		ldy jamoctave+1 ;octaves must be added
		beq +
-		clc ;loop to multiply note-octave by 12
		adc #12
		dey
		bne -
+		cmp #$5f  ;if octave got too big, no note entry
		rts
		
;--------------------------------Instrument column
isincol	lda followp+1 ;if follow-playing, don't allow typing values into pattern
		bne endnotw
		jsr repeat    ;repeater for value typing/writing
		bne endnotw
		lda subwpos2+0
		cmp #1
		bne noinsle ;left digit of intrument column?
		ldy wrhxad1+1 ;restore Y which holds number to type
		cpy #8
		bpl noptnwr
		jsr getcurnote
		bmi +   ;if instrument column exists already
		ldy wrhxad1+1 ;restore Y which holds number to type , instrument column does not exist, but not expanding 0, as that info doesn't need memory
		beq justadv ;just advance in case of 0
		ora #$80 ;no second column yet, sign it in note column
		pha
		ldy #1
		lda #0
		jsr insertpt ;insert data, move rest, check pattern overload
		pla
		cpy #$ff ;if pattern is full
		beq noptnwr ;then no action is taken
		jsr instpt2 ;sign in note-column
+		inx
		jsr instpt1  ;read instrument-column
		bpl + ;don't modify bit 7
		jsr writehex1 ;branch 1 - instrument column has bit7 ON
		ora #$80
		jmp aad
+		jsr writehex1 ;branch 2 - instrument column has bit 7 OFF
		bne aad  ;if instrument was zeroed out and no further columns, delete instrument column, move the rest back
		jsr delinst ;if typed value is 00, delete instrument
aad		jsr instpt2
justadv	jmp ptncuri ;jsr ptncuri ;autoadvance to digit 2

noinsle cmp #2
		bne fxtypwr ;right (2nd) digit of instrument column?
		jsr getcurnote
		bmi + ;if there is instrument column already, simply overwrite
		ldy wrhxad1+1 ;restore Y which holds number to type  ;not expanding 0, as that info doesn't need memory
		beq noptnwr ;in case of 0, don't write anything
		ora #$80 ;no second column yet, sign it in note column
		pha
		ldy #1
		lda #0
		jsr insertpt ;insert data, move rest, check pattern overload
		pla
		cpy #$ff ;if pattern is full
		beq noptnwr ;then no action is taken
		jsr instpt2
+		inx
		jsr instpt1
		jsr writehex2
		bne +        ;if 00 typed, delete unneeded instrument data
delinst	ldy #1 ;delete instrument column, if $00 typed there and no further columns
		jsr delbackpt ;backspace pattern from X position by Y bytes
		dex
		jsr instpt1 ;switch off bit7 of note column if instrument column is deleted on typing $00 (zeroing out)
		and #$7f
+		jsr instpt2
noptnwr	rts
;------------------------------FX type column
fxtypwr	cmp #3  
		bne fxtywri  ;fxtype column 1st (left) digit
		jsr checkinsert ;check if needs to be new column, insert needed extra bytes if not (Y reg)
		cpy #$ff ;$ff signs that wanted to write new $00 fx
		beq justadv ;don't write anything just autoadvance if tried to type new zero value
		cpy #0 ;if Y=0, column existed, no need for new bytes by default
		bne chknewf ;now check if existing value changed to bigfx, and insert or delete value
		
		inx   ;branch where fx column existed already
		jsr instpt1   ;enough to test here FX column data for big/smallFX at 1st digit typing 
		and #$e0
		bne smallfx  ;which type of FX was it before?
		
		ldy #2 ;2 bytes of bigFX need to be deleted later, if $00 is typed
		lda wrhxad1+1 ;check existing bigfx if it changes to smallfx
		cmp #2
		bmi + ;no fxtype change, therefore no reduction in pattern
		inx ;change bigfx to smallFX, remove bigfxvalue from pattern
		ldy #1
		jsr delbackpt ;backspace pattern from X position by Y bytes
		dex
		jmp decide2

smallfx	ldy #1 ;1 byte of smallFX needs to be deleted later, if $00 is typed
		lda wrhxad1+1 ;smallfx, check , if need to change to bigfx
		cmp #2
		bpl + ;insert value column?
		jsr instpt1
		jsr writehex1 ;check if zeroing out happened
		beq +
		ldy #1 ;yes, changing smallfx to bigfx
		lda #0
		jsr insertpt
		cpy #$ff ;if pattern is full
		beq noptnwr ;then no action is taken
+		dex
		jmp decided
		
chknewf	lda #$00  ;Y was not 0, checking completely new FX if bigFX value insertion needed
		jsr writehex1
		jsr decideval ;if bigFX, inserts 1 more byte (sets A=1 before insertptn)
		cpy #$ff ;if pattern is full
		beq noptwr ;then no action is taken
		;....   zeroing out will not be TRUE because this case has already been tested for zero occurence
decided	inx
decide2	jsr instpt1
		jsr writehex1   ;X holds position of FX-type column here
		bne +           ;check if the typed value is 0, and if it was previously existing nonzero, delete unneeded space
		
freemem	dex ;here the fx-type has been zeroed out
		jsr instpt1 ;sign in instrument column that FX column data has been deleted, if instrument is $80, delete it too (iny)
		and #$7f
		beq inszero
		jsr instpt2 ;instrument column was other then $80, simply switch off bit 7
		jmp noizero
inszero	dex  ;instrument was $80, so delete it and switch off bit 7 of note column
		jsr instpt1 ;switch off bit 7 of note column, as instrument column was $80 (zero)
		and #$7f
		jsr instpt2
		iny ;and delete one more byte ($80 instrument column)
noizero	inx
            ;if zeroed out, delete the unneeded FX type and value columns, free up unneeded memory space
		jmp delbackpt ;jsr delbackpt   ;delete unneeded outzeroed FX, Y holds the amount of deletion depending on big/smallFX

+		jsr instpt2
		jmp ptncuri ;jsr ptncuri ;autoadvance to digit 2
noptwr	rts 

fxtywri	cmp #4  ;fxtype 2nd (right) digit
		beq +
		jmp fxvawri  ;big FX value typing (if exists) 
+		jsr checkinsert
		cpy #$ff ;$ff signs that user wanted to write new $00 fx to empty place, as no point doing so
		bne + 
		jmp justadv ;don't write anything just autoadvance if tried to type new zero value
+		cpy #0  ;Y=0 if fxtype column existed already
		beq +   ;fxtype existed already?
		lda #$00 ;branch - Y was bigger than 0, was empty, making new fxtype byte, zeroing was checked already
		jsr writehex2
		jsr decideval
		cpy #$ff ;if pattern is full
		beq noptwr ;then no action is taken
+		inx  ;Y is not 0 if fxtype existed already, just checking if zeroing out happens
		jsr instpt1
		jsr writehex2
		bne + ;check if $00 was typed, delete unneeded bytes if it was $00 (1 if smallFX, 2 if bigFX)
		ldy #1 ;by default (smallfx) delete only 1 byte
		jsr instpt1
		and #$e0 ;check if small or big FX
		bne condelp  ;which type of FX was it before?, set Y accordingly
		ldy #2 ;here it was bigFX, delete 2 bytes
condelp	jmp freemem
+		jsr instpt2
		and #$e0
		bne noptwr ;+ ;if smallFX, don't autoadvance to value column
		jmp ptncuri ;jsr ptncuri ;autoadvance to FXvalue - if we have bigFX
;+		rts ;1 byte optimized

decideval ;decide if bigfx value is needed to be inserted upon new insert, and insert it
		and #$e0 ;small or big FX?
		beq bigfx
		lda #0 ;should be 1 if bigFX is inserted
		jmp insss
bigfx	lda #1
insss	jmp insertpt ;jsr insertpt ;insert data, move rest, check pattern overload, amount in Y

checkinsert  ;check and do data in fxtype column, Y holds amount of needed insertion on return
		jsr getcurnote ;get note column data
		inx
		cmp #0
		bmi +  ;test note column data
		jsr chptful ;pre-check if pattern is full, a and x stays preserved
		bcs ptnful3
		ldy wrhxad1+1 ;restore Y which holds number to type  ;not expanding 0, as that info (NOP) doesn't need memory
		bne nozerop ;just advance in case of 0, don't write anything
		ldy #$ff  ;if tried to write new zero value
		rts
nozerop	dex     ;set notecolumn bit 7 
		ora #$80
		jsr instpt2 ;bit 7 of note is on
		inx
		ldy #2 ;amount of shifting
		rts
		;note column was above $80, instrument column exists, no need for inst.insertion
+		jsr instpt1   ;get instrument data
		bmi adjustit  ;test instrument column data
		jsr chptful ;pre-check if pattern is full, a and x stays preserved
		bcs ptnful3
		ldy wrhxad1+1 ;restore Y which holds number to type  ;not expanding 0, as that info (NOP) doesn't need memory
		bne inserp1   ;just advance in case of 0, don't write anything
ptnful3	ldy #$ff
		rts
inserp1	ora #$80      ;no 3rd column yet, sign it in instrument column
		jsr instpt2   ;sign in instrument-column
		ldy #1
		rts
adjustit ldy #0  ;both note and instrument column bit7 is ON, FX type column existed already
retpntw	rts

;---------------------------------------------FX value column
fxvawri	 ;bigFX value writer in column 5-6
		jsr getcurnote
		bpl retpntw ;nofxvaw  ;check note column
		inx
		jsr instpt1
		bpl retpntw ;nofxvaw
		inx
		jsr instpt1
		and #$E0 ;check if bigFX
		bne retpntw ;nofxvaw
		inx
		jsr instpt1
		ldy subwpos2+0 ;column inside track
		cpy #5
		bne +
		jsr writehex1
		jsr instpt2
		jmp ptncuri
+		jsr writehex2
		jmp instpt2 

;================================ORDERLIST?=============================
wrordli	jsr repeat    ;repeater for value typing/writing
		bne retpntw ;noolrep
		lda actwind
		cmp #1        ;Orderlist?
		beq +
		jmp chwrinw ;------------ORDERLIST------------------------------
+		sty wrhxad1+1  
		sty wrhxad3+1
		jsr setseqptr
		lda subwpos2+1 ;cursor X position
		clc
		lsr
		bcs oddposi ;if the cursor at even or odd position - which nybble to change
		clc
		adc seqdpos+1 ;add displaying position
		tay
		dey
		;sty cmpjmpa+1 ;to check, if loop-jumpaddress is inside sequence, don't allow bigger
		jsr seqaddb
		iny
		cmp #$ff  ;check, if we're setting jump-address
		bne lal2
		jsr seqaddb
		jsr writehex1
.IF SUBTUNEJUMP_ON
		bpl + ;if below $80 watch for max. seq.length 
		cmp #maxsubtuneamount+$80 ;if above $80, allow typing, because it means subtune-switching
		bmi ++ ;if below limit, no modification
		lda #maxsubtuneamount+$80
		bne ++ ;jump
.FI		
+		cmp #seqlength
		bcc +
		lda #seqlength
		+
;cmpjmpa	cmp #0 ;self-written before  - check if loop-jumpaddress is in range?
;		bmi outseq1
;		tya
outseq1	jmp wroldat
lal2	cmp #$fe
		beq noolwr ;don't write after $fe, even if there's nonzero
		jsr seqaddb ;get the data in A by index prepared in Y
		beq noolwr  ;don't let pattern $00 to be overwritten (it's special)
		cmp #$fe
		bcs chkfeff
		jsr writehex1
		bne +      ;don't let pattern number to be $00 (it's special value)
		lda #$01 ;write 1 if user wants to write 0
		jmp wroldat
+		pha ;can write above $80 for transposer
		and #$7f  ;bigger than $80 can be used here to expand orderlist-FX,transpose
		tax
		pla
		cpx #maxptnamount ;don't allow bigger pattern number than the allowed
		bcc wroldat
		lda #maxptnamount
wroldat	jsr seqaddc ; set/write the data in A to orderlist position
		inc valuecont ;ensure continuous typing at scrolling time
		jmp seqstpr1 ;step one digit to the right (autoadvance)

chkfeff	jsr writehex1
		cmp #$fe
		bcs wroldat
noolwr	rts
oddposi	clc ;cursor at odd position
		adc seqdpos+1;add cursor position
		tay
		dey
;		sty cmpjmp2+1 ;to check, if loop-jumpaddress is inside sequence, don't allow bigger
		jsr seqaddb
		iny
		cmp #$ff  ;check, if we're setting jump-address
		bne lal3
		jsr seqaddb
		jsr writehex2
.IF SUBTUNEJUMP_ON
		bpl + ;if below $80 watch for max. seq.length 
		cmp #maxsubtuneamount+$80 ;if above $80, allow typing, because it means subtune-switching
		bmi ++ ;if below limit, no modification
		lda #maxsubtuneamount+$80
		bne ++ ;jump
.FI		
+		cmp #seqlength
		bcc +
		lda #seqlength
		+
;cmpjmp2	cmp #0 ;self-written before  - check if loop-jumpaddress is in range
;		bmi outseq2
;		tya
outseq2	jmp wrolda2
lal3	cmp #$fe
		beq noolwr ;don't write after $fe
		jsr seqaddb;get the data in A by index prepared in Y
		beq noolwr  ;don't let pattern $00 to be overwritten (it's special)
		cmp #$fe
		bcs chbfeff
		jsr writehex2
		bne +  ;don't let pattern number to be $00 (it's special value)
		lda #$01 ;write 1 if user wants to write 0
		jmp wrolda2
+		pha
		and #$7f ;bigger than $80 can be used here to expand orderlist-FX,transpose
		tax
		pla
		cpx #maxptnamount ;don't allow bigger pattern number than the allowed
		bcc wrolda2
		lda #maxptnamount
wrolda2	jsr seqaddc ; set/write the data in A to orderlist position
		inc valuecont ;ensure continuous typing at scrolling time
		lda autoadv
		beq noolwr
		jmp seqstpr2 ;step one digit to the right (autoadvance)

chbfeff	jsr writehex2
		cmp #$fe
		bne +
		jsr seqaddc
		iny
		lda #0
		jmp seqaddc ;delete jumpaddress, if $fe endsignal is typed
+		bcs wrolda2
notwrid	rts
;---------------------------------------------		
chwrinw	cmp #2             ;instrument-window?
		beq +
		jmp chwrchw
+		sty wrhxad1+1  
		sty wrhxad3+1
		jsr setinsptr  ;set instrument´s memory basepointers
		lda subwpos1+2  ;actual instrument-subwindow
		bne instbl     ;main instrument window or tables?
		lda subwpos2+2 ;x coordinate in instrument window
		cmp #4         ;where the full 00..FF value fields are
		bpl wrhrtim ;if column 4 or 5
		lsr
		bcs insmwri  ;if odd or even column 
		jsr calcmwpos
		jsr instpt1
		jsr writehex1
		jsr instpt2
		jmp inswiri ;jsr inswiri ;autoadvance
;		rts ;1 byte optimized
insmwri	jsr calcmwpos
		jsr instpt1
		jsr writehex2
		jsr instpt2
		lda subwpos2+2
		cmp #3
		bpl notwrid
		jmp inswiri ;autoadvance

wrhrtim	bne wroctav ;branch if column 5
		lda subwpos3+2 ;set HR timer with numer keys 0..2
		cmp #1
		bne notwrid ;nowrida ;wroctav
		cpy #3
		bpl notwrid ;nowrida ;if typed value is too much for HR-timer(more than 2)
		ldx #0
		jsr instpt1
		and #$fc
		ora wrhxad1+1
		jmp instpt2

wroctav	lda subwpos3+2  ;Y coordinate
		cmp #3
		bne notwrid ;nowrida  ;if not last
		cpy #8 ;maximum octave decrease in instrument
		bpl notwrid ;nowrida ;don´t allow bigger octave shift by typing
		ldx #9 ;Octave-shift amount of instrument
		jsr instpt1
		bmi + ;if negative
		lda OCTMULS,y ;get octave transposition value 
		jmp instpt2 
+		lda #0
		jsr writehex2
		tay
		lda OCTMULS,y ;get octave transposition value 
		sec
		sbc #1
		eor #$ff  ;negative value
		jmp instpt2

instbl	;--------------------instrument-tables-----------------------------------
		lda subwpos2+2 ;x cursor-coordinate in WFARP table
		lsr
		php ;CARRY BIT WILL SIGN IF EVEN OR ODD COLUMN
		sta xtoadd+1  
		jsr getitbi  ;get instrument-table position
		ldy subwpos2+2
		
        ;common part to add X coordinate into mem.position
calcom	tax  ;memory position under cursor to X, get value to A
		jsr instpt1 ;check if endrow (1st column) 
		cmp #$ff
		bne + ;endrow - don't modify anything
		plp
		rts
+		sta chktjmp+1 ;if 1st row is $FE delimiter, notify to multiply written jump-address by 3
		txa
xtoadd	adc #0  ;self-written
		tax
		jsr instpt1 ;jsr instpt1 ;read data under cursor to Accu

instbcom ;common place for even row of instrument tables
		plp ;CARRY bit back
		bcs insbco2 ;woddcol ;even or odd column
		cpy #2
		bpl + ;check if 1st column
		jsr writehex1 ;merge typed 1st hexa digit with existing data
		cmp #$ff    ;don´t allow writing $ff endsignal at 1st column
		beq nowrida
		cmp #$fe  ;if $fe jump command typed to 1st column, zero (init) jump-address 
		bne ++++
		jsr instpt2
		inx
		lda #0 ;zero (init) jump-address
		jmp cheatj1
+		cpy #4
		bpl + ;check if 2nd column
chktjmp	ldy #0 ;self-written previously, help to determine if jump-address
		cpy #$fe
		bne ++
		ldy subwpos1+2 ;actual instrument subwindow
		sec
		sbc jmtbase,y
		jsr div3acu
		jsr writehex1 ;merge typed 1st hexa digit with existing data
		jsr multi3b ;multiply jump-address by 3
cheatj1	ldy subwpos1+2 ;actual instrument subwindow
		clc
		adc jmtbase,y
		jmp +++
+		ldy chktjmp+1  ;3rd column ;help to determine if $fe in row
		cpy #$fe
		beq nowrida ;don't modify third column if $fe jump is in row
+		jsr writehex1 ;merge typed 1st hexa digit with existing data
+		jsr instpt2 ;write data at X index
		jmp inswiri ;autoadvance
nowrida	rts

insbco2	cpy #2
		bpl + ;check if 1st column
		jsr writehex2 ;merge typed 2nd hexa digit with existing data
		cmp #$ff    ;don´t allow writing $ff endsignal at 1st column
		beq nowrida
		cmp #$fe  ;if $fe jump command typed to 1st column, zero (init) jump-address 
		bne ++++
		jsr instpt2
		inx
		lda #0 ;zero (init) jump-address
		jmp cheatj2
+		cpy #4 ;check if 2nd column
		bpl +
		ldy chktjmp+1  ;2nd column ;help to determine if $fe in row
		cpy #$fe
		bne ++
		ldy subwpos1+2 ;actual instrument subwindow
		sec
		sbc jmtbase,y
		jsr div3acu
		jsr writehex2 ;merge typed 2nd hexa digit with existing data
		jsr multi3b ;multiply jump-address by 3
cheatj2	ldy subwpos1+2 ;actual instrument subwindow
		clc
		adc jmtbase,y
		jmp +++
+		ldy chktjmp+1  ;3rd column ;help to determine if $fe in row
		cpy #$fe
		beq nowrida ;don't modify third column if $fe jump is in row
+		jsr writehex2 ;merge typed 2nd hexa digit with existing data
+		jsr instpt2 ;write data at X index
		lda subwpos2+2 ;auto-advance right. if column 5, no further autoadvance
		cmp #5
		bpl nowrida
		jmp inswiri ;autoadvance

;-----------------------------------------------------------------------
chwrchw	cmp #3 ;chordtable-window?
		bne tmptbwr
		sty wrhxad1+1  
		sty wrhxad3+1
		jsr getctpos ;get chordtable-position under cursor (position in X, value in A)
		ldy subwpos2+3
		bne +   ;first digit comes
		cmp #$7e  ;don't overwrite end signal 1st digit
		beq chk7e7f
		cmp #$7f  ;don't overwrite return signal 1st digit
		beq chk7e7f
		jsr writehex1
		cmp #$7e
		beq noctwr
		cmp #$7f
		beq noctwr
wrctdat	sta chords,x
		ldx #3
		jmp chtmrig  ;cursor to right (autoadvance)
chk7e7f jsr writehex1
		cmp #$7e
		beq wrctdat
		cmp #$7f
		beq wrctdat
		rts
+		cmp #$7e  ;don't overwrite end signal 2nd digit
		beq chb7e7f
		cmp #$7f  ;don't overwrite return signal 2nd digit
		beq chb7e7f
		jsr writehex2
		cmp #$7e
		beq noctwr
		cmp #$7f
		beq noctwr
wrctda2	sta chords,x
		jmp carretn   ;cursor to next row (autoadvance)
chb7e7f jsr writehex2
		cmp #$7e
		beq wrctda2
		cmp #$7f
		beq wrctda2
noctwr	rts

;----------------------------------
tmptbwr	;tempotable-window
		sty wrhxad1+1  
		sty wrhxad3+1
		jsr gettpos  ;get tempotable positison and data under cursor to X and A
		ldy subwpos2+4 ;check horizontal cursor position in tempotable
		bne + 
		ldy wrhxad1+1 ;don't allow to type more than 7 into 1st digit
		cpy #8
		bpl noctwr 
		cmp #0
		bpl noendco ;no correction if not end-of-program is under cursor
		pha
		lda wrhxad1+1
		ora #$08
		sta wrhxad1+1
		pla
noendco	jsr writehex1 ;left position
		sta TEMPOTBL,x
		ldx #4
		jmp chtmrig ;cursor to right (autoadvance)
+		jsr writehex2
		sta TEMPOTBL,x
		jmp carretn ;cursor to next row (autoadvance)

;==================================================================================================
