;INITIALIZATION AT PROGRAM START - set IRQ handlers, screen, and main VIC registers
appiniter
		lda #$35
		sta banksel         ;no need for ROM, just when loading/saving in menu	
		lda #$7f
		sta $dc0d
		sta $dd0d
		lda $dc0d
		lda $dd0d
		lda #<irq
		sta $fffe     ;maskable IRQ pointer setting
		lda #>irq
		sta $ffff
		lda #<dummirq
		sta $fffa     ;NMI (restore key) pointer setting
		lda #>dummirq
		sta $fffb
		
iniscrn	ldy #0       ;copy the RAM $d800..$dc00 to COLOUR-RAM $d800..$dc00
		sty $d020
		sty $d021
		ldx #$35  ;initial value for bank-switching byte $01
		stx banksel
	
islp	dec banksel       ;$34
		lda #0
		sta zerovar2,y ;zerovar,y
		sta ordlspr,y  ;zero out orderlist sprite-bitmap area
		sta ordlspr+$100,y
		lda olcursp,y  ;copy orderlist-cursor sprite from RAM under IO area
		sta orlcurs,y
		lda $d800,y
		ldx $d900,y
		inc banksel
		sta $d800,y
		txa
		sta $d900,y
		dec banksel
		lda $da00,y
		ldx $db00,y
		inc banksel       ;$35
		sta $da00,y
		txa
		sta $db00,y
		iny
		bne islp
		
		;$01 must be $35 here

		ldy #0
		jsr mutesolodisp ;performs colouring of track at mute/solo - tracknumber in y - done outside IRQ
		ldy #1
		jsr mutesolodisp ;performs colouring of track at mute/solo - tracknumber in y - done outside IRQ
		ldy #2
		jsr mutesolodisp ;performs colouring of track at mute/solo - tracknumber in y - done outside IRQ

		ldy #6
		ldx #0
		lda #$19 ;starting coordinate of bordersprites
-		sta bordxco+1 ;border-sprite x coordinates
		lda #borderspcol
		sta $d028,y
		tya
		clc
		adc #(ordlspr/$40)
		sta lowvidram+$3f9,y ;lower border graphic sprite-pointers
bordxco	lda #0 ;self-written, bordersprite X-coordinate
		sta $d002,x
		clc
		adc #$30 ;the width of a double-wide sprite - add to coordinate
		inx
		inx
		dey
		bpl -	

		lda #(orlcurs//$4000 / $40)  ;modulo of VIC-banksize divided by spritesize
		sta lowvidram+$3f8
		
		ldx #1
		stx $d01a
		stx $d012
		;stx inirequ+1 ;ensure that player initialization happens at startup
		
		jsr resetune ;contains inireq+1 increasing + selects 1st patterns of subtune

;----------------------------------------------------------------------------
