;=======================================================================================
;Player-adapter - ensures sophisticated player and editor communication (flexibility)
;---------------------------------------------------------------------------------------
padapter ;ensures refreshment of editor-counters
		ldx #2 ;check all the 3 channels: 2..0
-		ldy mul7chn,x
		lda SEQPOS,y ;played pattern on channel 2..0 in player
		cmp prevspo,x ;check, if played pattern changed
		beq + ;skip if not changed
		inc seqrefr ;if changed, tell editor
+		sta prevspo,x ;store actual data to temporary storage for further comparison
		lda TMPPOS,y  ;check if speed-counter reaches tempo
		tay
		lda TEMPOTBL,y
		and #$7f
		beq + ;if tempo is 0
		ldy mul7chn,x
		cmp SPDCNT,y
		bne +  ;if SPDCNT is max., increment in editor's pattern-row 
		lda playmod
		beq + ;if playback stopped, don't dare to count, my little wizard!
		inc ptrowpos,x  ;ONLY FOR EDITOR to display position easily	
+		ldy mul7chn,x
		lda PTNPOS,y
		bne + ;if pattern-play position is zero, reset editor's pattern-row
		lda #0 
		sta ptrowpos,x ;ONLY FOR EDITOR to display position easily	
+		lda playmod
		beq + ;if jamming mode don't mute any tracks
		lda mutesolo,x
		and #1
		bne +
		sta SIDBASE+6,y ;immediate muting of long-released instruments
		sta SIDBASE+5,y
+		dex
		bpl -
		
.if OSCILLOSCOPE=1 ;buffer signal-data for oscilloscope
		lda FSWITCH+1 ;check if channel 3 is filtered
		and #4
		sta osc3fil+1
		beq + ;if no filter, don't calculate anything
		lda FLTBAND+1 ;check if filter is lowpass/highpass
		and #$10 ;check lowpass-bit
		sta filpass+1
		lda CTFMETR+1 ;value of CUTOFF-METER DISPLAY FOR EDITOR
		lsr ;0..127
		lsr ;0..63 - fits into Exponential table of player (used for multiplication) 
		adc #34 ;correct curvature
		cmp #64 ;maximum allowed value to prevent signal overload
		bmi +
		lda #64 ;to fine-tune the 8580 SID-filter emulation
+		sta filfreq+1
		tay
		lda EXPTABH+8,y ;leave 8 spaces below in exp.table for negative signal-values
		sta flbasep+1   ;and at the same time, don't use unprecise values at the beginning
		+
		lda #8 ;initialize software-filter (emulates filter for scope)
		sta capstore 
		ldx #0 ;help displayer2 to display oscilloscope
oscoplp	lda SIDBASE+$1b ;OSC3 (oscillator of 3rd channel)
		;eor #$ff ;mirror Y axis if needed for correct display (value=255-value) 
		lsr ;0..127
		lsr ;0..63
		lsr ;0..31
		lsr ;0..15 ;local region of exp-table less distorted - used for multiplication
		sta signale+1
osc3fil	ldy #0 ;self-written ;zero if channel 3 is not filtered
		beq nofilt ;if channel 3 not filtered, no need to emulate
		sec
		sbc capstore ;calculate difference of current signal and the previous (1 frame before)
		clc ;range from $f0..$0f to $00..$1f
		adc #16 ;0..1f
		lsr ;$00..$0f  - INPUT 1 (MULTIPLICAND)
		clc
filfreq	adc #0 ;Multiplier/divisor (a matter of perspective which one)
		tay
		lda EXPTABH,y ;FREQHI,y ;;;
		sec
flbasep	sbc #0 ;self-written
modisig	clc ;modify signal by filtered difference
		adc capstore
		sta capstore ;store output value into buffer - used by software-filter emulation
filpass	ldy #0 ;self-written ;$10 if lowpass, otherwise 0
		bne + ;if hi-pass, substract low-passed filtervalue from original signal
signale	lda #0 ;self-written ;OSC3-scaled signal 
		sbc capstore
		adc #9 ;shift up if there's negative in the difference
		+
nofilt	sta OSC3buffer,x
		inx
		cpx #12
		bne oscoplp
		lda SIDBASE+$1c ;ENV3 (envelope of 3rd channel)
		beq + ;if 0, no need to calculate
		lsr ;0..127
		lsr ;0..63 - fits into Exponential table of player (used for multiplication)
		adc #10 ;correct curvature
		cmp #64 ;maximum allowed value to prevent signal overload
		bmi +
		lda #64 ;to fine-tune the 8580 SID-filter emulation
+		sta ENV3sto+1 ;in 'displayer2'
.fi		
		rts
capstore	.byte 0 ;previous frame value used by capacitor

;-------------------------------

playmod .byte $0 ;if 0, no play (edit/jam), if 1 - play tune, if 2 - patternplay
mul7chn	.byte 0,7,14 ;bytes for easy multiplication with 7 (convert player's X indexing to editor's)
prevspo .byte 0,0,0 ;temporary storage to store previous sequence-positions
ptrowpos .byte 0,0,0 ;the row played by the player - ONLY NEEDED FOR EDITOR to display
seqrefr .byte 1 ;signs, if orderlist-display needs refreshment

;opcode-data needed to alter player-code
ptnpcod	JMP PTNPLAY  ;code to player for pattern-playing mode
norpcod	LDY SEQPOS,X ;code to player for normal playing mode

;constants/variables based on 0/7/14 X indexing - for player-editor cooperation 
PWHIHELP  .BYTE 0 ;HELP FOR EDITOR WITH GIVING CORRECT VALUES OF PULSEWIDTH HI-NIBBLE
playerins .byte 0 ;when stop pressed, actual instruments (ACTINS,X) is saved here, than restored when continued
div7chn   .byte 0 ;convert 0/7/14 indexing to 0/1/2 indexing
          .byte 0,0,0,0, 0,0,1,0,0,0,0, 0,0,2,0,0,0,0

;=======================================================================================
resetune ;request 'reset/init tune' after subtune-selection, or after loaded (or maybe full stop)
		lda selsubt+1
		jsr SETSTUNE ;SET SUBTUNE (PLAYER-ROUTINE)
		inc inirequ+1 ;request init from main routine - direct init will screw up IRQ
		inc seqrefr ;refresh sequence-display
		ldx #2
-		lda #0
		sta ptrowpos,x 
		sta olstart,x
		sta playmod ;stop playback after switching subtune
		sta followp+1
		sta subwpos2+1 ;beginning of orderlist
		sta seqdpos+1
		sta prevspo,x
		tay ;Y=0
seqread	jsr SEQSUBb
		beq invalip ;if pattern-value is 0 somehow
		cmp #maxptnamount
		bcc respatn ;if pattern value is valid
		cmp #$fe ;is it hardwired sequence-delimiter?
		bcs invalip ;not to switch to invalid pattern for empty subtunes
		iny ;if there's SEQ-Fx at the position check for next position
		bne seqread ;safety jump - if no valid pattern found yet
respatn	sta actptn1,x
		lda #0
		sta prowpos,x
		stx subwpos3+0 ;beginning of pattern
skipres	dex
		bpl -
		rts	
invalip	lda #1 ;assign pattern 1 if no better selection
		ldy actptn1,x ;problem with read value, check if actual selected pattern is invalid, if invalid, assign pattern 1
		beq respatn ;if zero, reset to 1
		bmi respatn ;if above $80, reset to 1
		jmp skipres ;skip resetting to 1 if legal patterns are selected
;------------------		
SEQSUBb	lda mul7chn,x ;editor's version of SEQSUB - X is transformed for player then restored, Y intact
		stx mul7st1+1 ;store X
		tax
		jsr SEQSUB  ;get data at 1st positions of orderlist sequences into Accumulator
mul7st1	ldx #0 ;self-written code - restore X
		cmp #0 ;reget status flags for accu
		rts
;-------------------		
inisubb	;player-adapter version of initer ($1000) of player routine
		ldx #2
-		lda #0
		sta ptrowpos,x ;reset the row played by the player 
		dex
		bpl -
		lda selsubt+1
		jmp inisub
;-------------------------------
ptplyon	ldx #2 ;set patternplay mode in player by overwriting an instruction and operand
-		lda ptnpcod,x
		sta ptncode,x ;overwtrite instruction in player-routine
		dex
		bpl -
		rts
ptploff	ldx #2 ;switch-off pattern-playing mode
-		lda norpcod,x
		sta ptncode,x ;overwtrite instruction in player-routine
		dex
		bpl -
		rts

;=======================================================================================
followplay ;if follow-mode is on, this subroutine overrides key navigation and controls patterns
followp	lda #0 ;self-written variable  ;followplay signal, if 0-no follow, if 1-follow orderlist by patterns (actptn)
		beq retpnt0
		ldx #2
-		ldy mul7chn,x
		lda ACTPTN,y ;help from player
		beq SkiPPos
		cmp #maxptnamount+1
		bcs SkiPPos  ;not to switch to invalid pattern for empty subtunes
		sta actptn1,x ;go to currently played patterns
		lda ptrowpos,x ;help from player
		sec
		sbc #12   ;row at half of the screen, stay in focus
		bcs +
		lda #0
+		sta folsto1+1

		ldy actptn1,x
		lda ptnlength,y
		sec
		sbc #12   ;row at half of the screen, stay in focus
		cmp ptrowpos,x
		bcc SkiPPos
folsto1	lda #0 ;self-written
		cmp #maxptnlen
		bcs SkiPPos  ;don't allow invalid positions
		sta prowpos,x
SkiPPos	dex
		bpl -
		ldx subwpos1+0 ;actual track
		lda ptrowpos,x
		sec
		sbc prowpos,x
		bcc retpnt0   ;don't allow cursor go above row 0 in display area
		cmp #25
		bcs retpnt0 ;but in case, don't allow cursor to go through screen
		sta subwpos3+0
retpnt0	rts


;===========================================================================          
pause	;pause playback ;in player the patternplay-code (overwritten by playadapter) was altered, no need to resume playermode
		ldx #2*7 ;release notes
-		lda #0 ;lda #GATEOFFX ;$7e ;do a 'gate-off' effect
		lda #9
		sta SIDBASE+4,X ;1st jammed sound should start well
		lda #0
		sta SIDBASE+5,X ;stop sounds when stopping tune
		sta SIDBASE+6,X
		lda ACTINS,X ;store actual played instruments
		sta playerins,X
		lda selinst+1 ;and replace them with actual selected instrument
		sta ACTINS,X
		lda #0 ;disable pattern-effects when playback stopped
		sta ACTIFX,X
		sta ACTFX2,X
		txa
		sec
		sbc #7
		tax
		bpl -
		rts
;----------------------          
continue ;continue playback if F4 was pressed after pause	
		ldx #2*7 ;if continuing playback is started
-		lda playerins,x ;restore player's instruments which were stored when tune was stopped
		sta ACTINS,x
		sta ACTIFX,x
;		lda #1 ;trigger pointer-resets
;		sta ACTNOT,x
;.IF (PWRESETSW_ON+FILTRESETSW_ON)
;		LDY #%00111111 ;CAUSE FILTER&PW-TABLE TO RESET AT INSTRUMENT-SELECTION
;.FI		
;		jsr CHKNOTE ;reset pointers
		txa
		sec
		sbc #7
		tax
		bpl -
		rts

;=======================================================================================

jamplay	;player caller for keyboard-jamming (called if 'playmod'=0) 

jamnote	lda #0 ;self-written variable - note hit by user
		beq afternote ;if no note was pressed
jambuf	ldx #0 ;self-written variable - note stored in previous frame - to determine instrument-start 	
		beq insinit  ;start instrument (tick2) if transition from 'note-released' to 'note presse'
		cpx jamnote+1 ;if note-value changed it's legato
		beq inscont  ;if note-value not changed, CNTPLAY
		;legato (pressing notes on keyboard without rest inbetween)
inslega	jsr calcoct    ;add octave*12
		ldy subwpos1+0 ;actual track
		ldx actwind
		cpx #2
		bne + ;if we're in instrument window, test note on 3rd channel to display it on scope
		ldy #2 
+		ldx mul7chn,y 
		sta ACTNOT,X
		lda #$3f ;legato effect code for instrument-column
		sta ACTIFX,x 
		jmp dotick2 ;perform notestart
		
inscont	ldx #2*7 ;continuation of pressed note
-		jsr CNTPLAY
		txa
		sec
		sbc #7
		tax
		bpl -
		jmp dojam
		
insinit jsr calcoct    ;add octave*12
		ldy subwpos1+0 ;actual track
		ldx actwind
		cpx #2
		bne + ;if we're in instrument window, test note on 3rd channel to display it on scope
		ldy #2
+		ldx mul7chn,y 
		sta ACTNOT,x
		lda selinst+1 ;selected instrument
		sta ACTINS,x
		jmp dotck2a
;
afternote  ;if no key pressed set
		ldx jambuf+1
		beq inscont ;check with previous note-value if transition from 'note pressed' to 'note released' happened
		ldy #2 ;pre-selection of Y
		ldx actwind
		cpx #2
		beq ++ ;if we're in instrument window, test note on 3rd channel to display it on scope
		lda dovetail ;if dovetailing mode is ON cycle tracks
		beq +
		jsr tabptfw ;go to next track upon pressing note
+		ldy subwpos1+0 ;actual track
+		ldx mul7chn,y 
		lda #GATEOFFX ;$7e ;do a 'gate-off' effect
		sta ACTNOT,x
dotck2a	lda #0
		sta ACTIFX,x
dotick2 ;perform notestart (tick2)
.IF (PWRESETSW_ON+FILTRESETSW_ON)
		LDY #%00111111 ;CAUSE FILTER&PW-TABLE TO RESET AT INSTRUMENT-SELECTION
.FI		
		jsr CHKNOTE

dojam	jsr COMMONREGS ;set common SID registers
		lda jamnote+1
		sta jambuf+1
		
		rts

;=======================================================================================
