;******************************************************************************
;                    Hermit SID-WIZARD player routine
;******************************************************************************
;ATTENTION:ANY TIME YOU ADD AN ABSOLUTE-ADDRESSING COMMAND, REGISTER ITS ADDRESS IN 'RELOCATOR.INC' LIKE I DID.
;OTHERWISE THE RELOCATION WON'T BE APPLIED TO THAT COMMAND AND THE PLAYER CODE WON'T WORK AS EXPECTED

.IF !(PLAYERZP)
 PLAYERZP=$FE ;routine saves and restores the value of these 2 zeropage lacotions (so it can overlap)
.FI 
;APPLICATION-RELATED TWEAKS FOR SHORTER EXECUTION TIME (RASTERTIME) AND SMALLER CODE-SIZE
;---------------------------------------------------------------------
.IF COMPILEDAPP=1 ;IF EDITOR IS BEING COMPILED
 PACKEDNOPSUPP_ON=0 ;PACKED REST/NOP PLAYING IS NOT NEEDED IN TRACKER
 ZEROPAGESAVE_ON=0 ;NOT NEEDED IN EDITOR - SAVING/RESTORING ZEROPAGE BYTES BEFORE/AFTER PLAYER ROUTINE 
.ELSE
 PACKEDNOPSUPP_ON=1 ;IF PACKED REST/NOP PLAYING IS SUPPORTED
 ZEROPAGESAVE_ON=AVOIDZEROPAGE_ON ;IF ZEROPAGE-SAVING IS DISABLED GLOBALLY
.FI

;MACROS (CODE USED MORE TIMES BUT NOT TO BE SUBROUTINES WITH SLOWER CALL-TIME)
;-------------------------------------------------------------------------------
;don't include absolute addressing instructions here, that would cheat relocator
;-------------------------------------------------------------------------------
SETVFRE	.MACRO ;MACRO DEFINITION FOR VIBRATO-FREQUENCY ADJUSTER (INPUT:ACCU., OUTPUT:ACCU.)
		ASL ;ASL, BIT 1 IS ALWAYS 0, SO IT CAN BE CLIPPED INTO 2 EQUAL TIMEFRAMES FOR SLIDE UP/DOWN
.ENDM 

DIVIDE8	.MACRO ;DIVIDER MACRO FOR SMALLER SOURCECODE-SIZE
		LSR
		LSR
		LSR
.ENDM

MULTIP8	.MACRO ;MULTIPLIER MACRO FOR SMALLER SOURCECODE-SIZE
		ASL
		ASL
		ASL
.ENDM

;================================JUMPTABLE=====================================
*=PLAYERADDR
inisub  JMP INITER ;PLAYER & SID INIT ROUTINE
playsub JMP PLAYER ;PLEYER ROUTINE ITSELF
mulpsub JMP MULPLY ;MULTISPEED CALL
volusub JMP SMALFXA ;VOLUME-SETTING CALL

;========================PLAYER SIGNATURE AND VERSION==========================
INFO     .TEXT "HERMIT SID-WIZARD V"
		 .BYTE SWversion ;APPEND TO PLAYER-NAME
;==============================================================================
VARIABLES ;BEGINNING OF VARIABLES' SECTION - VARIABLES ARRANGED IN BUNCHES OF 7
FREQLO	.BYTE 0 ;(SID.0) FREQUENCY (PITCH) LO-BYTE GHOST-REGISTERS
FREQHI	.BYTE 0 ;(SID.1) FREQUENCY (PITCH) PITCH HI-BYTE GHOST-REGISTERS
PWLOGHO	.BYTE 0 ;(SID.2) PULSEWIDTH LOW-BITE GHOST-REGISTERS
PWHIGHO	.BYTE 0 ;(SID.3) PULSEWIDTH HI-BYTE GHOST-REGISTERS
WFGHOST	.BYTE 0 ;(SID.4) WAVEFORM/CTRL GHOST-REGISTERS
PTNGATE	.BYTE 0 ;GATE OFF/ON STATUS CONTROLLED BY PATTERN (AND MUTE/SOLO IN EDITOR?)
PWEEPCNT .BYTE 0 ;PULSEWIDTH SWEEP-LENGTH TIMER
.CWARN *>7+VARIABLES,"MAXIMUM 7 VARIABLES ALLOWED PER BUNCH!"
*=VARIABLES+1*(3*7) ;ENSURE SPACE FOR 3 SID-CHANNELS' VARIABLES
SPDCNT	.BYTE 0 ;FRAMESPEED COUNTERS (INCREMENTAL)
TMPPTR	.BYTE 0 ;STARTPOINTS OF ACTUAL TEMPOPROGRAMS ;USED BY OTHER PARTS
TMPPOS	.BYTE 0 ;ACTUAL TEMPO-POSITIONS IN TEMPOTBL (NEEDED BY PLAYADAPTER IN EDITOR TOO)
SEQPOS	.BYTE 0 ;ORDERLIST SEQUENCE PLAYPOSITION-SHOULDN'T BE ON PAGE-BOUNDARY!
PTNPOS	.BYTE 0 ;PATTERN PLAY-POSITION (IN MEMORY)
WFTPOS	.BYTE 0 ;WF-ARP TABLE POSITION-INDEX
PWTPOS	.BYTE 0 ;PW-TABLE POSITION-INDEX
.CWARN *>7+VARIABLES+1*(3*7),"MAXIMUM 7 VARIABLES ALLOWED PER BUNCH!"
*=VARIABLES+2*(3*7) ;ENSURE SPACE FOR 2ND BUNCH OF VARIABLES FOR 3 CHANNELS
ACTPTN	.BYTE 0 ;CURRENT PATTERN
ACTNOT	.BYTE 0 ;ACTUAL NOTES/GATEOFF ON TRACK 0..2 (+FX0, VIB,RING)
DPITCH	.BYTE 0 ;ACTUAL DISCRETE NOTE-PITCH (ISN'T AFFECTED BY EFFECTS)
ACTIFX	.BYTE 0 ;ACTUAL INSTR/ONESHOT-FX ON TRACK 0..2
ACTINS	.BYTE 0 ;ACTUAL (SELECTED) INSTRUMENT - NOT OVERWRITTEN BY FX/LEGATO
ACTFX2	.BYTE 0 ;ACTUAL FX2-NUMBERS ON TRACK 0..2
ACTVAL	.BYTE 0 ;ACTUAL FX2-VALUES ON TRACK 0..2
.CWARN *>7+VARIABLES+2*(3*7),"MAXIMUM 7 VARIABLES ALLOWED PER BUNCH!"
*=VARIABLES+3*(3*7)
SLIDEVIB .BYTE 0 ;SLIDEUP/SLIDEDOWN/PORTAMENTO/VIBRATO-TYPE (EXTRACTED FROM BIT 4..5 OF INSTRUMENT-CONTROL BYTE)
FREQMODL .BYTE 0 ;FREQUENCY-SLIDE (MODIFICATION) LOW BYTE (SET BY INSTRUMENT/PATTERN-FX)
FREQMODH .BYTE 0 ;FREQUENCY-SLIDE (MODIFICATION) HIGH-BYTE (SET BY INSTRUMENT/PATTERN-FX)
VIDELCNT .BYTE 0 ;VIBRATO-DELAY COUNTER (SET BY INSTRUMENT)
VIBFREQU .BYTE 0 ;VIBRATO-FREQUENCIES (SET BY INSTRUMENT/PATTERN-FX)
VIBRACNT .BYTE 0 ;VIBRATO COUNTERS (FOR VIBRATO FREQUENCY HANDLING)
.CWARN *>7+VARIABLES+3*(3*7),"MAXIMUM 7 VARIABLES ALLOWED PER BUNCH!"
*=VARIABLES+4*(3*7)
.IF PACKEDNOPSUPP_ON ;NOT RECOMMENDED TO SWITCH OFF SUPPORT, UNLESS YOU DON'T EVER WANT IT
PACKCNT	.BYTE 0 ;PACKED NOP/REST ($70..$77) COUNTER
.FI		
.IF TRANSPOSESUPP_ON
TRANSP	.BYTE 0 ;TRANSPOSE-AMOUNT ON TRACKS (SET BY SEQUENCE-FX)
.FI		
.IF ARPSPEEDSUPP_ON
ARPSPED	.BYTE 0 ;ARPEGGIO-SPEED (SET BY INSTRUMENT OR PATTERN-FX)
ARPSCNT	.BYTE 0 ;ARPEGGIO-SPEED COUNTERS
.FI		
.IF PWKEYBTRACK_ON
PKBDTRK	.BYTE 0 ;PULSEWIDTH KEYBOARD-TRACK VALUE
.FI		
.IF CHORDSUPPORT_ON
ACTCHORD .BYTE 0 ;ACTUAL CHORDS ON TRACKS (INSTRUMENT/PATT.FX SELECTS IT)
CHORDPOS .BYTE 0 ;PLAYED POSITION (INDEX) OF ACTUAL CHORD IN CHORDTABLE
.FI		
.CWARN *>7+VARIABLES+4*(3*7),"MAXIMUM 7 VARIABLES ALLOWED PER BUNCH!"
*=VARIABLES+5*(3*7)
ENDVARIABLES

CONSTVAR ;CONSTANT VALUES AND MISC.VARIABLES NOT INITED BY INIT-ROUTINE
FLSWTBL	 .BYTE 1 ;.... CONSTANTS-BITMASK FOR SID-FILTERSWITCHES
FLSWTB2  .BYTE $FE ;FILTERSWITCH-AND TABLE (CONSTANTS)
TRKTMPOS .BYTE 2 ;TRACK-TEMPO-POSITION TABLE (CONSTANTNS)
TRDELAY  .BYTE 0 ;TRACK-DELAY AMOUNTS 
SUBTJUMP .BYTE 0 ;signs if subtune-jumping is needed (if value was set to nonzero)
SEQTEMPO .BYTE 0 ;SEQ-FX TEMPOCHANGE DELAYER
TRANSP2	 .BYTE 0 ;DELAYED TRANSPOSE-VALUE (BECAUSE SEQ-FX DOES IT EARLY
		 .BYTE 2,$FD,4,0,0,0,0, 4,$FB,6,0,0,0,0

;******************************************************************************
INITER	;INITIALIZE SUBTUNE (INPUT: SUBTUNE-NUMBER IN ACCU.)
a1      JSR SETSTUNE    ;SET SUBTUNE GIVEN IN ACCU (ADDR,SPD)
INIPVAR	LDY #(ENDVARIABLES-VARIABLES)-1
-		LDA #8 ;WRITING TEST-BITS PREVENTS SOUND-POP AT INIT?
		STA SIDBASE,Y ;INIT SID (X CAN BE OVER $20 ON A STOCK C64)
		LDA #0 ;ZERO ALL COUNTERS & POINTERS & ROWDATA, ETC.
a2		STA VARIABLES,Y 
		DEY
		BPL - ;ACCU MUST BE 0 WHEN THIS LOOP ENDS
a3		STA FLTBAND+1 ;RESET FILTER-BAND REGISTER BITS
.IF FILTKBTRACK_ON
a1b		STA CKBDTRK+1 ;INIT FILTER-KEYBOARD TRACK, AS NOT NEEDED IF NO FILTER USED
.FI	
INITVOL	LDA #15 ;MAX. VOLUME VALUE
a4		STA MAINVOL+1
a73		STA SEQVOLU+1
a5		STA FLTCTRL+1 ;NOT IN 0..2 RANGE - NO FILTER FOR ANY CHANNEL ON INIT
INITPTN	LDX #2*7
-		
		LDA #0
a21		STA TRANSP2,X
a22		STA SEQTEMPO,X
.IF SUBTUNEJUMP_ON
a85b	STA PTNPOS,X ;RESET PATTERN-POSITIONS
a86b	STA TMPPOS,X ;RESET TEMPO-POSITIONS
a87b	STA TMPPTR,X ;RESET TEMPO-PROGRAM POINTERS
a88b	STA SEQPOS,X ;RESET SEQUENCE-POSITIONS
a89b	STA SUBTJUMP ;RESET SUBTUNE-JUMPING SIGNAL TO ZERO
.FI		
StrtPos	LDY #0	;set to nonzero by editor if playing from position with F2
.IF COMPILEDAPP=1
		beq SEQFXLO ;if F2-key initiated the start
		lda div7chn,X ;convert (divide) 0..7..14 to 0..1..2 
		tay
		lda olstart,y
		sta SEQPOS,X
		TAY
		beq SEQFXLO ;cannot be jump-address at the beginning
		dey
		jsr SEQSUB ;examine previous value, if $ff, we're on jump-address not on pattern-number
		cmp #$ff  ;if there's a jumpposition at the marker don't set pattern
		beq +
		iny
.FI		
SEQFXLO	JSR SEQSUB ;GET PATTERNS AT 1ST POSITIONS OF SEQUENCES    
.IF COMPILEDAPP=1
		beq + ;if zero pattern-number somehow, don't set it
		bmi goforFX
        cmp #maxptnamount+1
        bcc INIPTN ;if not legal pattern, don't set
		bcs + ;jump
goforFX	;...check above $80
.ELSE
		BPL INIPTN ;IF 1ST POSITION IS NOT PATTERN, LEAVE IT OR PERFORM SEQ-FX
.FI
		CMP #$FE ;IF DELIMITER AT 1ST POSITION, DON'T SET PATTERN
		BCS + ;IF LOWER THAN $FE, PERFORM ORDERLIST-EFFECTS
a6		JSR SEQ_FX ;HANDLE ORDERLIST/SEQUENCE-FX, INPUT:A, DOESN'T DISTURB X&Y
		INY ;GO TO NEXT SEQUENCE-POSITION
		TYA
a7		STA SEQPOS,X
		BNE SEQFXLO ;AVOID ENDLESS LOOP
INIPTN	STA ACTPTN,X ;SET PATTERNS
		+
.IF DELAYSUPPORT_ON
		LDA #$FF
a2b		STA TRDELAY,X ;PREPARE POSSIBLE UPCOMING TRACK-DELAY
.FI		
		TXA
		SEC
		SBC #7 ;CYCLE SID-CHANNELS
		TAX
		BPL -
		RTS

;******************************************************************************
PLAYER	
.IF ZEROPAGESAVE_ON
		LDA PLAYERZP+0 ;STORE ZEROPAGE  ;SINGLE-SPEED PLAYING
		PHA
		LDA PLAYERZP+1
		PHA
.FI
CHANCNT	LDX #2*7 ;CHANNEL 1
a8		JSR DOTRACK
		LDX #1*7 ;CHANNEL 2
a9		JSR DOTRACK
		LDX #0*7 ;CHANNEL 3
a10		JSR DOTRACK

.IF SUBTUNEJUMP_ON
a90b	LDA SUBTJUMP ;CHECK, IF SUBTUNE-JUMP WAS INITIATED
		BEQ + ;IF NO SUBTUNE-JUMPING WAS INITIATED
		AND #$7F ;IF ABOVE $80, JUMP TO SUBTUNE - $81=SUBTUNE1,$82=SUBTUNE2,ETC. UP TO MAX. SUBTUNE
a91b	JSR SETSTUNE ;SET SUBTUNE-POINTERS
a92b	JSR INITPTN ;RESET PATTERNS
		LDA #0
a93b	STA SUBTJUMP ;RESET TO PREVENT IMMEDIATE FURTHER ACTION
		+
.FI		
COMMONREGS ;CALCULATING AND WRITING COMMON SID REGISTERS - ENTRY POINT FOR EDITOR
FSWITCH	LDA #$08 ;SELF-WRITTEN - TRACKS' FITER-SWITCHES' NIBBLE (EXTERNAL FILTER ON TO REDUCE CONSTANT SID-NOISE)
RESONIB	ORA #0 ;SELF-WRITTEN - RESONANCE-NIBBLE OF FILTER (UPPER 4 BITS)
		STA SIDBASE+$17
MAINVOL	LDA #$0F ;SELF-WRITTEN CODE - MAIN VOLUME NIBBLE OF $D418
FLTBAND	ORA #0 ;SELF-WRITTEN, FILTERBAND-GHOSTREGS MUST BE HERE (ON HI-NIBBLE)
		STA SIDBASE+$18
		CLC ;PRE-SET CARRY FOR ADDITIONS
.IF FILTKBTRACK_ON
CKBDTRK	LDA #0 ;SELF-WRITTEN - KEYBOARD-TRACK EFFECT AMOUNT (MULTIPLY/DIVIDE) IF 0, NO EFFECT
		BEQ CTFHGHO ;IF 0, NO KEYBOARD-TRACKING
a3b		LDX FLTCTRL+1 ;X = ACTUAL FILTER-CONTROLLER TRACK
a4b		ADC DPITCH,X ;ACTUAL FILTER-CONTROLLER TRACK'S NOTE-NUMBER ;THE ADDITION (OR SUBSTRACTION IF A>$80) 
		TAY
a5b		LDA EXPTABH,Y ;USE EXPONENT TABLE AS QUASY MULTIPLY/DIVIDE FUNCTION BASED ON CKBDTRK
CTFHGHO	ADC #0 ;SELF-WRITTEN - HIGH BYTE OF FILTER CUTOFF-FREQUENCY
.ELSE	
CTFHGHO	LDA #0 ;SELF-WRITTEN - HIGH BYTE OF FILTER CUTOFF-FREQUENCY
.FI		
FLSHIFT	ADC #0 ;PATTERN-FX INITIATED FILTER-SHIFTING
		STA SIDBASE+$16
.IF COMPILEDAPP=1
		STA CTFMETR+1 ;EASE CUTOFF-METER DISPLAY FOR EDITOR
.FI
.IF FINEFILTSWEEP_ON
CTFLGHO	LDA #0 ;SELF-WRITTEN - LOW NIBBLE OF FILTER CUTOFF-FREQUENCY
		STA SIDBASE+$15 ;FOR RASTERTIME REASONS LOW-BITS OF CUTOFF IS NOT KEYBOARD-TRACKED 
.FI		 
RETPLAY ;RETURN FROM PLAYER
.IF ZEROPAGESAVE_ON
		PLA ;RESTORE ZEROPAGE
		STA PLAYERZP+1
		PLA
		STA PLAYERZP+0
.FI		
		RTS


;******************************************************************************
MULPLY	;MULTISPEED-PLAYING ROUTINE
.IF ZEROPAGESAVE_ON
		LDA PLAYERZP+0 ;STORE ZEROPAGE  ;SINGLE-SPEED PLAYING
		PHA
		LDA PLAYERZP+1
		PHA
.FI		
		LDX #2*7 ;CHANNEL 1
a11		JSR MULCNTP ;PLAY INSTRUMENT-TABLE(S)
		LDX #1*7 ;CHANNEL 2
a12		JSR MULCNTP ;PLAY INSTRUMENT-TABLE(S)
		LDX #0*7 ;CHANNEL 3
a13		JSR MULCNTP ;PLAY INSTRUMENT-TABLE(S)
a14		JMP COMMONREGS ;PLAY FILTER TOO ;JMP RETPLAY	;RESTURN FROM MULTISPEED-PLAYER PART
;--------------------
MULCNTP	LDY ACTINS,X  ;PUT CURRENT INSTRUMENT'S BASE-ADDRESS TO ZEROPAGE-POINTERS
p_insl1	LDA INSPTLO,Y ;Y IS NUMBER OF CURRENT INSTRUMENT
		STA PLAYERZP+0
p_insh1	LDA INSPTHI,Y
		STA PLAYERZP+1
		LDY #7 ;CHECK ARPSPEED DATA OF ACTUAL INSTRUMENT (BIT 6 & 7)
		LDA (PLAYERZP),Y
		BMI MULTIFI ;IF INSTRUMENT-ARPEGGIO SPEED IS BIGGER THAN $80 (BIT7=1), MULTISPEED FILTER TOO
		AND #$40 ;IF BIT6=1, PULSEWIDTH IS MULTISPEED TOO
		BNE MULTIPW ;IF SPEED BIT6=1
a15		JMP WFARPTB ;MULTISPEED SUPPORT ONLY FOR WAVEFORM-TABLE
MULTIPW	JMP SETPWID ;MULTISPEED SUPPORT FOR PULSEWIDTH-TABLE TOO
MULTIFI	JMP FLTCTRL ;MULTISPEED SUPPORT FOR PULSEWIDTH-TABLE AND FILTERTABLE TOO


;******************************************************************************
DOTRACK	
.IF TEMPOPRGSUPP_ON
a6b		LDY TMPPOS,X ;HANDLE TEMPO (SUBTUNE-TEMPO/FUNKTEMPO/TEMPO-PROGRAM)
.FI		
a16		LDA SPDCNT,X
.IF TEMPOPRGSUPP_ON
		INY ;PREPARE Y FOR ADVANCE IN TEMPOTABLE
.FI		
		SEC
		;tempoprogram-table base-address to adjust in SID-maker
.IF TEMPOPRGSUPP_ON
p_tmpt1	SBC TEMPOTBL-1,Y ;COMPARE SPEED-COUNTER TO ACTUAL TEMPO, AND CHECK BIT 7
.ELSE	
p_tmpt1	SBC TEMPOTBL+0 ;SINGLETEMPO
.FI		
		BEQ a17 ;IF EQUAL, GO TO ADVANCE IN TEMPO-PROGRAM
		BVC a18  ;CHECK FOR $80 RESULT TOO. IF NOT MATCH, GO TO REST OF TICKS
.IF TEMPOPRGSUPP_ON
a9b		LDY TMPPTR,X ;SPDCNT=TEMPO-80, GET ACTUAL TEMPO-PROGRAM'S POSITION
.FI		
		LDA #0 ;HERE WE SET ACCU (TEMPOCOUNTER) TO 0 TO GET NEXT ROW
a17		STA SPDCNT,X ;ZERO SPEEDCOUNTER,INCREMENTED SOON TO 1 (IN THIS FRAME)
.IF TEMPOPRGSUPP_ON
		TYA ;Y HERE IS EQUAL TO THE TEMPOTABLE POINTER WE WOULD SET
a10b	STA TMPPOS,X ;THEN RETURN BACK TO START OF TEMPOPROGRAM (SET TEMPOCNT)
.FI		
a18		LDA SPDCNT,X ;CHECK SPECIAL TICKS (SPDCNT IS IN 0..TEMPO RANGE)
a19		INC SPDCNT,X  ;INC SPEEDCOUNTERS TO STEP FORWARD 1 TICK
TICKSEL	CMP #0
		BEQ TICK_0 ;CHECK FOR TICK 0 (BRANCH IF SPDCNT = 0 )
a20		JMP CHKTCK1 ;CHECK IF TICK1


;------------------------------------------------------------
TICK_0	LDY ACTPTN,X ;PUT CURRENT PATTERN'S ADDRESS TO ZEROPAGE-POINTERS
p_ptnl1	LDA PPTRLO,Y ;Y IS NUMBER OF CURRENT PATTERN
		STA PLAYERZP+0
p_ptnh1	LDA PPTRHI,Y
		STA PLAYERZP+1 
READROW	LDA #0
a23		STA ACTIFX,X ;ENSURE ONE-SHOT INSTRUMENT-SELECTION/SMALL-FX
a24		STA ACTFX2,X ;ENSURE ONE-SHOT SMALL-/BIG-FX
SEQVOLU	LDA #$0F ;SELF-WRITTEN - USED TO DELAY SETTING OF MAIN-VOLUME SEQ.FX
a74		STA MAINVOL+1
.IF TEMPOPRGSUPP_ON
a61b	LDA SEQTEMPO,X ;PERFORM TRACK-TEMPO SEQ.FX (DELAYED)
		BEQ +
a62b	JSR TRAKTMP ;SET TRACK-TEMPO
		LDA #0
a106b	STA SEQTEMPO,X
		+
.FI
.IF CHEATRASTERTIME=1
		cpx #0   ;this cheat is needed to better estimate rastertime of output
		bne +
		stx $d020 ;because the orderlist sprites eat CPU cycles from playercode, increasing rastertime in editor
		+
.FI		
a25		LDY PTNPOS,X  ;READ CONTENT OF ACTUAL PATTERN-ROW-----------
.IF PACKEDNOPSUPP_ON ;NOT RECOMMENDED TO SWITCH OFF SUPPORT, UNLESS YOU DON'T EVER WANT IT
a11b	LDA PACKCNT,X ;HANDLE PACKED NOP (DECREMENT PACK-COUNTER AND SKIP READING)
		BNE PACKNOP ;IF PACKED NOP COUNTER IS NONZERO, DECREASE IT.
.FI		
CHNOTEC	LDA (PLAYERZP),Y ;READ ACTUAL NOTE FROM NOTE-COLUMN 
.IF PACKEDNOPSUPP_ON ;NOT RECOMMENDED TO SWITCH OFF SUPPORT, UNLESS YOU DON'T EVER WANT IT
		CMP #PACKEDMIN ;CHECK PACKED NOP, STORE 0 IN ACTNOT,X FOR IT AND SET PACK-COUNTER!
		BCC NOPACKR ;IF A < PACKEDMIN
		CMP #PACKEDMAX+1
		BCS NOPACKR ;IF A > PACKEDMAX
		SEC ;A IS IN PACKED NOP RANGE
		SBC #PACKEDMIN-2 ;CHANGE RANGE $70..$77 TO $1..$8
a12b	STA PACKCNT,X ;store repeater amount in X
PACKNOP	DEC PACKCNT,X
		LDA #$00 ;PUT 'NOP' INTO ACCU IF PACKED REST IS EXECUTED 
NOPACKR	CMP #0 ;RE-TEST ACCU BIT 7
.FI		;END OF CHECKING PACKED NOP SUPPORT
		BMI + ;IF NOTE ABOVE $80 GO TO CHECK NEXT COLUMN
a26		STA ACTNOT,X
a27		JMP SETPPOS ;IF NOTE BELOW $80, END OF ROW
+		AND #$7F ;ELIMINATE BIT7
a28		STA ACTNOT,X
		INY ;CHECK FOR INST-SELECTION/SMALL-FX
CHINSTC	LDA (PLAYERZP),Y ;READ ACTUAL INST/SMALL-FX
		BMI + ;IF INST/FX BELOW $80, END OF ROW
a29		STA ACTIFX,X ;LATER SEPARATE INSTRUMENT ($1..$3F) FROM SMALL-FX ($3F..$7F)
a30		JMP SETPPOS
+		AND #$7F ;ELIMINATE BIT7
a31		STA ACTIFX,X
+		INY ;CHECK FOR BIG-FX
CHFXCOL	LDA (PLAYERZP),Y ;READ ACTUAL SMALL-/BIGFX
a32		STA ACTFX2,X
		AND #$E0
		BNE SETPPOS ;IF ABOVE $1F (SMALLFX), END OF ROW
		INY ;BIG-FX BRANCH
CHFXVAL	LDA (PLAYERZP),Y ;READ ACTUAL EFX-VALUE (BIG-FX)
a33		STA ACTVAL,X
SETPPOS	TYA
a34		STA PTNPOS,X
.IF FASTSPEEDBIND_ON
CHKTMP1	LDY TMPPOS,X  ;CHECK IF TEMPO IS NOT BIGGER THAN 1
p_tmpt2	LDA TEMPOTBL,Y
		AND #$7F
		CMP #2
		BMI PTN_SEQ ;IF TEMPO IS NOT BIGGER THAN 1, DON'T DO HR2 BUT HANDLE PATTERN & SEQUENCE
.FI		
.IF HARDRESTYPES_ON
		LDA #2 ;SIGN TICK2 TO HARDRESTART-ROUTINE
.FI		
HARDRST	LDY ACTNOT,X ;CHECK FOR 2 FRAME LONG HARD-RESTART ;CHECK IF NOTE COMES AT ALL
		BEQ NONEWNO ;IF NO NEW NOTE STARTING, NO HARD-RESTART PERFORMED
		CPY #$60 ;CHECK IF NOTE-FX (BIGGER THAN $60)
		BCC NEWNOTE ;IF NOTE-FX, DON-T PERFORM HARDRESTART
NONEWNO	JMP CNTPLAY ;NO NEED TO PREPARE NEXT NOTE HERE, SIMPLY PLAY ACTUAL NOTE
NEWNOTE	LDY ACTFX2,X ;ACTUAL BIG EFFECT
		CPY #$03 ;CHECK IF PORTAMENTO IS BEING EXECUTED
		BEQ NONEWNO
a219	LDY ACTIFX,X ;THERE IS A MUSICAL NOTE, EXAMINE INSTRUMENT-COLUMN
.IF HARDRESTYPES_ON
		BEQ a13b ;IF NOP ($00), GO TO USE PREVIOUSLY SELECTED INSTRUMENT FOR HARD RESTART
.FI		
		CPY #$3F ;HARDWIRED VALUE OF LEGATO, CARRY BIT AFFECTED
		BEQ NONEWNO ;IF LEGATO, NO HARD-RESTART PERFORMED 
.IF HARDRESTYPES_ON
		BMI + ;IF INSTRUMENT SELECTION (SMALLER THAN $3F)
a13b	LDY ACTINS,X ;IF NOP OR INST.FX, USE PREVIOUSLY SELECTED INSTRUMENT
+		PHA ;STORE HR-TICK-TIMER-NUMBER
p_insl2	LDA INSPTLO,Y ;Y IS NUMBER OF CURRENT INSTRUMENT
		STA PLAYERZP+0
p_insh2	LDA INSPTHI,Y
		STA PLAYERZP+1
		PLA ;RESTORE HR-TICK-TIMER-NUMBER
ISHARDR	LDY #0 ;GET CONTROL BYTE OF UPCOMING INSTRUMENT
		AND (PLAYERZP),Y ;EXTRACT 2 FRAME HARD-RESTART SWITCH-BIT
		BNE + ;BRANCH IF 2 FRAME LONG HARDRESTART, ELSE DON'T PERFORM HR YET, BUT SKIP PW/FILT
a14b	LDY ACTINS,X  ;PUT CURRENT INSTRUMENT'S BASE-ADDRESS TO ZEROPAGE-POINTERS
p_insl3	LDA INSPTLO,Y ;Y IS NUMBER OF CURRENT INSTRUMENT
		STA PLAYERZP+0
p_insh3	LDA INSPTHI,Y
		STA PLAYERZP+1
a15b	JMP WFARPTB ;CNTPLAY2 ;SKIP PULSEWIDTH-FILTER-TABLES AND VIBRATO IF NEW NOTE COMES BUT NO HR
+		LDA (PLAYERZP),Y ;Y=0 HERE
		AND #4 ;EXTRACT GATE-OFF HARD-RESTART SWITCH
		BEQ + ;IF NOT SET, DON'T PERFORM HARD RESTART ON WAVEFORM-REGISTER
		LDA #$FE
a16b	STA PTNGATE,X ;WF-ARP TABLE MUTING
a17b	AND WFGHOST,X
		ORA #8 ;SWITCH ON TEST-BIT
a18b	STA WFGHOST,X
+		INY ;Y=1
		LDA (PLAYERZP),Y ;GET HR-AD
		STA SIDBASE+5,X
		INY ;Y=2
		LDA (PLAYERZP),Y ;GET HR-SR
		STA SIDBASE+6,X
.ELSE ;IF ONLY DEFAULT HARDRESTARTVALUE SELECTED
		LDA #>DEFAULTHRADSR ;$0F?
		STA SIDBASE+5,X
		LDA #<DEFAULTHRADSR ;$F0?
		STA SIDBASE+6,X
.FI		;END OF CHECKING IF HARDRESTART-TYPE AND HR-ADSR IS THE SAME FOR ALL INSTRUMENTS
a35		JMP WRGHOST ;WRITE SID-REGISTERS (WAVEFORM-CONTROL)


;-----------------------------------------------------------
CHKTCK1	CMP #2
		BPL CHKTCK2 ;CHECK FOR TICK 1 (BRANCH IF SPDCNT>1)
TICK_1	LDY ACTPTN,X ;PUT CURRENT PATTERN'S BASE-ADDRESS TO ZEROPAGE-POINTERS
p_ptnl2	LDA PPTRLO,Y ;Y IS NUMBER OF CURRENT PATTERN
		STA PLAYERZP+0
p_ptnh2	LDA PPTRHI,Y
		STA PLAYERZP+1
PTN_SEQ	LDY PTNPOS,X ;FETCH PATTERN-POSITION TO Y
.IF TRANSPOSESUPP_ON
a104b	LDA TRANSP2,X ;PERFORM TRANSPOSE-SEQ.FX
a105b	STA TRANSP,X ;DELAYER TO COMPENSATE EARLY SEQ.FX
.FI
.IF CHEATRASTERTIME=1
		cpx #0   ;this cheat is needed to better estimate rastertime of output
		bne +
		stx $d020 ;because the orderlist sprites eat CPU cycles from playercode, increasing rastertime in editor
		+
.FI		
.IF PACKEDNOPSUPP_ON ;NOT RECOMMENDED TO SWITCH OFF SUPPORT, UNLESS YOU DON'T EVER WANT IT
a19b	LDA PACKCNT,X ;HANDLE PACKED NOP (IF COUNTING, DON'T ICREMENT PTNPOS,X)
		BNE SETPPO2 ;IF PACKED NOP COUNTER IS NONZERO, STAY IN PLACE
.FI		
		INY
		LDA (PLAYERZP),Y ;READ NEXT ROW 1ST BYTE, TO CHECK PATTERN-END
		CMP #$FF ;HARDWIRED PTTERN-DELIMITER (PATTERN-END)
		BNE SETPPO2 ;IF NOT END OF PATTERN, JUST STORE PTNCNT 
ptncode	LDY SEQPOS,X ;editor manipulates this opcode & operand to accomplish pattern-playing (JMP PTNPLAY)
SEQFXLP	INY ;RETURN POINT FOR CONTINUOUS SEQUENCE-EFFECT CHECKING
SEQFXL2	JSR SEQSUB ;READ NEXT DATA FROM SEQ (ORDERLIST)
		BPL SETPNUM ;IF BELOW $80, JUST GO SETTING SEQPOS & PATTERN-NUMBER NORMALLY
		CMP #$FE ;HARDWIRED SEQUENCE-DELIMITER (END)
		BNE +
a36		DEC SPDCNT,X ;KEEP IT AWAY FROM COUNTING-UP
a37		JMP CNTPLAY ;CYCLECH ;IF $FE THEN END OF PLAYING (COUNTER STOPS AT '1' FOR TRACK)
+		CMP #$FF ;HARDWIRED SEQUENCE-DELIMITER (JUMP/LOOP)
		BEQ LOOPSEQ ;IF NO FF AND ABOVE &80, DO SEQUENCE-FX (TRANSPOSE/REPEAT/ETC.)
a38		JSR SEQ_FX ;ACCU ABOVE $80 & BELOW $FE: HANDLE ORDERLIST/SEQUENCE-FX
		INY
a72		JSR SEQSUB ;CHECK NEXT VALUE IN SEQUENCE
		CMP #$FF ;IF $FF-COMMAND DIRECTLY AFTER SEQ-FX, DON'T ALLOW LOOPING (SAFETY CHECK TO PREVENT FREEZE)
		BEQ PTNPLAY ;SETSPOS ;IF ILLEGAL SEQFX-$FF SEQUENCE FOUND, SKIP LOOPING
a39		JMP SEQFXL2 ;GO BACK TO CHECK IF DELIMITER/SEQ-FX AT NEXT POSITION
LOOPSEQ	INY ;LOOP SEQUENCE TO GIVEN POSITION (AFTER $FF DELIMITER)
a40		JSR SEQSUB ;READ SEQ JUMP-ADDRESS (NEXT DATA IN ORDERLIST)
.IF SUBTUNEJUMP_ON
		BPL + ;IF SIMPLE JUMP-ADDRESS BELOW $80
a94b	STA SUBTJUMP ;CAUSE SUBTUNE-JUMPING IN PLAYER'S MAIN PART
		LDA #0
		+
.FI		
		TAY
a41		JMP SEQFXL2 ;AND ALSO READ THIS POSITION'S PTN-NUMBER/SEQ.FX
SETPNUM STA ACTPTN,X ;SET PATTERN-NUMBER TO ACCU
SETSPOS	TYA
a42		STA SEQPOS,X ;AND SET SEQ-POS TO 
PTNPLAY	LDY #0
SETPPO2	TYA
a43		STA PTNPOS,X
.IF FASTSPEEDBIND_ON
CHKTMP2	LDY TMPPOS,X ;CHECK IF TEMPO IS NOT BIGGER THAN 2
p_tmpt3	LDA TEMPOTBL,Y
		AND #$7F
		CMP #3
		BMI TICK_2 ;IF TEMPO IS NOT BIGGER THAN 2, DON'T DO HR1 BUT HANDLE NOTE/INS/FX
.FI
.IF HARDRESTYPES_ON		
HRDR1FR	LDA #1 ;STORE HR-TICK-TIMER-NUMBER
.FI		
a44		JMP HARDRST ;JUMP TO HARD-RESTART CHECKER & PERFORMER ROUTINE


;--------------------------------------------------------------------------------------
CHKTCK2	BEQ TICK_2 ;COMPARE SPDCNT,X TO '2'
a45		JMP CNTPLAY ;HERE SPDCNT<>2, REST OF THE TICKS (ONLY CNTPLAY)
TICK_2
.IF (PWRESETSW_ON+FILTRESETSW_ON)
		LDY #%11111111 ;SIGN LATER IF SELECTION OF INSTRUMENT HAPPENED OR NOT
.FI		
a46		LDA ACTIFX,X ;CHECK INST/FX COLUMN
		BEQ CHKNOTE ;IF NOP, NOTHING TO DO
		CMP #maxinstamount ;CHECK IF NORMAL INSTRUMENT (BELOW $3F)
		BPL CHKNOTE ;IF Y > MAX.INST.AMOUNT, SKIP INST.SELECTION
SEL_INS	STA ACTINS,X ;SELECT INSTRUMENT IF Y IS IN RANGE 1..MAX.INST
.IF (PWRESETSW_ON+FILTRESETSW_ON)
		LDY #%00111111 ;CAUSE FILTER&PW-TABLE TO RESET AT INSTRUMENT-SELECTION
CHKNOTE	STY TABLRST+1 ;SIGN FOR PW/CTF RESETTER IF INSTRUMENT WAS JUST SELECTED
.ELSE	
CHKNOTE	;
.FI		
.IF CHEATRASTERTIME=1
		cpx #0   ;this cheat is needed to better estimate rastertime of output
		bne +
		stx $d020 ;because the orderlist sprites eat CPU cycles from playercode, increasing rastertime in editor
		+
.FI		
a47		LDY ACTINS,X  ;PUT CURRENT INSTRUMENT'S BASE-ADDRESS TO ZEROPAGE-POINTERS
		BNE STRTINS ;ONLY PERFORM REST OF TICK2 IF ANY INSTRUMENT IS SELECTED, SAVE RASTERTIME
		RTS ;JMP RETRACK
STRTINS	;ENTRY POINT USED BY PLAYADAPTER TO SET INSTRUMENT
p_insl4	LDA INSPTLO,Y ;Y IS NUMBER OF CURRENT INSTRUMENT
		STA PLAYERZP+0
p_insh4	LDA INSPTHI,Y
		STA PLAYERZP+1
		
COLUMN1	LDA ACTNOT,X ;CHECK NOTE COLUMN
		BNE + ;IF NOP, NO NOTE-FX, CHECK FOR INSTRUMENT-/PATTERN-FX
a48		JSR INSPTFX ;INST/PATTERNFX. (nothing (NOP) was in note-column)
a49		JMP CNTPLY2 ;SKIP POINTER-SETTING (WAS SET IN THIS TICK)		
+		CMP #$60 ;CHECK IF NORMAL NOTE (BELOW $60)
		BMI CLEGATO ;IF A < $60 CHECK FOR LEGATO, IF A >= $60 DO NOTE-FX THEN INS/PTN-FX
a50		JSR NOTE_FX ;HANDLE NOTE/INS./PATTERN-EFFECTS, INPUT: ACCU
a51		JMP CNTPLY2
CLEGATO	CLC ;SETTING NOTE-PITCH FIRST BASED ON ACTNOT,X LOADED TO ACCU PREVIOUSLY
.IF OCTAVESHIFT_ON
		LDY #9 ;INDEX OF OCTAVE-SHIFT OF INSTRUMENT
		ADC (PLAYERZP),Y 
.FI		
.IF TRANSPOSESUPP_ON
		CLC
a20b	ADC TRANSP,X ;ADD 2'S COMPLEMENT TRANSPOSE-VALUE (SET BY SEQUENCE-FX)
.FI		
a52		STA DPITCH,X ;DISCRETE PITCH (0..$5F)
		
		LDA #$03 ;PORTAMENTO-BIGFX-VALUE?
a53		CMP ACTFX2,X ;CHECK IF PORTAMENTO-EFFECT IN THE ROW
		BEQ JMPLEGA ;IF PORTAMENTO, NO INITIALIZATION OF SOUND NEEDED
a218	ADC SLIDEVIB,X ;CHECK IF NOTE-FX PORTAMENTO ($FF) WAS INITIATED BEFOREHANDS
		BCS SETPRTA ;IF YES, DO TONE-PORTAMENTO (SPEED ALREADY CALCULATED BY PORTAMENTO NOTE-FX)
CHILEGA	LDA #$3F ;CHECK IF ACTIFX WAS $3F "LEGATO"
a54		CMP ACTIFX,X ;CHECK ACTIFX (WITHOUT BIT 7), GET LEGATO INFO
		BNE STRTSND ;IF NO LEGATO AND NO PORTAMENTO, NORMAL SOUND-START 
SETLEGA	LDA #$7F ;BIG SPEED FOR PORTAMENTO IS EQUAL TO LEGATO
a55		STA FREQMODH,X ;MAXIMAL PORTAMENTO-SLIDE
SETPRTA	LDA #$83 ;HANDLE NOTE-PITCH SETTING FOR LEGATO!!!
a56		STA SLIDEVIB,X ;SET PORTAMENTO
JMPLEGA	JMP LEGATOO ;IF $3F, TIED NOTE (LEGATO/HAMMER-ON), SKIP SOUND-INIT

STRTSND	;STARTING THE SOUND - INIT ADSR, WAVEFORM-ARP, PULSEPROGRAM, FILTERPROGRAM, ETC.
		LDY #0  ;INIT INSTRUMENT COUNTERS/POINTERS
a68		STY FLSHIFT+1 ;RESET FILTER-SHIFTING EFFECT ON NEW NOTE
		;READ CONTROL-BYTE OF INSTRUMENT FROM INDEX 0
		LDA (PLAYERZP),Y ;(bit0-1:HRtimer,bit2:HRgateoff,bit3:TestbitHR,bit4-5:vib.type,bit6:pulseresetOFF,bit7-filtresetOff) 
.IF (PWRESETSW_ON+FILTRESETSW_ON)
TABLRST	AND #$3F ;%00111111 ;SELF-WRITTEN - IF INSTRUMENT SELECTED, CAUSES TABLES TO RESET
.FI		
a57		STA INSCTRL+1  ;STORE IT FOR LATER USES
		AND #$30
a58		STA SLIDEVIB,X ;VIBRATO-CONTROL PART OF INSTRUMENT-CONTROL REGISTER
.IF PWRESETSW_ON
a21b	LDA INSCTRL+1 ;CHECK BIT6 - IF PW-RESET IS OFF FOR INSTRUMENT AND NO INST.SELECTION / MODIFICATION
		AND #$40 ;BIT6 - PW RESET SWITCH
		BNE CHFLRST
.FI		
SETPWTP	LDY #$0A		 ;RESET PWTABLE COUNTER
		LDA (PLAYERZP),Y
a59		STA PWTPOS,X
CHFLRST	
.IF FILTRESETSW_ON
a22b	LDA INSCTRL+1 ;INST.CONTROL BYTE
		BMI SETADSR ;CHECK BIT7 - IF CTF-RESET IS OFF FOR INSTRUMENT AND NO INST.SELECTION /MODIFICATION
.FI		
SETFLTP	LDY #$0B		 ;RESET CTFTABLE COUNTER
		LDA (PLAYERZP),Y
		TAY
		LDA (PLAYERZP),Y ;READ FROM 1ST ROW OF FILTERTABLE 
		BEQ SWONFLT ;IF $00 IN 1ST ROW, INSTRUMENT IS FILTERED BUT DOESN'T CONTROL FILTER 
		CMP #$FF ;IF $FF, INSTRUMENT NOT FILTERED, SWITCHING FILTERSWITCH ON/OFF 
		BEQ SWOFFLT
a60		STX FLTCTRL+1 ;MAKE ACTUAL INSTRUMENT THE FILTER-CONTROLLER FOR SID
a61		STY FLTPOSI+1
SWONFLT	LDA FLSWTBL,X 
a62		ORA FSWITCH+1 ;SWITCH ON SID-FILTER FOR INSTRUMENT (CHANNEL) - 'OR' BIT IN SWITCH-BIT TABLE
		BNE a64 ;JMP +
SWOFFLT	LDA FLSWTB2,X 
a63		AND FSWITCH+1 ;SWITCH OFF SID-FILTER FOR INSTRUMENT (CHANNEL) - 'XOR' BIT IN SWITCH-BIT TABLE
a64		STA FSWITCH+1
SETADSR	LDY #3 ;AD
		LDA (PLAYERZP),Y ;READ 'ATTACK/DECAY'
		STA SIDBASE+5,X ;ADTEMP - ALLOW PATTERN-FX
		INY ;4 ;SR
		LDA (PLAYERZP),Y
		STA SIDBASE+6,X ;SRTEMP - ALLOW PATTERN-FX
INSCTRL	LDA #0 ;SELF-WRITTEN, INSTRUMENT-CONTROL BYTE STORED 
.IF FRAME1SWITCH_ON ;CHECK IF SEXY-HARDRESTART SWITCH DISABLED
		AND #8 ;1ST WAVEFORM-SETTING (SEXY TESTBIT-START IF ON)
		BEQ SETWFTP ;IF ZERO, DON'T INIT WAVEFORM-REGISTER
SETWFR1	LDY #WFTABLEPOS+0
		ORA (PLAYERZP),Y ;SET TEST-BIT (ORA #8) FOR 1ST FRAME
		BPL + ;IF ABOVE $80, HANDLE NOISE WAVEFORM DIFFERENTLY, WITH HARDER RESTART
		LDA #$01 ;AND #$01 ;CADAVER SAYS THAT $01 IS BETTER THAN $09/$89 AS 1ST FRAME WAVEFORM FOR NOISE
		+
.ELSE ;IF SEXY-HARDRESTART SWITCH DISABLED
		LDA #9 ;SIMPLER, ALWAYS 9 AT FRAME 1
.FI		
a65		STA WFGHOST,X ;1ST FRAME WAVEFORM
SETWFTP	LDA #WFTABLEPOS  ;RESET WFTABLE COUNTER
a66		STA WFTPOS,X
		LDA #$FF
a67		STA PTNGATE,X
.IF ARPSPEEDSUPP_ON
a23b	STA ARPSCNT,X
		LDY #7 ;ARPSPEED OF INSTRUMENT
		LDA (PLAYERZP),Y
a24b	STA ARPSPED,X
.FI		
.IF CHORDSUPPORT_ON
SETCHDP	LDY #8 ;DEFAULT CHORD FOR INSTRUMENT
		LDA (PLAYERZP),Y
a25b	STA ACTCHORD,X
		TAY
p_chdp1	LDA CHDPTRLO,Y ;GET CHORD-BASEPOINTER
a26b	STA CHORDPOS,X ;SET BASE-INDEX OF CHORD IN CHORDTABLE
.FI		
INSTVIB	LDY #6  ;READ VIBRATO-DELAY/INCREMENT AMOUNT FROM INSTRUMENT-DATA
		LDA (PLAYERZP),Y
a69		STA VIDELCNT,X ;MAX.$7F, COUNTS BACK TILL $FF
		LDY #5 ;INDEX TO VIBRATO FREQUENCY AND AMPLITUDE INSTRUMENT-DATA
		LDA (PLAYERZP),Y
a210	JSR SETVIBR ;SET VIBRATO-AMPLITUDE AND FREQUENCY AND FREQ.COUNTER

LEGATOO	JSR INSPTFX ;INST/PATTERNFX. (WASN'T FX in note-column)

a71		JMP WRGHOST ;WRITE SID-REGISTERS (WAVEFORM-CONTROL)


;------------------------------------------------------------------------
CNTPLAY	LDY ACTINS,X  ;PUT CURRENT INSTRUMENT'S BASE-ADDRESS TO ZEROPAGE-POINTERS
		BNE CNTPLY1 ;ONLY PERFORM CNTPLAY IF THERE'S ANY INSTRUMENT SELECTED
		RTS ;JMP RETRACK
CNTPLY1	;
p_insl5	LDA INSPTLO,Y ;Y IS NUMBER OF CURRENT INSTRUMENT
		STA PLAYERZP+0
p_insh5	LDA INSPTHI,Y
		STA PLAYERZP+1
CNTPLY2	;CONTINUOUS PLAY - SLIDE,VIBRATO,SWEEP,TABLES,ETC.
.IF CHEATRASTERTIME=1
		cpx #0   ;this cheat is needed to better estimate rastertime of output
		bne +
		stx $d020 ;because the orderlist sprites eat CPU cycles from playercode, increasing rastertime in editor
		+
.FI		

VIBSLIDE ;VIBRATO AND SLIDE/PORTAMENTO PATTERN-FX AS WELL (A BIT TRICKY)
a75		LDY SLIDEVIB,X ;READ SLIDE/PORTAMENTO/VIBRATO TYPE FROM INST.CONTROL BYTE
.IF VIBRATOTYPES_ON
		BEQ INCVIBR ;INCREASING TYPE OF VIBRATO?
.FI		
		BPL NORMVIB ;IF BELOW $80, IT'S NORMAL VIBRATO
SLIDES	CPY #$82 ;DECIDE WHICH KIND OF SLIDE - SETTING CARRY-FLAG AND N-FLAG
		BEQ SUBFREQ ;IF $82
		BMI ADDFREQ ;IF $81
PORTAME	LDY DPITCH,X ;HANDLE PORTAMENTO
a76		LDA FREQTBL,Y ;COMPARE TO DESIRED NOTE AFTER PORTAMENTO
a77		SBC FREQLO,X ;SET CARRY
a78		STA STORFRL+1 ;STORE DIFFERENCE LO-BYTE
a79		LDA FREQTBH,Y ;HI-BYTE OF DESIRED NOTE-PITCH
a80		SBC FREQHI,X ;COMPARE WITH CARRY
		TAY ;STORE DIFFERENCE HI-BYTE
STORFRL	LDA #0 ;SELF-WRITTEN PREVIOUSLY - STORED LO-BYTE OF DIFFERENCE
		BCS PORTAUP ;IF DESIRED PITCH IS BIGGER THAN ACTUAL PITCH, DO PORTAMENTO-UP
PORTADN	ADC FREQMODL,X ;PORTAMENTO-DOWN
		TYA ;RESTORE HI-BYTE OF DIFFERENCE
a81		ADC FREQMODH,X ;TEST HI-BYTE
		BCC SUBFREQ ;IF DESIRED NOTE IS NOT REACHED YET 
PORTEND	LDY DPITCH,X
a82		LDA FREQTBL,Y ;LO-BYTE OF DESIRED PITCH
a83		STA FREQLO,X ;DESIRED NOTE WAS REACHED, END OF PORTAMENTO, SET EXACT FREQUENCY 
a84		LDA FREQTBH,Y ;HI-BYTE OF DESIRED PITCH
a85		JMP STORVHI
NORMVIB	LDY VIDELCNT,X  ;HANDLE VIBRATO-DELAY IN CASE OF NORMAL VIBRATOS
		BMI DOVIBRA ;IF DELAY-COUNTER FINISHED 
a86		DEC VIDELCNT,X
a87		JMP ENDVIBSLIDE
.IF VIBRATOTYPES_ON
INCVIBR	LDA FREQMODL,X
		CLC ;LDA FREQMODL,X ;WAS LOADED PREVIOUSLY INTO ACCU
a28b	ADC VIDELCNT,X ;AMPLITUDE-INCREASE RATIO IS TAKEN FROM VIBRATO-DELAY DATA
a29b	STA FREQMODL,X
		BCC DOVIBRA
a30b	INC FREQMODH,X
.FI		
DOVIBRA	LDA VIBRACNT,X
		BNE + ;IF NOT ZERO (COUNTED DOWN) SIMPLY SUBSTRACT 1 (OR NOTHING, IF SLIDE)
a88		LDA VIBFREQU,X
+		SEC
		SBC #1
a89		STA VIBRACNT,X
		ASL ;IF HALF OF COUNTER REACHED, CHANGE VIBRATO-SLIDE-DIRECTION
a90		CMP VIBFREQU,X ;SET CARRY BIT BASED ON WHICH HALF THE FREQUENCY COUNTER IS IN
		BCC ADDFREQ ;CARRY IS SET HERE CORRECTLY, NO NEED TO INITIALIZE IN NEXT STEP
SUBFREQ	LDA FREQLO,X
a91		SBC FREQMODL,X ;SUBSTRACT LOW-BYTE PART, SET CARRY-BIT
a92		STA FREQLO,X 
a93		LDA FREQHI,X
a94		SBC FREQMODH,X ;SUBSTRACT HIGH-BYTE PART AND CARRY-BIT
a95		JMP STORVHI
PORTAUP	SBC FREQMODL,X ;PORTAMENTO-UP
		TYA ;RESTORE HI-BYTE OF DIFFERENCE
a96		SBC FREQMODH,X ;TEST HI-BYTE
		BCC PORTEND ;IF DESIRED NOTE IS REACHED, END OF PORTAMENTO, SET EXACT FREQUENCY 
ADDFREQ	LDA FREQLO,X ;PREFETCH DATA
a97		ADC FREQMODL,X ;ADD LOW-BYTE PART, SET CARRY-BIT
a98		STA FREQLO,X
a99		LDA FREQHI,X
a100	ADC FREQMODH,X ;ADD HIGH-BYTE PART AND CARRY-BIT
STORVHI	STA FREQHI,X
ENDVIBSLIDE

;FILTER-RESO-CUTOFF-BAND HANDLING --- DETECTS FILTER-CONTROLLER CHANNEL!!!!
FLTCTRL CPX #0 ;SELF-WRITTEN ;CHECK WICH CHANNEL CONTROLS THE FILTER
		BEQ FLTPOSI
a101	JMP ENDFLTB ;IF NOT ACTUAL TRACK, DONT'T RUN ITS FILTER-TABLE
FLTPOSI	LDY #0 ;SELF-WRITTEN -FILTERTABLE-POSITION OF ACTUAL FILTER-CONTROLLER TRACK
		LDA (PLAYERZP),Y ;FILTERTABLE 1ST COLUMN BAND-RESO. / FILTERSWEEP-CYCLECOUNT
		BMI NOCWEEP ;IF FILTER-SETTING OR JUMP IN ACTUAL POSITION
FISWEEP	INY ;POINT TO 2ND COLUMN
CWEPCNT	CMP #0 ;SELF-WRITTEN - FILTER CUTOFF-FREQUENCY SWEEP COUNTER
		BEQ FLADVAN    ;;IF SWEEP-PROGRAM REACHED ITS END, ADVANCE TO NEXT TABLE-ROW
a102	INC CWEPCNT+1
		CLC ;CARRY=0 - TREAT $FF AS -1 IN UPCOMING FINE CUTOFF-SWEEP
		LDA (PLAYERZP),Y ;CUTOFF SIGNED AMOUNT TO ADD/SUBSTRACT IN ONE FRAME
.IF FINEFILTSWEEP_ON
		BPL CWEEPUP ;IF POSITIVE (BIT7=0) ADD VALUE, OTHERWSE SUBSTRACT
CWEEPDN	ORA #$F8 ;SART SUBSTRACTING 7-BIT VALUE FROM 8+3 BIT VALUE
a31b	ADC CTFLGHO+1 ;#0 ;SELF-WRITTEN
		PHP ;STORE CARRY-BIT
		AND #7
a32b	STA CTFLGHO+1
		LDA (PLAYERZP),Y ;CUTOFF SIGNED AMOUNT TO ADD/SUBSTRACT IN ONE FRAME
		EOR #$FF
		#DIVIDE8 ;LSR;LSR;LSR
		EOR #$FF
a33b	JMP +
CWEEPUP	AND #7 ;SART ADDING 7-BIT VALUE TO 8+3 BIT VALUE 
a34b	ADC CTFLGHO+1 		;CLC NOT NEEDED ;CARRY-BIT WAS SET BEFORE
		CMP #8 ;SETS CARRY IF LOW 3 BITS OVERLOADED
		PHP ;STORE CARRY
		AND #7
a35b	STA CTFLGHO+1
		LDA (PLAYERZP),Y ;CUTOFF SIGNED AMOUNT TO ADD/SUBSTRACT IN ONE FRAME
		#DIVIDE8 ;LSR;LSR;LSR
+		PLP ;GET CARRY BACK
.FI		;END OF FINE (11BIT) FILTERSWEEP-CHECKING
a103	ADC CTFHGHO+1
a104	STA CTFHGHO+1
a105	JMP ENDFLTB
NOCWEEP	CMP #$FE ;....LOOP/JUMP COMMAND ?
		BEQ FLTJUMP ;CHECK IF $FE JUMP-COMMAND
		BCC SETFILT ;IF $80 >= BUT < $FE, SET FILTER 
a106	JMP ENDFLTB ;IF $FF FILTERTABLE-ENDSIGNAL, DO NOTHING
FLTJUMP	INY ;POINT TO JUMP-ADDRESS IN 2ND COLUMN
		LDA (PLAYERZP),Y ;JUMP-ADDRESS
a107	CMP FLTPOSI+1 ;,X  
		BEQ ENDFLTB ;IF JUMPING TO ITSELF, NO NEED TO EXECUTE ANY JUMPING, BUT RESTING INSTEAD    
		TAY
		LDA (PLAYERZP),Y ;READ 1ST COLUMN FROM JUMP-TARGET ADDRESS
		BPL SETFPOS ;IF BELOW $80, JUST INIT FOR SWEEP COMING IN NEXT TURN
SETFILT	PHA ;SET FILTER, IF 1ST NIBBLE IS MORE THAN 8, AND NOT $FE/$FF
		AND #$70 ;MASK FOR FILTERBAND-SWITCHES
a108	STA FLTBAND+1 ;SET FILTER-BAND
		PLA
		#MULTIP8 ;GET AND SHIFT RESONANCE NIBBLE - x8 FIRST
		ASL ;x16
a109	STA RESONIB+1 ;RESONANCE-NIBBLE
		INY ;POINT TO 2ND COLUMN
		LDA (PLAYERZP),Y ;CUTOFF-HI VALUE
a110	STA CTFHGHO+1 ;SET CUTOFF-HI..
.IF FINEFILTSWEEP_ON
		LDA #0
a36b	STA CTFLGHO+1 ;SET CUTOFF-LO..
.FI		
FLADVAN	INY ;POINT TO 3RD COLUMN
.IF FILTKBTRACK_ON
		LDA (PLAYERZP),Y
a37b	STA CKBDTRK+1 ;READ AND ACK. KEYBOARD-TRACK FOR FILTER
.FI		
		INY ;POINT TO NEXT ROW 1ST COLUMN
SETFPOS	TYA
a111	STA FLTPOSI+1 ;,X
		LDA #0
a112	STA CWEPCNT+1 ;INITIALIZE SWEEP-COUNTER AFTER SETTING PW...
ENDFLTB

;PULSEWIDTH-TABLE HANDLING		
SETPWID	LDY PWTPOS,X
		LDA (PLAYERZP),Y   ;PWTABLE 1ST COLUMN PW-HI-NIBBLE / PW-SWEEP-CYCLECOUNT
		BMI NOPWEEP ;IF PW-SETTING OR JUMP IN ACTUAL POSITION
PWSWEEP INY ;POINT TO 2ND COLUMN
a113	CMP PWEEPCNT,X ;IF SWEEP-PROGRAM REACHED ITS END
		BEQ PWADVAN    ;THEN ADVANCE TO NEXT PWTABLE-ROW
a114	INC PWEEPCNT,X
		LDA (PLAYERZP),Y     ;PW SIGNED AMOUNT TO ADD/SUBSTRACT IN ONE FRAME
		BPL + ;DECIDE IF ADD/SUPSTRACT, PRE-DECREMENT HI-BYTE IS KINDA SUBSTRACTION
a115	DEC PWHIGHO,X
+		CLC ;NOT NECESSARY IF PRECISION NOT NEEDED, AS CARRY WAS SET TO 1 PREVIOUSLY BY 'CMP PWEEPCNT,X'
a116	ADC PWLOGHO,X 
a117	STA PWLOGHO,X
		BCC a119
a118	INC PWHIGHO,X
a119	JMP ENDPWTB
NOPWEEP	CMP #$FE ;....LOOP/JUMP COMMAND ?
		BEQ PWTJUMP ;CHECK IF $FE JUMP-COMMAND
		BCC SETPULW ;IF $80 >= BUT < $FE, SET PULSEWIDTH 
a120	JMP ENDPWTB ;IF $FF PWTABLE-ENDSIGNAL, DO NOTHING
PWTJUMP	INY ;POINT TO JUMP-ADDRESS IN 2ND COLUMN
		LDA (PLAYERZP),Y ;JUMP-ADDRESS
a121	CMP PWTPOS,X  
		BEQ ENDPWTB ;IF JUMPING TO ITSELF, NO NEED TO EXECUTE ANY JUMPING, BUT RESTING INSTEAD
		TAY
		LDA (PLAYERZP),Y ;READ 1ST COLUMN FROM JUMP-TARGET ADDRESS
		BPL SEPWPOS ;IF BELOW $80, JUST INIT FOR SWEEP COMING IN NEXT TURN
SETPULW	AND #$7F     ;SET PULSEWIDTH, IF 1ST NIBBLE IS MORE THAN 8, AND NOT $FE/$FF
a122	STA PWHIGHO,X
		INY ;POINT TO 2ND COLUMN
		LDA (PLAYERZP),Y ;PW-LOW VALUE
a123	STA PWLOGHO,X
PWADVAN	INY ;POINT TO 3RD COLUMN
.IF PWKEYBTRACK_ON
		LDA (PLAYERZP),Y ;READ AND ACK. KEYBOARD TRACK FOR PW
a38b	STA PKBDTRK,X
.FI		
		INY ;POINT TO NEXT ROW 1ST COLUMN
SEPWPOS	TYA
a124	STA PWTPOS,X
		LDA #0
a125	STA PWEEPCNT,X ;INITIALIZE SWEEP-COUNTER AFTER SETTING PW...
ENDPWTB	
.IF PWKEYBTRACK_ON
		CLC ;PRE-SET CARRY
a39b	LDA PKBDTRK,X ;ADJUST STEPPING-AMOUNT PER NOTE (KINDA DIVISION USING EXP.TABLE)
		BEQ a43b ;IF NO KEYBOARD-TRACKING (NO DIVISION WITH ZERO)
a40b	ADC DPITCH,X ;A=ACTUAL NOTE ON ACTUAL TRACK
		TAY
a41b	LDA EXPTABH,Y ;TRANSFORM ADDITION/SUBSTRACTION TO QUASY MULTIPLICATION/DIVISION
a42b	SBC EXPTABH-1,Y ;FURTHER DIVIDE THE VALUE TO FIT IN 4 UPPER BITS OF PULSEWIDTH
a43b	ADC PWHIGHO,X ;UPPER 4 BITS OF PULSEWIDTH, ONLY THIS KB.TRACKED FOR SPEED REASONS
.ELSE
a44b	LDA PWHIGHO,X ;UPPER 4 BITS OF PULSEWIDTH
.FI
		STA SIDBASE+3,X
.IF COMPILEDAPP=1 ;HELP EDITOR TO DISPLAY PULSEWIDTH WITH KEYBOARD-TRACK
		STA PWHIHELP,X
.FI		
a126	LDA PWLOGHO,X
		STA SIDBASE+2,X ;LOWER 8 BITS OF PULSEWIDTH

WFARPTB	
.IF ARPSPEEDSUPP_ON
a45b	DEC ARPSCNT,X ;DECREASE ARPEGGIO-SPEED COUNTER
		BPL SKIPWFT
a46b	LDA ARPSPED,X
		AND #$3F
a47b	STA ARPSCNT,X
.FI		
RDWFROW	LDY WFTPOS,X
		LDA (PLAYERZP),Y
		CMP #$FE ;....LOOP/JUMP COMMAND ?
		BEQ WFAJUMP ;IF $FE JUMP-COMMAND
		BCC + ;IF $FF WFTABLE-ENDSIGNAL, DO NOTHING
SKIPWFT	JMP ENDWFTB ;WHEN COUNTER NOT COUNTED DOWN
		+
.IF ARPSPEEDSUPP_ON
		CMP #$10 ;TRESHOLD BETWEEN ARPSPEED/WAVEFORM-SETTING
		BCS SEWFARP ;IF $00..$0F ARP-SPEED CHANGE (REPEAT $XX TICKS) - IN CASE OF 0, NOP - NO REPEAT
a48b	STA ARPSCNT,X
a49b	JMP SETJARP
.ELSE	
a50b	JMP SEWFARP
.FI		
WFAJUMP	INY ;SET REAL ADDRESS (MUL3)
		LDA (PLAYERZP),Y ;READ JUMP-ADDRESS NEXT TO $FE
		BMI ENDWFTB ;IF BIGGER THAN JUMP ROW IS BIGGER THAN $2B (ADDRESS IS BIGGER THAN 3*$28+8)
a127	STA WFTPOS,X
		TAY ;INDEX TO JUMP-ADDRESS
		LDA (PLAYERZP),Y ;READ WAVEFORM-COLUMN FROM JUMP-TARGET ADDRESS
SEWFARP	AND PTNGATE,X
a128	STA WFGHOST,X
SETJARP	INY ;2 CYCLES
		LDA (PLAYERZP),Y ;ARP.ABS/REL PITCH ;6 CYCLES
		INY ;2 CYCLES
.IF CHORDSUPPORT_ON		
		CMP #$7F ;CHECK IF JUMPING TO CHORD
		BEQ PLYCHRD ;BNE NORMARP ;IF $7F, HANDLE CHORD INSTEAD OF WF-TABLE ARPEGGIO-COLUMN & DON'T ADVANCE IN TABLE
.FI		
a129	STA ASTOREZ+1 ;4 CYCLES
.IF DETUNESUPPORT_ON
		LDA (PLAYERZP),Y ;6 CYCLES
a130	STA DETUNER+1
.FI
		INY ;2 CYCLES
		TYA ;2 CYCLES
a131	STA WFTPOS,X ;5 CYCLES
ASTOREZ	LDA #0 ;2 CYCLES
NORMARP	BPL RELPTCH ;IF REL.PITCH-UP (CARRY WAS SET BY 'CMP #$7F')
		CMP #$80 ;NOP?
		BEQ ENDWFTB ;DON'T CHANGE PITCH IF NOP
		CMP #$E0
		BCC ABSPTCH ;IF ABSOLUTE PICTH
.IF CHORDSUPPORT_ON
a51b	JMP RELPTCH ;IF REL.PITCH-DOWN
PLYCHRD	LDA (PLAYERZP),Y ;6 CYCLES
a52b	STA DETUNER+1
a53b	LDY CHORDPOS,X ;READ CHORDNOTE AT PLAYED CHORD-INDEX
p_chdt1	LDA CHORDS,Y ;LOAD RELATIVE CHORD-PITCH
		CMP #$7E ;$7E? - RETURN FROM CHORD TO WFARP-TABLE?
		BNE +
a54b	LDY ACTCHORD,X ;LOOP TO BEGINNING OF ACTUAL CHORD
p_chdp2	LDA CHDPTRLO,Y ;GET CHORD-BASEPOINTER
a55b	STA CHORDPOS,X ;RESET PLAYED CHORD-INDEX TO PREPARE FOR NEXT POSSIBLE CHORD-LAUNCH
a56b	LDA WFTPOS,X ;INDEX OF ACTUAL ROW
		ADC #3-1 ;CARRY IS 1 AFTER 'CMP' DIDN'T UNDERFLOW, SO MUST BE SUBSTRACTED
a57b	STA WFTPOS,X
a58b	JMP RDWFROW ;RDWFORM ;GO TO BEGINNING OF NEXT ROW 
+		CMP #$7F ;$7F? - LOOP CHORD?
		BNE DOCHORD
LOOPCHD	LDY ACTCHORD,X ;LOOP TO BEGINNING OF ACTUAL CHORD
p_chdp3	LDA CHDPTRLO,Y ;GET CHORD-BASEPOINTER
a59b	STA CHORDPOS,X
		TAY
p_chdt2	LDA CHORDS,Y ;LOAD RELATIVE CHORD-PITCH
DOCHORD	INC CHORDPOS,X ;ADVANCE IN PLAYED CHORD-INDEX
.FI		;END OF CHECKING CHORD-SUPPORT
RELPTCH	CLC ;ADD VALUE TO DISCRETE NOTE-PITCH
a132	ADC DPITCH,X
ABSPTCH	AND #$7F ;FOR ABSOLUTE PITCH
		TAY
a133	LDA FREQTBL,Y
.IF DETUNESUPPORT_ON
DETUNER	ADC #0 ;RESTORE DETUNE-VALUE - 2 CYCLES
.FI		
a134	STA FREQLO,X ;HANDLE PITCH-DETUNING (DELAYED VIBRATO STILLAPPLICABLE)
a135	LDA FREQTBH,Y
		ADC #0 ;ADD CARRY (IF DETUNER HAS UPPER PART)
a136	STA FREQHI,X
ENDWFTB
;-----------------------
WRPITCH	LDA FREQLO,X ;
		STA SIDBASE+0,X
a137	LDA FREQHI,X
		STA SIDBASE+1,X
;-------------------------------------------
WRGHOST	LDA WFGHOST,X
.IF COMPILEDAPP=1 ;muting in editor
		ldy playmod
		beq + ;in stopped (jamming) mode no need to use mute/solo feature
		ldy div7chn,x
		and mutesolo,y ;$FE or $FF
		+
.FI		
		STA SIDBASE+4,X ;WAVEFORM-CONTROL SID-REGISTER
;-----------------------------------------------------------
RETRACK	RTS ;RETURN FROM ACTUAL SID-TRACK


;****************************COMMON SUBROUTINES********************************
SETSTUNE ;SET SUBTUNE, MIGHT BE USED LATER AS SUBROUTINE BY SUBTUNE-JMP SEQFX
		CMP #maxsubtuneamount 
		BCC + ;IF ABOVE ALLOWED NUMBER OF SUBTUNES, RESET TO DEFAULT SUBTUNE 0
		LDA #0
+       #MULTIP8 ;GET SUBTUNE ADDRESS FROM ACCU MULTIPLIED 8 -ASL;ASL;ASL
        TAY
		LDX #1
p_subt1	LDA SUBTUNES,Y  ;READ ORDERLIST LO-ADDRESSES FOR SUBTUNE
a138	STA P_SEQT1,X    ;SET ORDERLIST LO-ADDRESSES FOR SUBTUNE
		INY
		INX
p_subt2	LDA SUBTUNES,Y  ;READ ORDERLIST HI-ADDRESSES FOR SUBTUNE
a139	STA P_SEQT1,X    ;SET ORDERLIST HI-ADDRESSES FOR SUBTUNE
		INY
		INX
		INX
		INX
		CPX #13
		BMI P_SUBT1
p_subt3	LDA SUBTUNES,Y ;COPY SUBTUNE-FUNKTEMPO1 TO TEMPOTABLE PLACE 0
p_tmpt4	STA TEMPOTBL+0
p_subt4	LDA SUBTUNES+1,Y ;COPY SUBTUNE-FUNKTEMPO2 TO TEMPOTABLE PLACE 1
p_tmpt5	STA TEMPOTBL+1
		RTS
;-----------------------
SEQSUB  CPX #7*1 ;SEQUENCE (ORDERLIST) READER SUBROUTINE,Y=POS.
        BEQ P_SEQT2   ;CALLED AS SUBROUTINE,READS TRACK-SEQ OF REG.X
		BPL P_SEQT3
p_seqt1	LDA SEQUENCES,Y  ;LOAD PTNUM/FX FROM TRACK 0 ORDERLIST
        RTS
p_seqt2	LDA SEQUENCES,Y  ;LOAD PTNUM/FX FROM TRACK 1 ORDERLIST
        RTS
p_seqt3	LDA SEQUENCES,Y  ;LOAD PTNUM/FX FROM TRACK 2 ORDERLIST
        RTS

;-------------------------------------------------------------------------------
.IF CALCVIBRATO_ON ;DIFFERENT EXPONENT-TABLE BASES AND TRESHOLD FOR CALCULATED VIBRATO
	EXPTBASE=EXPTABH
.ELSE
	EXPTBASE=FREQTBH-1
.FI
EXPTRESHOLD=ENDFREQTBH-EXPTBASE

SETVIBR	PHA   ;SET AMPLITUDE AND FREQUENCY OF VIBRATO. INPUT: ACCU (HI-NIBBLE IS AMPLITUDE)
		AND #$0F
		#SETVFRE ;JSR SETVFRE ;CALL MACRO INSTEAD OF SUBROUTINE TO SAVE JSR-RTS CYCLES 
a208	STA VIBFREQU,X
		LSR ;HALF-TIMERSTART FOR DOWN-ORIENTED VIBRATO (LIKE GUITAR TREMOLO-ARM)
.IF VIBRATOTYPES_ON
a27b	LDY SLIDEVIB,X ;SELF-WRITTEN CODE - VIBRATO-CONTROL-EXACT FROM INSTRUMENT-CONTROL REGISTER
		CPY #$20
		BPL + ;NOT INCREASING-TYPE VIBRATO OR DEFAULT VIBRATO?
.FI		
		LSR ;FOR QUARTER TIMERSTART - NORMAL VIBRATO
.IF VIBRATOTYPES_ON
+		CPY #$30
		BNE a70
		LDA #0 ;0 TIMERSTART FOR UP-ORIENTED VIBRATO (LIKE GUITAR STRING STRETCHING)
.FI		
a70		STA VIBRACNT,X
		PLA 
SETVAMP	AND #$F0 ;SET AMPLITUDE (NO NEED TO MASK OUT FREQ.NIBBLE AS IT'S NOT SIGNIFICANT
		LSR ;0..127
SETFMOD	;SET FREQUENCY-MODIFIER VALUES FOR SLIDE/PORTAMENTO, OR RESET THEM IF NO SLIDE/VIBRATO
.IF CALCVIBRATO_ON
		BEQ a213 ;IF 0, NO CALCULATION OF PITCH
		LSR ;vibrato-0..64, slide-0..127
a95b	ADC DPITCH,X ;vibrato-0..160, slide-0..222 , CALCULATE PITCH-DEPENDENT AMPLITUDE-COMPENSATION HERE!!!!
.FI			
LOOKUPA	TAY ;0..LOOK UP AMPLITUDE VALUE FROM FREQUENCY/EXPONENT-TABLES
CHKTEND	CPY #EXPTRESHOLD+(ENDFREQTBH-FREQTBH)
		BCS MAXSLID ;IF POINTS OVER TABLE
		CPY #EXPTRESHOLD ;DECIDE ON FINE/ROUGH HALF OF THE EXPONENT-TABLE
		BCS a214 ;if bigger than $60 limit of table, switch to rough table
a212	LDA EXPTBASE,Y
a213	STA FREQMODL,X
		LDA #0 ;IN FINE-RANGE FREQ-ADD-HI SHOULD BE 0
		BEQ a217 ;jump
MAXSLID	LDY #EXPTRESHOLD+(ENDFREQTBH-FREQTBH)
a214	LDA FREQTBL-EXPTRESHOLD,Y 
a215	STA FREQMODL,X
a216	LDA FREQTBH-EXPTRESHOLD,Y ;EXPTABH,Y ;EXPONENTIAL TABLE SIMULATES MULTIPLICATION - CALCULATED VIBRATO
a217	STA FREQMODH,X
		RTS

;******************************* NUMERIC DATA *********************************
;SID EQUAL-TEMPERED frequency table:
;----------------------------------------------------
;EXPONENT-TABLE HI-BYTES (USED FOR MULTIPLICATION)
.IF (CALCVIBRATO_ON+PWKEYBTRACK_ON+FILTKBTRACK_ON+(COMPILEDAPP=1))
EXPTABH	.BYTE 0,0,0,0,0,0,0,0, 0,0  ;LET EXPONENT TABLE BE A BIT MORE COMPLETE (FOR SUBSTRACTING KB.TRACK)
.FI           ;USED AS CALCULATED VIBRATO-AMPLITUDE TABLE TOO
		.BYTE 0 ;FOR UNCALCULATED ZERO VIBRATO
FREQTBH	.BYTE $01,$01,$01, $01,$01,$01 ;0  ;13  ;16TH ELEMENT IS $01 IN EXP.TABLE
		.BYTE $01,$01,$01,$01,$01,$01 ;6   ;19
		.BYTE $02,$02,$02,$02,$02,$02 ;12  ;25
		.BYTE $02, $03,$03,$03,$03,$03 ;18 ;31  ;32ND ELEMENT IS $03 IN EXP.TABLE
		.BYTE $04,$04,$04,$04,$05,$05 ;24  ;37  ;!!! $04 IS 37TH ELEMENT IN EXP.TABLE
		.BYTE $05,$06,$06,$06,$07, $07 ;30 ;43  ;48TH ELEMENT IS $07 IN EXP.TABLE
		.BYTE $08,$08,$09,$09, $0a,$0a ;36 ;49  ;!!!! $0A IS 53TH ELEMENT IN EX.TABLE 
		.BYTE $0b,$0c,$0d,$0d,$0e, $0f ;42 ;55  ;$0F IS 60TH ELEMENT IN EXP.TABLE 
		;-------------------------------------
		.BYTE $10,$11,$12, $13,$14,$15 ;48 ;61 ;!!!64TH (72-8) ELEMENT IS $13 ($1F-$0C) IN EXP.TABLE
		.BYTE $17, $18,$1a,$1b,$1d, $1f ;54;67 ;!!!! $1F ($2E-$0F) IS 72ND (64+8) ELEMENT IN EXP.TABLE,!!!$18 ($0A+$0E) IS 68TH
		.BYTE $20,$22, $24,$27,$29,$2b ;60 ;73  ;$24 IS 75TH ELEMENT IN EXP.TABLE
		.BYTE $2e,$31, $34,$37,$3a, $3e ;66;79 ;!!!$2E ($1F+$0F) IS 79TH (72+7), $3E IS 84TH, 80TH ELEMENT IS $31 IN EXP.TABLE
		.BYTE $41,$45,$49,$4e,$52,$57 ;72  ;85
		.BYTE $5c,$62,$68,$6e,$75,$7c ;78  ;91
		.BYTE $83,$8b,$93,$9c,$a5,$af ;84  ;97
		.BYTE $b9,$c4,$d0,$dd,$ea,$f8 ;90  ;103
ENDFREQTBH		
.IF (CALCVIBRATO_ON+PWKEYBTRACK_ON+FILTKBTRACK_ON+(COMPILEDAPP=1))
		.BYTE $F9,$FA,$FB,$FC,$FD,$FE,$FF,$FF ;EXPAND EXPONENT-TABLE WITH SLOPE FOR KB.TRACKING
.FI		
ENDEXPTABH
;------------------------------------------------------------------------------
FREQTBL
		.BYTE $07,$16,$27,$38,$4b,$5e
		.BYTE $73,$89,$a1,$ba,$d4,$f0
		.BYTE $0d,$2c,$4e,$71,$96,$bd
		.BYTE $e7,$13,$42,$74,$a8,$e0
		.BYTE $1b,$59,$9c,$e2,$2c,$7b
		.BYTE $ce,$27,$84,$e8,$51,$c0
		.BYTE $36,$b3,$38,$c4,$59,$f6
		.BYTE $9d,$4e,$09,$d0,$a2,$81
		;---------------------------------------------
		.BYTE $6d,$67,$70,$88,$b2,$ed
		.BYTE $3a,$9c,$13,$a0,$44,$02
		.BYTE $da,$ce,$e0,$11,$64,$da
		.BYTE $75,$38,$26,$40,$89,$04
		.BYTE $b4,$9c,$c0,$22,$c8,$b4
		.BYTE $eb,$71,$4c,$80,$12,$08
		.BYTE $68,$38,$80,$45,$90,$68
		.BYTE $d6,$e3,$98,$00,$24,$10

;*************************** EFFECTS' SECTION *******************************************
;---------------- HANDLE ORDERLIST/SEQUENCE-EFFECTS, INPUT:A, DON'T DISTURB X&Y!
SEQ_FX	CMP #$A0 ;IF BELOW $A0: TRANSPOSE-FX ($80..$8F:DOWN, $90..$9F:UP)
		BPL + ;FX ABOVE $A0?
.IF TRANSPOSESUPP_ON
		;SEC - CARRY WAS SET BY 'CMP' JUST BEFORE, AND NEXT -1 WILL COMPENSATE
		SBC #$90-1 ;TRANSFORM RANGE $80..$FD TO $F0..$6D
a60b	STA TRANSP2,X ;SET TRANSPOSE-VALUE (2'S COMPLEMENT)
.FI		
		RTS
+		CMP #$B0 ;IF VOLUME-FX ($A0..$AF: SET VOLUME TO 0..15 )
		BPL + ;FX ABOVE $B0?
		AND #$0F
a140	STA SEQVOLU+1 ;WILL BE SET TO MAINVOL+1 IN NEXT ROUND (DELAY NEEDED)
		RTS
+		;TEMPO-SETTING ....;SEC - CARRY WAS SET TO 0 BY 'CMP'
.IF TEMPOPRGSUPP_ON 
		SBC #$B0 ;SHIFT RANGE $B0..$FD TO $00..$5D
a63b	STA SEQTEMPO,X ;TEMPORARY DELAYED VALUE FOR TRACK-TEMPO SETTING
.FI		
		RTS
		
;------------------------------------------------------------------------------
NOTEFXTBL	.BYTE NPORTAM-INDEXJ1-2,NSYNCON-INDEXJ1-2,NSYNCOF-INDEXJ1-2,NRINGON-INDEXJ1-2
			.BYTE NRINGOF-INDEXJ1-2,NGATEON-INDEXJ1-2,NGATEOF-INDEXJ1-2,0
			
NOTE_FX	;NOTE-FX/INSTRUMENT-FX/PATTERN-FX - ALTERATIONS BEFORE CNTPLAY AND SID-WRITING
CHVIBFX	CMP #PACKEDMAX+1 ;$78 ;CHECK VIBRATO-FX IN NOTE-COLUMN - IF SOMEHOW $70-$7F, TREAT AS VIBRATO
		BPL SELNTFX ;IF MORE THAN $70 IT IS NOTE-FX, OTHERWISE TREATED AS VIBRATO
a141	JSR VIBAMFX
a142	JMP ENDNOTEFX
		
SELNTFX	TAY ;JUMP TO ADDRESS ACCORDINGLY TO PERFORM NOTE-FX
a143	LDA NOTEFXTBL-$78,Y ;INDEX FROM 1ST NOTE-FX (AFTER PACKED-NOP VALUE)
a144	STA INDEXJ1+1
a145	LDA WFGHOST,X ;PRELOAD WAVEFORM-REGISTER
		CLC ;ENSURE JUMP INSTEAD OF CONDITIONAL BRANCHING
INDEXJ1	BCC *+2    ;THIS SMALLFX-BRANCH SECTION MUST FIT IN $7F BYTES

NPORTAM	LDY #$FF ;PRE-SIGN NOTE-PORTAMENTO FOR 'TICK2'
		LDA #DEFAULTPORTA ;AN AVERAGE SPEED-VALUE FOR THE TONE-PORTAMENTO
a146	JSR SETSLID ;SET SLIDE-TYPE AND SLIDE-SPEED
a147	JMP ENDNOTEFX
		
NSYNCON	ORA #%00000010 ;SET SYNC BIT ;SYNCONFX
a148	JMP WRWFORM
NSYNCOF	AND #%11111101 ;RESET SYNC BIT ;SYNCOFFX
a149	JMP WRWFORM
NRINGON	ORA #%00000100 ;SET RING BIT ;RINGONFX
a150	JMP WRWFORM
NRINGOF	AND #%11111011 ;RESET RING BIT ;RINGOFFX
WRWFORM	STA WFGHOST,X
a151	JMP ENDNOTEFX
		
NGATEON	LDA #$FF ;GATEONFX ;$7D ;GATE-ON?  ;NOTE-FX - INPUT:ACCU
a152	STA PTNGATE,X
a153	JMP ENDNOTEFX
		
NGATEOF	;GATEOFFX ;$7E ;GATE-OFF?
.IF	GATEOFFPTR_ON 
		LDY #$0C ;SET TABLEPOSITIONS TO GATE-OFF POINTERS
		LDA (PLAYERZP),Y ;GATE-OFF POINTER FOR WF-ARP. TABLE
		BNE SETGOFF ;IF WFARP-GATEOFF NONZERO, SET IT
.FI		
		LDA #$FE      ;NORMAL GATE-OFF GATE-BIT OFF 'AND'-ER
a154	STA PTNGATE,X
a155	AND WFGHOST,X
a156	STA WFGHOST,X
.IF GATEOFFPTR_ON
a64b	JMP +
SETGOFF	STA WFTPOS,X ;RESET ARP-SPEED COUNTER?
+		LDY #$0D
		LDA (PLAYERZP),Y ;GATE-OFF POINTER FOR PULSEWIDTH-TABLE
		BEQ a66b
a65b	STA PWTPOS,X 
a66b	CPX FLTCTRL+1 ;CHECK IF THIS IS FILTER-CONTROLLER TRACK
		BNE + ;IF NOT FILTER-CONTROLLER TRACK, DON'T MODIFY ANYTHING
		INY ;$0E
		LDA (PLAYERZP),Y ;GATE-OFF POINTER FOR FILTER-TABLE
		BEQ +
a67b	STA FLTPOSI+1
		+
.FI		
ENDNOTEFX

;---------------------------------------------------------------------
INSPTFX ;ENTRY POINT FOR INST.&PATTERN-FX TOGETHER (SKIPPED NOTE-FX)
INST_FX	LDA ACTIFX,X ;CHECK INST/FX COLUMN   ;PRIO3
		BEQ PATT_FX ;IF 'NOP'
		CMP #$40
		BMI PATT_FX ;IF INSTRUMENT
a157	JSR SMALPFX ;IF INSTRUMENT-FX
		
;---------------------------------------------------------------------
PATT_FX LDA ACTFX2,X ;PRIO2
		BEQ RETURFX ;IF NOP - MAYBE NOT NEEDED TO DISTINGUISH, TAKEN FROM FX-TABLE
		CMP #$20 ;LOWER LIMIT OF SMALL-FX
		BCS SMALPFX
		
;------------------------------------------
BIGPTFX	ASL ;WE'RE READING WORDS
		TAY
a158	LDA BIGFXTABLE-2,Y ;NO FX 0, SO CHECKING FX1 AT POSITION 0
a159	STA INDEXJP+1
a160	LDA BIGFXTABLE-1,Y ;NO FX 0, SO CHECKING FX1 AT POSITION 0
a161	STA INDEXJP+2
a162	LDA ACTVAL,X  ;PRELOAD FX VALUE
INDEXJP	JMP RETURFX   ;SELF-WRITTEN JUMP-ADDRESS FOR BIGFX
RETURFX	RTS ;FOR SAFETY AND NOP

;-----------------------SOME FX-VALUE CONVERSION ROUTINES------
SETINBL	LDA (PLAYERZP),Y ;INSTRUMENT-BYTE
SETNIBL	AND #$F0 ;SET LOW NIBBLE AT ACCU
a163	ORA VALSTOR+1
		RTS
		
SETINBH	LDA (PLAYERZP),Y ;INSTRUMENT-BYTE
SETNIBH AND #$0F ;SET HIGH NIBBLE AT ACCU
a164	STA MERGEST+1
VALSTOR	LDA #0 ;SELF-WRITTEN
		#MULTIP8 ;x8...
		ASL ;x16
MERGEST	ORA #0 ;SELF-WRITTEN
		RTS
		
MULTI3C	;MULTIPLY ACCU WITH 3, RESULT IS STORED INTO ACCU
a211	STA MUL3TMP+1
		CLC
		ASL
MUL3TMP	ADC #0 ;SELF-WRITTEN
		RTS

;-------------------------------SMALL-FX---------------------------------------
SMALLFXTBL	.BYTE SMALFX2-INDEXJ2-2,SMALFX3-INDEXJ2-2 ;THIS TABLE IS FOR INSTRUMENT-FX AND SMALL PATTERN-FX
			.BYTE SMALFX4-INDEXJ2-2,SMALFX5-INDEXJ2-2,SMALFX6-INDEXJ2-2,SMALFX7-INDEXJ2-2
			.BYTE SMALFX8-INDEXJ2-2,SMALFX9-INDEXJ2-2,SMALFXA-INDEXJ2-2,SMALFXB-INDEXJ2-2
			.BYTE SMALFXC-INDEXJ2-2,SMALFXD-INDEXJ2-2,SMALFXE-INDEXJ2-2,SMALFXF-INDEXJ2-2
			
SMALPFX	PHA
		#DIVIDE8 ;GET SMALLFX-TYPE - LSR;LSR;LSR;...
		LSR ;...DIVIDE BY 16
		TAY
a165	LDA SMALLFXTBL-2,Y ;NOTHING BELOW 2 FOR SMALLFX
a166	STA INDEXJ2+1
		PLA
		AND #$0F ;ACCU=EFFECT-VALUE (ARGUMENT)
a167	STA VALSTOR+1 ;STORE FX-VALUE NIBBLE FOR LATER USE
		CLC ;ENSURE JUMP INSTEAD OF CONDITIONAL BRANCHING
INDEXJ2	BCC *+2    ;THIS SMALLFX-BRANCH SECTION MUST FIT IN $7F BYTES
ENDSMFX	RTS ;FOR SAFETY AND RETURN FROM NOP

SMALFX2 ;SET 'ATTACK' NIBBLE OF ADSR  - (NO SMALLFX-1, AS $00..$1F VALUES ARE BIGFX)
		LDY #3 ;AD - INDEX
a168	JSR SETINBH ;GET&SET INSTRUMENT-DATA HIGH-NIBBLE WITH ACCU 
a169	JMP WRITEAD
		
SMALFX3 ;SET 'DECAY' NIBBLE OF ADSR
		LDY #3 ;AD - INDEX
a170	JSR SETINBL ;GET&SET INSTRUMENT-DATA LOW-NIBBLE WITH ACCU 
WRITEAD	STA SIDBASE+5,X
		RTS
		
SMALFX4 ;'4' = SID-REGISTER4 - ADJUST WAVEFORM
a171	LDA WFGHOST,X
a172	JSR SETNIBH
WRITEWF	STA WFGHOST,X
		RTS
		
SMALFX5 ;SET 'SUSTAIN' NIBBLE OF ADSR (NOTE-VOLUME)
		LDY #4 ;SR - INDEX
a173	JSR SETINBH
a174	JMP WRITESR
		
SMALFX6	;'6' = SID-REGISTER6/RELEASE - SET 'RELEASE' NIBBLE OF ADSR
		LDY #4 ;SR - INDEX
a175	JSR SETINBL ;GET&SET INSTRUMENT-DATA LOW-NIBBLE WITH ACCU 
WRITESR	STA SIDBASE+6,X
		RTS
		
SMALFX7 ;'7' = SET 'MAJ7 OR OTHER CHORD' FOR INSTRUMENT (OTHER THAN THE DEFAULT ASSIGNED CHORD)
.IF CHORDSUPPORT_ON
a68b	STA ACTCHORD,X
		TAY
p_chdp4	LDA CHDPTRLO,Y ;GET CHORD-BASEPOINTER
a69b	STA CHORDPOS,X
.FI		
		RTS
		
SMALFX8 ;SET VIBRATO AMPLITUDE
VIBAMFX	#MULTIP8 ;x8
		ASL ;x16
a176	JSR SETVAMP ;SET AMPLITUDE
FORCVIB	LDY #0 ;RESET SLIDE/VIBRATO - SET IT TO VIBRATO BY DEFAULT
		LDA (PLAYERZP),Y ;READ VIBRATO-TYPE FROM INSTRUMENT
FORCVI2	AND #$30
a186	STA SLIDEVIB,X
		RTS
		
SMALFX9 ;SET VIBRATO FREQUENCY
		#SETVFRE
a209	STA VIBFREQU,X
		RTS
		
SMALFXA	;'A' = ADJUST MAIN VOLUME
a177	STA MAINVOL+1
a187	STA SEQVOLU+1
		RTS
		
SMALFXB	;'B' = BAND-NIBBLE OF FILTER (LOW/MID/HI/3OFF)
		#MULTIP8 ;x8
		ASL ;x16
a178	STA FLTBAND+1
		RTS
;		
SMALFXC	;'C' = CHORD-SPEED AND ARPEGGIO-SPEED SETTING
.IF ARPSPEEDSUPP_ON
a70b	STA ARPSPED,X
		LDA #$FF ;CAUSE AN INSTANT START WITH NEW COUNTER
a71b	STA ARPSCNT,X
.FI		
		RTS
		
SMALFXD	#MULTIP8 ;x8 ;'D' = DETUNE ACTUAL NOTE
a179	JMP SETDETU
		
SMALFXE	;'E' = ENABLE/DISABLE TEST-BIT, RING-BIT, SYNC-BIT, GATE-BIT
a180	LDA WFGHOST,X
a181	JSR SETNIBL ;SET LOW NIBBLE
a182	JMP WRITEWF
		
.cerror *>INDEXJ2+$7F,"SOME OF LAST FX ARE OUT OF MAX BRANCH RANGE!!!"
SMALFXF	;'F' = FILTER RESONANCE (STRENGTH) NIBBLE SETTING
		#MULTIP8 ;x8
		ASL ;x16
a183	STA RESONIB+1
		RTS

;==========================================================================================
;IN COMING FX SECTION THE EFFECT-SUBROUTINES CAN BE SET IN ORDER OF STATISTICAL USE-RATE
;IF THE LEAST IMPORTANT EFFECTS ARE NOT USED IN TUNE, THE CODE CAN BE WIPED OUT BY
;SID-MAKER APP. PLAYER-CODE SIZE-REDUCTION COULD BE GAINED THAT WAY....
;------------------------------------------------------------------------------------------
;-----------------------------------------------------BIG-FX JUMP ADDRESSES---------------
BIGFXTABLE	.WORD BIGFX01,BIGFX02,BIGFX03,BIGFX04,BIGFX05,BIGFX06,BIGFX07
            .WORD BIGFX08,BIGFX09,BIGFX0A,BIGFX0B,BIGFX0C,BIGFX0D,BIGFX0E,BIGFX0F
            .WORD BIGFX10,BIGFX11,BIGFX12,BIGFX13,BIGFX14,BIGFX15,BIGFX16,BIGFX17
            .WORD BIGFX18,BIGFX19,BIGFX1A,BIGFX1B,BIGFX1C,BIGFX1D,BIGFX1E,BIGFX1F
ENDBIGFXTB
;-------------------------------BIGFX------------------------------------------

BIGFX01	;PITCH SLIDE UP - FX-NUMBER IS THE SAME AS GOATTRACKER'S
		LDY #$81 ;THIS VALUE CAUSES UP-SLIDE
a184	JMP SETSLID
		
BIGFX02	;PITCH SLIDE DOWN - FX-NUMBER IS THE SAME AS GOATTRACKER'S
		LDY #$82 ;THIS VALUE CAUSES DOWN-SLIDE
SETSLID	PHA
		TYA
a185	STA SLIDEVIB,X ;CAUSE SLIDE INSTEAD OF VIBRATO
		PLA ;THEN CALCULATE SLIDE-AMOUNT BASED ON NOTE-PITCH
a220	JMP SETFMOD
		
BIGFX03	;TONE PORTAMENTO - FX-NUMBER IS THE SAME AS GOATTRACKER'S
		LDY #$83
a188	JMP SETSLID

BIGFX04 ;'4' = 4TH REGISTER WAVEFORM SETTING, OR WAVEARP-TABLE POSITION ABOVE $f0
		CMP #$F0
		BCS +
a189	JMP WRITEWF
+		AND #$0F ;DISABLE COMMAND-PART
a190	JSR MULTI3C ;MULTIPLY ACCU BY 3, STORE RESULT IN ACCU
		ADC #WFTABLEPOS
a191	STA WFTPOS,X
		RTS

BIGFX05=WRITEAD	;'5' = 5TH SID-REGISTER SETTING - ATTACK AND DECAY

BIGFX06=WRITESR ;'6' = 6TH SID-REGISTER SETTING - SUSTAIN AND RELEASE

BIGFX07=SMALFX7 ;'7' = SELECT (MAJOR-7 OR ANY OTHER CHORD) FOR CURRENT INSTRUMENT

BIGFX08 ;'8' = SET VIBRATO FREQUENCY AND AMPLITUDE (NUMBER '8' IS A SIN/COS LISSAJOUS)
		PHA
a192	JSR FORCVIB ;FORCE VIBRATO INSTEAD OF SLIDE, READ TYPE FROM INSTRUMENT
		PLA
a193	JMP SETVIBR ;SET VIBRATO-AMPLITUDE AND FREQUENCY AND FREQ.COUNTER
;		
BIGFX09=FORCVI2	;SELECT VIBRATO-TYPE (USEFUL WHEN NEED INCREASING VIBRATO OCCASIONALLY)
;		
BIGFX0A ;'A' = ADJUST INST.PARAMETER-A - PULSEWIDTH-PROGRAM TABLEPOINTER
a194	JSR MULTI3C
		LDY #$0A
		ADC (PLAYERZP),Y ;PULSEWIDTH-PROGRAM POSITION INDEX
a195	STA PWTPOS,X
		RTS
		
BIGFX0B ;'B' = INSTRUMENT-PARAMETER 'B' - SET FILTER-PROGRAM TABLEPOINTER
a196	JSR MULTI3C
		LDY #$0B
		ADC (PLAYERZP),Y ;PULSEWIDTH-PROGRAM POSITION INDEX
a197	STA FLTPOSI+1 ;,X
		RTS
		
BIGFX0C=SMALFXC ;'C' = CHORDSPEED/ARPSPEED (MAX $3F)

BIGFX0D ;'D' = FINE-DETUNE ACTUAL TRACK WITH GIVEN AMOUNT
SETDETU	ADC FREQLO,X 
a198	STA FREQLO,X ;HANDLE PITCH-DETUNING (DELAYED VIBRATO STILL APPLICABLE)
		BCC +
a199	INC FREQHI,X
+		RTS
		
BIGFX0E ;SIMPLE PULSEWIDTH-SETTING - INSTRUMENT TABLE CAN OVERRIDE IT
		AND #$0F
a200	STA PWHIGHO,X
		RTS
BIGFX0F ;'F' = FILTER-CUTOFF-HIGH BYTE SETTING
a201	STA FLSHIFT+1 ;SHIFTS OVERALL FILTER WITH THIS AMOUNT (80..$FF:NEGATIVE, 00..$70:POSITIVE)
		RTS

;------------------------------------------------------------------
BIGFX10 ;SET MAIN SINGLETEMPO
		ORA #$80 ;SINGLE TEMPO, NOT CONTINUED TO FUNKTEMPO OR TEMPOPROGRAM
MAINTMP	;ENTRY POINT USED BY OTHER SPEED-SETTERS
p_tmpt6	STA TEMPOTBL+0 ;1ST SPEED VALUE
		LDA #0 ;RESET TRACK-TEMPOPOINTERS TO 1ST TEMPOTABLE-POSITION
MAINTM2
a202	STA TMPPOS+0
a203	STA TMPPOS+7
a204	STA TMPPOS+2*7
a205	STA TMPPTR+0
a206	STA TMPPTR+7
a207	STA TMPPTR+2*7
		RTS

BIGFX11 ;SET MAIN FUNKTEMPO SPEED 1 AND SPEED 2
.IF TEMPOPRGSUPP_ON
		PHA
		AND #$0F ;SET 2ND FUNKTEMPO
		ORA #$80 ;THE TEMPOPROGRA STOPS HERE
p_tmpt7	STA TEMPOTBL+1
		PLA
		#DIVIDE8 ;/8
		LSR ;/16
a72b	JMP MAINTMP ;SET 1ST FUNKTEMPO, RESET TABLEPOINTERS
.FI		

BIGFX12 ;SET MAIN TEMPOPROGRAM
.IF TEMPOPRGSUPP_ON
		BEQ RTBIGFX ;NO TEMPOPROGRAM 0
		TAY
p_tmpp1	LDA TEMPTRLO,Y
a73b	JMP MAINTM2
.FI		

BIGFX13  ;SET TRACK SINGLETEMPO
.IF TEMPOPRGSUPP_ON
TRAKTMP	ORA #$80 ;MAKE THE TEMPOPROGRAM STOP HERE
TRKTMP2	LDY TRKTMPOS,X ;GET POSITION OF TRACKTEMPO IN TEMPOTABLE (2,4,6)
p_tmpt8	STA TEMPOTBL,Y
		TYA
TRKTMP3	STA TMPPTR,X
a74b	STA TMPPOS,X
.FI		
		RTS

BIGFX14 ;SET TRACK FUNKTEMPO SPEED 1 AND SPEED 2
.IF TEMPOPRGSUPP_ON
		PHA
		#DIVIDE8 ;/8
		LSR ;/16
a75b	JSR TRKTMP2
		PLA
		AND #$0F ;SET 2ND FUNKTEMPO
		ORA #$80
p_tmpt9	STA TEMPOTBL+1,Y ;SET 2ND FUNKTEMPO (Y CALCULATED IN SUBROUTINE PREVIOUSLY)
.FI		
		RTS
;		
BIGFX15 ;SET TRACK TEMPOPROGRAM
.IF TEMPOPRGSUPP_ON
		BEQ RTBIGFX
		TAY
p_tmpp2	LDA TEMPTRLO,Y
a76b	JMP TRKTMP3
.FI		

BIGFX16 ;?...LEFT FOR EXPANSION
BIGFX17 ;?...LEFT FOR EXPANSION
BIGFX18 ;?...LEFT FOR EXPANSION
BIGFX19 ;?...LEFT FOR EXPANSION
BIGFX1A ;?...LEFT FOR EXPANSION
BIGFX1B ;?...LEFT FOR EXPANSION
BIGFX1C ;?...LEFT FOR EXPANSION

BIGFX1D ;'D' = DELAY TRACK BY $00..$FE FRAMES
.IF DELAYSUPPORT_ON
DELAYER	LDY TRDELAY,X
		BNE + ;$00 SIGNS ENDING OF DELAYER-LOOP
		LDA #$FF ;PREPARINGING THE NEXT POSSIBLE DELAY
a77b	STA TRDELAY,X ;FINISH DELAY BY NOT DISTURBING SPDCNT,X
		RTS
+		CPY #$FF ;$FF SIGNS BEGINNING OF DELAYER LOOP
		BNE +
a78b	STA TRDELAY,X ;IF STARTING DELAY, WRITE ACCU TO DELAY-COUNTER 
+		LDA #2 ;THIS STOPS THE TRACK FOR A WHILE
a79b	STA SPDCNT,X
a80b	DEC TRDELAY,X ;COUNTING DELAY
		RTS
.FI		

BIGFX1E ;DELAY ACTUAL NOTE BY $00..$FF FRAMES
.IF DELAYSUPPORT_ON
a81b	LDY TRDELAY,X
		BNE a84b ;$00 SIGNS ENDING OF DELAYER-LOOP
		CLC
a82b	ADC SPDCNT,X
a83b	STA SPDCNT,X ;COMPENSATE CAUSED DELAY BY INCREASING SPEED-COUNTER
a84b	JMP DELAYER 
.FI

BIGFX1F ;?...LEFT FOR EXPANSION
		
RTBIGFX	RTS

.IF COMPILEDAPP=1 ;TO CHECK THE SIZE OF PLAYER-CODE FROM MONITOR-PROGRAM
.TEXT"---END OF PLAYER-CODE---"
.FI
;******************************************************************************
