/* Sledge v1 */
#include "../unp64.h"
void Scn_SledgeHammer(unpstr *Unp)
{
    unsigned char *mem;
    int q,p;
    if ( Unp->IdFlag )
        return;
    mem=Unp->mem;
    if( Unp->DepAdr==0 )
    {
        if( (*(unsigned int*)(mem+0x816)==0x05A00185) &&
            (*(unsigned int*)(mem+0x81a)==0x9608EABE) &&
            (*(unsigned int*)(mem+0x889)==0xB104434C) &&
           ((*(unsigned int*)(mem+0x8c8)&0xff00ffff)==0x4C000185) )
        {
            Unp->EndAdr=0x2d;
            Unp->DepAdr=0x400;
            Unp->Forced=0x816;
            Unp->StrMem=mem[0x8ea]|mem[0x8eb]<<8;
            Unp->RetAdr=mem[0x8cc]|mem[0x8cd]<<8;
            PrintInfo(Unp, _I_SLEDGE10);
            Unp->IdFlag=1;return;
        }
        if( (*(unsigned int*)(mem+0x816)==0x05A00185) &&
            (*(unsigned int*)(mem+0x8C2)==0xAF86AE85) &&
           ((*(unsigned int*)(mem+0x889)&0xff00ffff)==0xB100434C) &&
           ((*(unsigned int*)(mem+0x8c8)&0xff00ffff)==0x4C000185) &&
            mem[0x80d]==0x78)
        {
            Unp->EndAdr=0x2d;
            Unp->DepAdr=mem[0x82e]|mem[0x82f]<<8;
            Unp->Forced=0x80d;
            Unp->StrMem=mem[0x8ea]|mem[0x8eb]<<8;
            Unp->RetAdr=mem[0x8cc]|mem[0x8cd]<<8;
            PrintInfo(Unp, _I_SLEDGE11);
            Unp->IdFlag=1;return;
        }
    }
    /* Sledge v1+/v1.2 */
    if( Unp->DepAdr==0 )
    {
        if(((*(unsigned int*)(mem+0x810)&0x00ffffff)==0x0000A978) &&
            (*(unsigned int*)(mem+0x894)            ==0xB1044e4C) &&
           ((*(unsigned int*)(mem+0x8d3)&0xff00ffff)==0x4C000185) )
        {
            Unp->EndAdr=0x2d;
            Unp->DepAdr=0x400;
            Unp->Forced=0x810;
            Unp->StrMem=mem[0x8ea]|mem[0x8eb]<<8;
            Unp->RetAdr=mem[0x8d7]|mem[0x8d8]<<8;
            PrintInfo(Unp, _I_SLEDGE12);
            Unp->IdFlag=1;return;
        }
    }
    /* Sledge II ($040b & $020b variants) */
    if( Unp->DepAdr==0 )
    {
        if((mem[0x80d]==0x78) && (mem[0x87d]==0x4c) &&
           (*(unsigned int*)(mem+0x810)==0x018478A0) &&
           (*(unsigned int*)(mem+0x814)==0x990831B9) &&
           (*(unsigned int*)(mem+0x82c)==0x4CEED0CA) )
        {
            Unp->EndAdr=0x2d;
            Unp->DepAdr=mem[0x830]|mem[0x831]<<8; /* $40b, $20b, $33b */
            Unp->Forced=0x80d;
            Unp->RetAdr=mem[0x87e]|mem[0x87f]<<8;
            if((mem[0x831]==0x02)&&(mem[0x832]==0x8d))
                q=0x833;
            else
                q=0x859;
            Unp->StrMem=mem[q]|mem[q+1]<<8; // always $07e8...
            Unp->StrMem=desledge( 0x88c, 0x843, Unp->StrMem, mem );
            PrintInfo(Unp, _I_SLEDGE20);
            Unp->IdFlag=1;return;
        }
    }
    /* Sledge 2.1+ */
    if( Unp->DepAdr==0 )
    {
        if((mem[0x80e]==0xa2) &&
           (*(unsigned int*)(mem+0x810)==0x018478A0) &&
           (*(unsigned int*)(mem+0x814)==0x990831B9) &&
           (*(unsigned int*)(mem+0x82e)==0x01004CEE) &&
           (*(unsigned int*)(mem+0x84a)==0x8D014320) )
        {
            //Unp->EndAdr=0x2d;
            Unp->fEndAf=0x11c;
            Unp->DepAdr=0x100;
            Unp->Forced=0x80e;
            if(mem[0x872]==0x4c)
                Unp->RetAdr=mem[0x873]|mem[0x874]<<8;
            else
            {
                /* hacks have it anywhere here */
                for(p=0x868;p<=0x872;p++)
                {
                    if(mem[p]==0x4c)
                    {
                        Unp->RetAdr=mem[p+1]|mem[p+2]<<8;
                        break;
                    }
                }
            }
            Unp->StrMem=mem[0x84e]|mem[0x84f]<<8; // always $07e8...
            //p=0x881; // not fixed, must be calced, some are at $88c
            p=mem[0x81e]|mem[0x81f]<<8;
            p-=((mem[0x821]|mem[0x822]<<8)-(mem[0x876]|mem[0x877]<<8));
            Unp->StrMem=desledge( p, 0x838, Unp->StrMem, mem );
            PrintInfo(Unp, _I_SLEDGE21);
            Unp->IdFlag=1;return;
        }
    }
    /* Sledge II+ */
    if( Unp->DepAdr==0 )
    {
        if((*(unsigned int*)(mem+0x80d)==0x8D00A978) &&
           (*(unsigned int*)(mem+0x84b)==0x46CEF7D0) &&
           (*(unsigned int*)(mem+0x855)==0x050B4CEE) )
        {
            Unp->EndAdr=0x2d;
            Unp->DepAdr=0x50b;
            Unp->Forced=0x80d;
            Unp->RetAdr=mem[0x8a5]|mem[0x8a6]<<8;
            Unp->StrMem=mem[0x880]|mem[0x881]<<8;
            Unp->StrMem=desledge( 0x8e2, 0x86a, Unp->StrMem, mem );
            PrintInfo(Unp, _I_SLEDGE23);
            if(Unp->DebugP)
                if((*(unsigned int*)(mem+0x81d)==0x08BABD27) )
                    printmsg(mem,0x8ba,40);
            Unp->IdFlag=1;return;
        }
    }
    /* Sledge 2.2/CCS always all mem 07e8-ffff */
    if( Unp->DepAdr==0 )
    {
        if((mem[0x801]==0x78) && (mem[0x802]==0xa0) &&
           (*(unsigned int*)(mem+0x804)==0x018654A2) &&
           (*(unsigned int*)(mem+0x808)==0x950812BD) &&
           (*(unsigned int*)(mem+0x810)==0xBD00024C) &&
           (*(unsigned int*)(mem+0x833)==0xA8004B20))
        {
            Unp->fEndAf=0x2e;
            Unp->DepAdr=0x2;
            Unp->Forced=0x801;
            Unp->RetAdr=mem[0x85a]|mem[0x85b]<<8;
            Unp->StrMem=mem[0x83f]|mem[0x840]<<8;
            Unp->StrMem=desledge( 0x866, 0x829, Unp->StrMem, mem );
            PrintInfo(Unp, _I_SLEDGE2C);
            Unp->IdFlag=1;return;
        }
    }
    /* Sledge 2.2? always all mem 07e8-ffff */
    if( Unp->DepAdr==0 )
    {
        if((*(unsigned int*)(mem+0x80b)==0xA27800A0) &&
           (*(unsigned int*)(mem+0x810)==0x30B90184) &&
           (*(unsigned int*)(mem+0x814)==0x04009908) &&
           (*(unsigned int*)(mem+0x857)==0xCCEFD088))
        {
            Unp->fEndAf=0x41a;
            //end_add=0xffff;
            Unp->DepAdr=0x400;
            Unp->Forced=0x80b;
            Unp->RetAdr=mem[0x865]|mem[0x866]<<8;
            Unp->StrMem=mem[0x84a]|mem[0x84b]<<8; // always $07e8...
            Unp->StrMem=desledge( 0x873, 0x836, Unp->StrMem, mem );
            PrintInfo(Unp, _I_SLEDGE22);
            Unp->IdFlag=1;return;
        }
    }
    /* Sledge v3 */
    if( Unp->DepAdr==0 )
    {
        if((*(unsigned int*)(mem+0x82e)==0x8530A978) &&
           (*(unsigned int*)(mem+0x8a3)==0xC804CFAC) &&
           (*(unsigned int*)(mem+0x875)==0x04284CF1) )
        {
          //  Unp->EndAdr=0xfd; /* not necessarily true */
          //  Unp->DepAdr=0x428;
            Unp->DepAdr=0x443 ;
            Unp->MonEnd=0x00fd<<16|0x00fe;
            Unp->Forced=0x82f;
            Unp->RetAdr=mem[0x8c9]|mem[0x8ca]<<8;
            Unp->StrMem=mem[0x94d]|mem[0x94e]<<8;
            PrintInfo(Unp, _I_SLEDGE30);
            if(Unp->DebugP)
                if((*(unsigned int*)(mem+0x81e)&0x00ffffff)==0x00A927A2 )
                    printmsg(mem,0x87b,40);
            Unp->IdFlag=1;return;
        }
    }
    /* Trap/Bonzai packer, probably derived from SledgeHammer 2.x */
    if( Unp->DepAdr==0 )
    {
        if((*(unsigned int*)(mem+0x812)==0x8478A078) &&
           (*(unsigned int*)(mem+0x816)==0x0836B901) &&
           (*(unsigned int*)(mem+0x81a)==0x8800FF99) &&
           (*(unsigned int*)(mem+0x85a)==0xD00121EE) )
        {
            Unp->DepAdr=0x100;
            Unp->Forced=0x812;
            Unp->StrMem=mem[0x858]|mem[0x859]<<8;
            Unp->StrMem=desledge( 0x87f, 0x83f, Unp->StrMem, mem );
            Unp->RetAdr=mem[0x871]|mem[0x872]<<8;
            Unp->fEndAf=0x121;
            PrintInfo(Unp,_I_SLEDGETRAP);
            Unp->IdFlag=1;return;
        }
    }
}
/*
Note about Sledge 3
Found a packed program that's a result of a "inside" linking. That's worst than
overlapping.
At first I thought that some bugged SH3 did not sort the load address, but
after tracing it in vicemonitor i've found that SH3 has no error.

2 parts were linked like this
1: $1000-$8711
2: $2000-$5000

as a result, for unp64, the final address in $fd/$fe is $5000, not $8711

If I find the same problem on other SH I'd have to set a monitored pointer
for the Unp->EndAdress. Shouldn't be the case as it seems that older versions set
$2d/2e themselves.
Luckily at least startaddress of all linked parts are already sorted by
SH3, I've made many tests changing order from the selector and even swapping
them phisically on the disk. =)
*/
