#!/bin/sh
# based on make-bindist.sh from VICE,
# written by Marco van den Heuvel <blackystardust68@yahoo.com>
#
# makebindist.sh <strip> <version> <top-srcdir> <exeext>
#                $1      $2        $3           $4

STRIP=$1
AFVERSION=$2
TOPSRCDIR=$3
EXEEXT=$4

AFTOOLS="aftool afgui"
AFFWS="afminitools afminitools_slot1"
DOCS="README NEWS"
SUBDIRDOCS="README_tool README_gui README_fw"

for i in $AFTOOLS
do
    if [ ! -e src/$i$EXEEXT ]; then
        echo Error: executable file\(s\) not found, do a \"make\" first
        exit 1
    fi
done

for i in $AFFWS
do
    if [ ! -e firmware/$i.crt ]; then
        echo Error: firmware file\(s\) not found, do a \"make\" first
        exit 1
    fi
done

DIRNAME=afapack-$AFVERSION

echo Generating binary distribution.
rm -f -r $DIRNAME
mkdir $DIRNAME

for i in $AFTOOLS
do
    $STRIP src/$i$EXEEXT
    cp src/$i$EXEEXT $DIRNAME/$i$EXEEXT
done

for i in $AFFWS
do
    cp -a firmware/$i.crt firmware/$i.bin $DIRNAME
done

for i in $DOCS
do
    cp -a $TOPSRCDIR/$i $DIRNAME/$i.txt
    unix2dos $DIRNAME/$i.txt
done

for i in $SUBDIRDOCS
do
    cp -a $TOPSRCDIR/doc/$i $DIRNAME/$i.txt
    unix2dos $DIRNAME/$i.txt
done

zip -r -9 -q $DIRNAME.zip $DIRNAME
rm -f -r $DIRNAME

echo Binary distribution archive generated as $DIRNAME.zip
