#ifndef AFTT_H
#define AFTT_H

#include <stdio.h>

extern int aftt_run(FILE *fd_i, FILE *fd_o, int vlevel, int fd_usb);
extern int aftt_save(const char *filename, unsigned char *data, size_t datasize, unsigned int start_addr);
extern int aftt_usb_send(unsigned char *data, size_t datasize, unsigned int addr, int romh_too, int keep_old, int do_erases);
extern int aftt_usb_load(int offset, int offset_end, int romh_too);

extern int set_usb_read_blocksize(int argc, char **argv);
extern int set_usb_write_blocksize(int argc, char **argv);
#define AFTT_USB_WRITE_BLOCKSIZE_MAX    0xffff
extern int set_dummy_erase_amount(int argc, char **argv);
extern int set_dummy_prog_amount(int argc, char **argv);
extern int set_do_erases(int argc, char **argv);

#endif
