#ifndef AFUSB_H
#define AFUSB_H

extern int afusb_select_driver(const char *driver_name);
extern const char *afusb_get_driver_name(void);
extern int afusb_driver_has_params(void);
extern int afusb_driver_has_eepromdump(void);
extern int afusb_is_connected(void);

extern int afusb_init(void);
extern int afusb_get_fd(void);
extern int afusb_shutdown(void);
extern int afusb_write(int fd, const unsigned char *data, int num);
extern int afusb_read(int fd, unsigned char *data, int num);
extern int afusb_set_device_param(int argc, char **argv);
extern int afusb_get_device_param(const char **param);
extern int afusb_set_eeprom_dump_name(int argc, char **argv);


/* Alien Flash USB defines */

#define AFUSB_VID   0x0403
#define AFUSB_PID   0x6001
#define AFUSB_NAME  "Alien Flash"
#define AFUSB_BAUDRATE 3000000


/* for param help text */

#define AFUSB_MAGIC_D2XX_OFF_STRING     "setvcpmode"
#define AFUSB_MAGIC_D2XX_ON_STRING      "setd2xxmode"
#define AFUSB_MAGIC_EEPROM_DUMP_STRING  "dumpeeprom"

#define AFUSB_LINUX_DEFAULT_VALUE   "/dev/ttyUSB0"
#define AFUSB_WIN32_DEFAULT_VALUE   "37"

/* driver specific, for internal use only! */
#ifdef AFUSB_INTERNAL_API
extern int afusb_dummy_init(void);
extern int afusb_dummy_get_fd(void);
extern int afusb_dummy_shutdown(void);
extern int afusb_dummy_write(int fd, const unsigned char *data, int num);
extern int afusb_dummy_read(int fd, unsigned char *data, int num);
extern int afusb_dummy_set_device_param(char *param);
extern int afusb_dummy_get_device_param(const char **param);
extern int afusb_linux_init(void);
extern int afusb_linux_get_fd(void);
extern int afusb_linux_shutdown(void);
extern int afusb_linux_write(int fd, const unsigned char *data, int num);
extern int afusb_linux_read(int fd, unsigned char *data, int num);
extern int afusb_linux_set_device_param(char *param);
extern int afusb_linux_get_device_param(const char **param);
extern int afusb_win32_init(void);
extern int afusb_win32_get_fd(void);
extern int afusb_win32_shutdown(void);
extern int afusb_win32_write(int fd, const unsigned char *data, int num);
extern int afusb_win32_read(int fd, unsigned char *data, int num);
extern int afusb_win32_set_device_param(char *param);
extern int afusb_win32_get_device_param(const char **param);
extern int afusb_ftdi_init(void);
extern int afusb_ftdi_get_fd(void);
extern int afusb_ftdi_shutdown(void);
extern int afusb_ftdi_write(int fd, const unsigned char *data, int num);
extern int afusb_ftdi_read(int fd, unsigned char *data, int num);
extern int afusb_ftdi_set_device_param(char *param);
extern int afusb_ftdi_get_device_param(const char **param);
extern int afusb_ftdi_set_eeprom_dump_name(int argc, char **argv);
extern int afusb_ftd2xx_init(void);
extern int afusb_ftd2xx_get_fd(void);
extern int afusb_ftd2xx_shutdown(void);
extern int afusb_ftd2xx_write(int fd, const unsigned char *data, int num);
extern int afusb_ftd2xx_read(int fd, unsigned char *data, int num);
extern int afusb_ftd2xx_set_device_param(char *param);
extern int afusb_ftd2xx_get_device_param(const char **param);
extern int afusb_ftd2xx_set_eeprom_dump_name(int argc, char **argv);
#endif /* AFUSB_INTERNAL_API */

#endif
