/*
 * afusb_dummy.c - dummy Alien Flash USB access
 */

#include <stdio.h>
#include <string.h>

#include "afusb.h"
#include "config.h"
#include "util.h"

static const char *afusb_dump_name = "";
static FILE *afusb_dump_fd = NULL;

/* -------------------------------------------------------------- */

int afusb_dummy_set_device_param(char *param)
{
    afusb_dump_name = param;
    util_message("Dumping sent bytes to '%s'.", afusb_dump_name);
    return 0;
}

int afusb_dummy_get_device_param(const char **param)
{
    *param = afusb_dump_name;
    return 0;
}

/* -------------------------------------------------------------- */

static int dummy_fd = -1;

int afusb_dummy_init(void)
{
    FILE *fd;

    util_message("dummy driver init.");

    if (*afusb_dump_name == '\0') {
        dummy_fd = 0;
        return 0;
    }

    util_message("Dumping sent data to '%s'.", afusb_dump_name);

    fd = fopen(afusb_dump_name, "wb");

    if (fd == NULL) {
        util_error("problems creating file '%s'!", afusb_dump_name);
        return -1;
    }

    afusb_dump_fd = fd;
    dummy_fd = 1;
    return 0;
}

int afusb_dummy_get_fd(void)
{
    return dummy_fd;
}

int afusb_dummy_shutdown(void)
{
    util_message("dummy driver shutdown");

    if (afusb_dump_fd != NULL) {
        fclose(afusb_dump_fd);
        afusb_dump_fd = NULL;
    }

    dummy_fd = -1;
    return 0;
}

int afusb_dummy_write(int fd, const unsigned char *data, int num)
{
    size_t n = (size_t)num;

    if (dummy_fd < 0) {
        return -1;
    }

    if (afusb_dump_fd != NULL) {
        n = fwrite(data, 1, (size_t)num, afusb_dump_fd);
    }

    if (n != (size_t)num) {
        util_error("problems dumping to file '%s'!", afusb_dump_fd);
        fclose(afusb_dump_fd);
        return -1;
    }

    return n;
}

int afusb_dummy_read(int fd, unsigned char *data, int num)
{
    if (dummy_fd >= 0) {
        memset(data, 0xff, num);
        return num;
    }

    return dummy_fd;
}
