#ifndef CART_H
#define CART_H

#define CARTRIDGE_ACTION_REPLAY         1
#define CARTRIDGE_EASYFLASH            32
#define CARTRIDGE_ALIEN_FLASH          53

extern int afcart_save(const char* filename, int offset, int offset_end);
extern int afcart_load(const char* filename);
extern int efcart_save(const char* filename, int offset, int offset_end);
extern int anycart_load(const char* filename, int *offset, unsigned int *last_addr, int *romh_too);
extern int arcart_save(const char* filename, int offset, int banks, int crt_id);

extern int detect_cart_type(const char* filename, int *default_offset, int *crt_id, const char **cart_name);

extern int bin_save(const char* filename, int offset, int offset_end);

extern int detect_aftt_header(int base, int type, int *len_out, char *buf, int *load_out);
extern int has_aftt_file(int type, char *buf);

extern int af_check_empty(const unsigned char *data);

#endif
