#include <atari.h>
#include <stdio.h>
#include <string.h>
#include <peekpoke.h>

#define SCREEN_SIZE 40
#define RANDOM PEEK(0xD20A)
#define set_char(x,y,a) video_ptr[(x)+(y)*SCREEN_SIZE]=(a);
#define pmg_memory 0x3800
#define pmg_memory_ptr ((unsigned char *) 0x3800)

#include "atari_defs.h"
#include "sounds.h"

/*
2000 - 2400 - fonty (1kb)
2400 - 3000 - wyrazy (3kb)
3000 - 3800 - DLI (2kb)
3800 - 4000 - PMG (2kb)
4000 - 4400 - fonty2 (1kb)
4400 - 5000 - 3 charesty na panel
5000 - 8000 - 12 kb muza
*/

unsigned char *dl_ptr;
unsigned char *p_ptr = 0x3800;
unsigned char *video_ptr;
unsigned char *wrd_ptr;
unsigned char let;
unsigned char kb[] = { 63,21,18,58,42,56,61,57,13,1,5,0,37,35,8,10,40,62,45,11,254,46,22,43,23};
unsigned char st[] = {0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,0};
unsigned char pl[14][6];
unsigned char *wrd;
unsigned char i,j,k,l;
unsigned int z;
unsigned char level;
unsigned char time;
unsigned char cycle;
unsigned char lines;
unsigned char ydot;
unsigned char ylet;
unsigned char punish;

void init_pmg()
{

POKE(SDMCTL,DMACTL_ENABLE_PLAYER_DMA | DMACTL_ENABLE_MISSLE_DMA | DMACTL_NORMAL_PLAYFIELD | DMACTL_SINGLE_LINE_RESOLUTION | DMACTL_DMA_FETCH_INSTRUCTION);

// PMBASE points to our PMG memory page (page has 256 bytes)
POKE(PMBASE,pmg_memory/256);
POKE(53259,1);
POKE(53260,255);

// init pmg memory
//this is funny part :)
//please be informed, that because of lack of time (deadline) I've created it:)

memset(pmg_memory_ptr,255,2048);
memset(pmg_memory_ptr+1024+512,0,256);
memset(pmg_memory_ptr+1024+557,255,102);
memset(pmg_memory_ptr+1024+512+256,0,256);
memcpy(pmg_memory_ptr+1024,st,sizeof(st));

//panel
memset(pmg_memory_ptr+1024+256+50,0,110);
memset(pmg_memory_ptr+1024+256+160,239,1);
memset(pmg_memory_ptr+1024+256+161,0,2);
memset(pmg_memory_ptr+1024+256+163,143,1);
memset(pmg_memory_ptr+1024+161,0,1);

memset(pmg_memory_ptr+768+40,0,120);
memset(pmg_memory_ptr+768+161,0,2);

memset(pmg_memory_ptr+768+164,16+32,29); 
memset(pmg_memory_ptr+768+166,12+32+16,19);

memset(pmg_memory_ptr+768+190,16,2);
memset(pmg_memory_ptr+768+192,2+16,6);

memset(pmg_memory_ptr+768+198,2+16+1,6);
memset(pmg_memory_ptr+768+204,3,12);

memset(pmg_memory_ptr+768+212,3+16+32,3);

//memset(pmg_memory_ptr+768+196,1,24);
memset(pmg_memory_ptr+768+216,0,32);
memset(pmg_memory_ptr+768+214,16+32,1);


memset(pmg_memory_ptr+1024+164,0,6);
memset(pmg_memory_ptr+1024+170,4,3);
memset(pmg_memory_ptr+1024+176,31,5);
memset(pmg_memory_ptr+1024+189,128+64+32+16+8+4,1);
memset(pmg_memory_ptr+1024+190,128+64+32+16,1);
memset(pmg_memory_ptr+1024+191,128,1);
memset(pmg_memory_ptr+1024+192,128+64+32+16,1);
memset(pmg_memory_ptr+1024+193,255-4,1);
memset(pmg_memory_ptr+1024+194,255,1);
memset(pmg_memory_ptr+1024+195,255-28,1);
memset(pmg_memory_ptr+1024+196,255-32-16-8,1);
memset(pmg_memory_ptr+1024+197,255-32-16-8,1);
memset(pmg_memory_ptr+1024+198,255-64-32-16,1);
memset(pmg_memory_ptr+1024+199,255-32,1);
memset(pmg_memory_ptr+1024+200,255-8,1);
memset(pmg_memory_ptr+1024+201,255-8,1);
memset(pmg_memory_ptr+1024+202,255-32-16-8-4,1);
memset(pmg_memory_ptr+1024+203,255-32-16-8,1);
memset(pmg_memory_ptr+1024+204,255-64-32-16-8-4,1);
memset(pmg_memory_ptr+1024+205,255-64-32-16-8-4-2,1);
memset(pmg_memory_ptr+1024+206,3,1);
memset(pmg_memory_ptr+1024+207,255-128-64-16-8-4-2,1);
memset(pmg_memory_ptr+1024+208,255-128-64-32-16-8-4,1);
memset(pmg_memory_ptr+1024+209,255-128-64-32-16-8-4-2,1);
memset(pmg_memory_ptr+1024+210,255-128-64-32-8-4,1);
memset(pmg_memory_ptr+1024+211,0,1);
memset(pmg_memory_ptr+1024+212,255,5);

memset(pmg_memory_ptr+1024+214,0,1);
memset(pmg_memory_ptr+1024+216,0,32);
memset(pmg_memory_ptr+1024+216+256,0,32);


memset(pmg_memory_ptr+1024+256+164,0,11);
memset(pmg_memory_ptr+1024+256+175,4+2,2);
memset(pmg_memory_ptr+1024+256+177,8+4+2,6);
memset(pmg_memory_ptr+1024+256+183,16+8+4+2,5);
memset(pmg_memory_ptr+1024+256+188,16+8+4+2,5);
memset(pmg_memory_ptr+1024+256+193,0,4);
memset(pmg_memory_ptr+1024+256+197,1,1);
memset(pmg_memory_ptr+1024+256+198,3,2);
memset(pmg_memory_ptr+1024+256+200,15,2);
memset(pmg_memory_ptr+1024+256+202,15+16+32+64,7);
memset(pmg_memory_ptr+1024+256+209,14+16+32+64,1);
memset(pmg_memory_ptr+1024+256+214,0,1);
memset(pmg_memory_ptr+1024+256+212,7+128+64,2);
memset(pmg_memory_ptr+1024+256+215,7+128+64+32,1);

memset(pmg_memory_ptr+1024+256+210,32+16+8,2);



// turn on PMG for players and missiles
POKE(GRACTL,PMG_PLAYERS | PMG_MISSILES);
// set PMG priority
POKE(GPRIOR,1);

POKE(709,0);
POKE(710,0);

POKE(PCOLR2,0x80);
POKE(PCOLR3,0xCC);
POKE(HPOSP2,0);
POKE(HPOSP3,0);

memcpy(0x4000,0x2000,1024);

video_ptr=(unsigned char*)(PEEKW( PEEKW(560)+4 )); 
  set_char(0,0,0);
  
  //init panel
     i=40;
     for (z=640; z<960; z++) {
         video_ptr[z]=i;
         i++; 
         if (i>119) i=0;
      }

dl_ptr = (unsigned char*)PEEKW(560);
POKE(dl_ptr+6,PEEK(dl_ptr+6)+128);
POKEW(512,0x3000);
POKE(54286,192);


POKE(709,15);
POKE(710,0);

init_sfx();
stop_music();

}



int putLetter(unsigned char l, unsigned char x,unsigned char y) {

  if (l==255) {
    
   	set_char(x,y,0);
	set_char(x+1,y,0);
	set_char(x,y+1,0);
	set_char(x+1,y+1,0);	  
	
    return 0;
  }

  	set_char(x,y,l);
	set_char(x+1,y,l+1);
	set_char(x,y+1,l+2);
	set_char(x+1,y+1,l+3);	  

  return 0;
}

unsigned char getLetter(unsigned char key) {

  if (key==63) 
	return 1;//a
        
  if (key==21) 
	return 5;//b

  if (key==18) 
	return 9;//c

  if (key==58) 
	return 13;//d

  if (key==42) 
	return 17;//e

  if (key==56) 
	return 21;//f

  if (key==61) 
	return 25;//g

  if (key==57) 
	return 29;//h

  if (key==13) 
	return 33;//i

  if (key==1) 
	return 37;//j

  if (key==5) 
	return 41;//k

  if (key==0) 
	return 45;//l

  if (key==37) 
	return 49;//m

  if (key==35) 
	return 53;//n

  if (key==8) 
	return 57;//o

  if (key==10) 
	return 61;//p

  if (key==40) //r
	return 65;

  if (key==62) //s
	return 69;

  if (key==45) //t
	return 73;

  if (key==11) //u
	return 77;

  if (key==254) //v
	return 1;

  if (key==46) //w
	return 85;

  if (key==22) //x
	return 1;

  if (key==43) //y
	return 93;

  if (key==23) //z
	return 97;
  

  return 255;

}

void incLevel() {
     
     
     cycle=255;
     time = 255-level;
     level++;
     
     if (level<3) {
       lines=2;
       ydot=4;
       ylet=7;
       punish = 20;
       return;                   
     }         

     if (level>2 && level<10) {
       lines=3;
       ydot=3;
       ylet=6;
       punish = 30;
       return;                   
     }
      
     if (level>9 && level<25) {
       lines=4;
       ydot=3;
       ylet=5;
       punish = 30;
       return;                   
     }          
              
     lines=5;
     ydot=2;
     ylet=4;
     punish = 50;
     
     }

void initT(unsigned char* wrd) {


     if (level==0) {
        POKE(HPOSP2,0);      
        POKE(HPOSP3,0);                 
        for (z=0; z<1024; z++) {
            memset(0x2000+z,0,1);
        }           
        memset(video_ptr,0,640);
        
        POKE(764,255);
        let=255;
        
        putLetter(5,11,3);
        putLetter(45,13,3);
        putLetter(1,15,3);
        putLetter(29,17,3);
        
        putLetter(5,21,3);
        putLetter(45,23,3);
        putLetter(1,25,3);
        putLetter(29,27,3);
        
      
        putLetter(1,14,6);
        putLetter(25,16,6);
        putLetter(17,18,6);
        putLetter(53,20,6);
        putLetter(13,22,6);
        putLetter(1,24,6);
        
       
       for (z=0; z<1024; z++) {
            memcpy(0x2000+z,0x4000+z,1);
        }
 
        while (let==255) {        
              let=PEEK(764);
              POKE(77,0);
        }      
          
     }

     incLevel();
     memset(pmg_memory_ptr+1024+512+256+195,level,3);
     memset(pmg_memory_ptr+1024+512+256+200,255-level,3);
     
     if (level<2) {
          POKE(HPOSP2,255);
      
      } else {
        for (i=0; i<255; i++) {
          for (j=0; j<15; j++);
          POKE(PCOLR2,i);
        }      
        POKE(PCOLR2,0x80);
        POKE(HPOSP2,255);
     }

     for (z=0; z<1024; z++) {
       memset(0x2000+z,0,1);
     }
     
     memset(video_ptr,0,640);

       for (i=0; i<14; i++) {
	  for (j=0; j<lines; j++) {

	  let = RANDOM % 24;
          pl[i][j]=kb[let];
	
	}
	
	let = RANDOM % lines;
	pl[i][let]=wrd[i];

      }
      
      for (i=0; i<14; i++) {
	     for (j=0; j<lines; j++) {
             putLetter(getLetter(pl[i][j]),6+i*2,ylet+j*2);          
         }
         putLetter(101,6+i*2,ydot);
      }
      
      putLetter(105,6,0);
      putLetter(109,6,14);
      
      
      for (z=0; z<1024; z++) {
       memcpy(0x2000+z,0x4000+z,1);
      }
      
      POKE(HPOSP2,72);
      for (i=0; i<255; i++) {
          for (j=0; j<15; j++);
          POKE(PCOLR2,i);
      }
      
      POKE(PCOLR2,0x80);
      POKE(HPOSP3,68);
      
}

void clock() {
     
     cycle--;
     
     if (cycle==0) {
        time--;
        cycle=255;  
        memset(pmg_memory_ptr+1024+512+256+171,time,3);         
     }
     memset(pmg_memory_ptr+1024+512+256+176,cycle,3);              
     
     }
     
void gameOver() {
     
POKE(HPOSP2,0);      
        POKE(HPOSP3,0);                 
        for (z=0; z<1024; z++) {
            memset(0x2000+z,0,1);
        }           
        memset(video_ptr,0,640);
        
        POKE(764,255);
        let=255;
        
        putLetter(41,10,3);
        putLetter(57,12,3);
        putLetter(53,14,3);
        putLetter(33,16,3);
        putLetter(17,18,3);
        putLetter(9,20,3);
        
        putLetter(25,24,3);
        putLetter(65,26,3);
        putLetter(93,28,3);
                
        
        putLetter(57,7,9);
        putLetter(69,9,9);
        putLetter(73,11,9);
        putLetter(1,13,9);
        putLetter(73,15,9);
        putLetter(53,17,9);
        putLetter(33,19,9);
        
        putLetter(85,23,9);
        putLetter(93,25,9);
        putLetter(65,27,9);
        putLetter(1,29,9);
        putLetter(97,31,9);
        
        for (i=0; i<14; i++) {
            putLetter(getLetter(wrd[i]),6+i*2,12);  
        }    
        
       for (z=0; z<1024; z++) {
            memcpy(0x2000+z,0x4000+z,1);
        }
 
        while (let==255) {        
              let=PEEK(764);
              POKE(77,0);
        }
     
}          

int main(void)
{
  _graphics(0);
  init_pmg();
  
  
  wrd_ptr=(unsigned char*)0x2400;
  POKE(0x02F4,0x0020);


     level=0;
       
     wrd=wrd_ptr + (RANDOM % 190)*16;
         
     initT(wrd);
        
     i=0;   

     for (;;) {

      POKE(77,0);
	  let=PEEK(764);

      if (wrd[i]!=let && let!=255) {            
          if (time>punish) {              
             time=time-punish;
           } else {
             time=0;     
           }              
           POKE(764,255);
           for (z=1; z<255;z++) POKE(PCOLR3,z);          
           POKE(PCOLR3,0x50);
      }

	  if (wrd[i]==let) {
         
         if (i<13) {
            putLetter(255,6+i*2,0);              
            putLetter(255,6+i*2,14);
         }
	     
         putLetter(getLetter(let),6+i*2,ydot);
         i++;
	     
	     if (time<64) { 
             time=time+3;
         }
	     
	     if (i<14) {
	        putLetter(105,6+i*2,0);
	        putLetter(109,6+i*2,14);
	        POKE(HPOSP2,72+i*8);
         }
         for (z=1; z<255;z++);
         POKE(764,255);
      }	   
      

      clock();
      
      if (time==0) {
         gameOver();          
         level=0;
         i=14;          
      }
           
      if (i==14) {
         wrd=wrd_ptr + (RANDOM % 190)*16;        
         //j = RANDOM % 191;
         //wrd=wrd_ptr+j*16;
         //if (j>51) wrd=wrd+2;
         
         initT(wrd);
         i=0;
      }           
  }
   
  return 0;
}


